<!-- Thermal Print Layout -->
<div class="invoice-container thermal-printer">
    <style>
        .thermal-printer {
            width: 72mm;
            font-family: 'Courier New', monospace;
            font-size: 12px;
            margin: 0;
            padding: 10px;
        }
        .thermal-printer h4 {
            text-align: center;
            margin: 0 0 10px 0;
            font-size: 14px;
        }
        .thermal-printer .company-info {
            text-align: center;
            margin-bottom: 10px;
            border-bottom: 1px dashed #000;
            padding-bottom: 5px;
        }
        .thermal-printer .company-info h5 {
            margin: 0;
            font-size: 13px;
            font-weight: bold;
        }
        .thermal-printer .company-info p {
            margin: 2px 0;
            font-size: 10px;
        }
        .thermal-printer table {
            width: 100%;
            border-collapse: collapse;
            margin: 10px 0;
        }
        .thermal-printer th, .thermal-printer td {
            padding: 2px;
            text-align: left;
            font-size: 10px;
        }
        .thermal-printer .total {
            text-align: center;
            font-weight: bold;
            margin-top: 10px;
            border-top: 1px dashed #000;
            padding-top: 5px;
        }
    </style>

    <!-- Company Header -->
    <div class="company-info">
        @if(isset($all_settings) && $all_settings)
            <h5>{{ $all_settings->company_name ?? 'POS System' }}</h5>
            @if($all_settings->address)
                <p>{{ $all_settings->address }}</p>
            @endif
            @if($all_settings->number)
                <p>Tel: {{ $all_settings->number }}</p>
            @endif
            @if($all_settings->company_email)
                <p>{{ $all_settings->company_email }}</p>
            @endif
            @if($all_settings->company_registration_number)
                <p>Reg: {{ $all_settings->company_registration_number }}</p>
            @endif
        @else
            <h5>Your Company, Inc.</h5>
            <p>Company Address</p>
            <p>Phone Number</p>
        @endif
    </div>

    <h4>Sales Invoice</h4>
    <p>Date: {{ \Carbon\Carbon::parse($sale->sale_date)->format('Y-m-d H:i') }}</p>
    <p>Customer: {{ $sale->customer_name }}</p>
    <p>Invoice: #{{ $sale->id ?? 'INV-001' }}</p>

    <table>
        <tr>
            <th>Item</th>
            <th>Qty</th>
            <th>Price</th>
        </tr>
        <tr>
            <td>{{ $sale->product->brand ?? 'Product' }}</td>
            <td>{{ $sale->sold_quantity ?? 1 }}</td>
            <td>{{ ($all_settings->currency ?? env('APP_CURRENCY', '$')) . number_format($sale->sell_price, 2) }}</td>
        </tr>
    </table>

    <div class="total">
        <p><strong>Total: {{ ($all_settings->currency ?? env('APP_CURRENCY', '$')) . number_format($sale->sell_price * ($sale->sold_quantity ?? 1), 2) }}</strong></p>
    </div>

    <div style="text-align: center; margin-top: 10px; font-size: 10px;">
        <p>Thank you for your business!</p>
        @if(isset($all_settings) && $all_settings->website)
            <p>{{ $all_settings->website }}</p>
        @endif
    </div>
</div>
