<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Invoice - Quick Phone</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            line-height: 1.4;
            color: #333;
            margin: 0;
            padding: 0;
            background: white;
        }

        .invoice-container {
            width: 100%;
            max-width: 600px;
            margin: 0 auto;
            padding: 5px;
            box-sizing: border-box;
            font-size: 11px;
        }

        .invoice-header {
            text-align: center;
            border-bottom: 2px solid #000;
            padding-bottom: 5px;
            margin-bottom: 10px;
        }

        .company-logo {
            max-width: 80px;
            height: auto;
            margin-bottom: 5px;
        }

        .company-name {
            font-size: 18px;
            font-weight: bold;
            margin: 3px 0;
            text-transform: uppercase;
        }

        .company-details {
            font-size: 9px;
            line-height: 1.2;
            margin: 3px 0;
        }

        .invoice-info {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
            font-size: 10px;
        }

        .invoice-info div {
            flex: 1;
        }

        .customer-info {
            margin-bottom: 10px;
            font-size: 10px;
            border-bottom: 1px solid #000;
            padding-bottom: 5px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 10px;
            font-size: 10px;
        }

        th,
        td {
            border: 1px solid #000;
            padding: 3px 4px;
            text-align: left;
            vertical-align: top;
        }

        th {
            background-color: #f9f9f9;
            font-weight: bold;
            text-align: center;
            font-size: 9px;
        }

        .text-center {
            text-align: center;
        }

        .text-right {
            text-align: right;
        }

        .totals-section {
            width: 50%;
            margin-left: auto;
            margin-bottom: 10px;
        }

        .totals-section table {
            margin-bottom: 0;
        }

        .totals-section th,
        .totals-section td {
            padding: 2px 4px;
            font-size: 10px;
        }

        .invoice-footer {
            text-align: center;
            border-top: 1px solid #000;
            padding-top: 5px;
            font-size: 8px;
            margin-top: 10px;
        }

        .print-btn {
            display: block;
            margin: 20px auto;
            padding: 10px 20px;
            background-color: #007bff;
            color: white;
            border: none;
            cursor: pointer;
            font-size: 14px;
            border-radius: 4px;
        }

        .print-btn:hover {
            background-color: #0056b3;
        }

        @media print {
            body {
                font-size: 9px;
            }

            .print-btn {
                display: none;
            }

            .invoice-container {
                width: 100%;
                max-width: none;
                margin: 0;
                padding: 2px;
            }

            .company-logo {
                max-width: 60px;
            }

            th,
            td {
                padding: 2px 3px;
                border: 1px solid #000;
            }

            .invoice-header {
                margin-bottom: 5px;
                padding-bottom: 3px;
            }

            .invoice-info {
                margin-bottom: 5px;
            }

            .customer-info {
                margin-bottom: 5px;
                padding-bottom: 3px;
            }

            table {
                margin-bottom: 5px;
            }

            .totals-section {
                margin-bottom: 5px;
            }

            .invoice-footer {
                margin-top: 5px;
                padding-top: 3px;
            }
        }
    </style>
</head>

<body>
    <div class="invoice-container" id="invoice">
        <!-- Header -->
        <div class="invoice-header">
            <img src="{{ asset('images/company-logo.png') }}" alt="Company Logo" class="company-logo"
                onerror="this.style.display='none'">
            <div class="company-name">Quick Phone</div>
            <div class="company-details">
                Mobile Phone Store<br>
                Manama, Bahrain<br>
                Phone: +973 1234 5678 | Email: info@quickphone.com
            </div>
        </div>

        <!-- Invoice Info -->
        <div class="invoice-info">
            <div>
                <strong>Invoice No:</strong> INV-{{ $sale->id }}<br>
                <strong>Date:</strong> {{ $sale->created_at->format('d/m/Y') }}<br>
                <strong>Time:</strong> {{ $sale->created_at->format('H:i:s') }}
            </div>
            <div>
                <strong>Payment Method:</strong> {{ ucfirst($sale->payment_method) }}<br>
                <strong>Payment Status:</strong> {{ ucfirst($sale->payment_status) }}
            </div>
        </div>

        <!-- Customer Info -->
        <div class="customer-info">
            <strong>Bill To:</strong><br>
            {{ $sale->customer->name ?? 'Walk-in Customer' }}<br>
            @if ($sale->customer && $sale->customer->phone)
                Phone: {{ $sale->customer->phone }}<br>
            @endif
            @if ($sale->customer && $sale->customer->address)
                Address: {{ $sale->customer->address }}
            @endif
        </div>

        <!-- Items Table -->
        <table>
            <thead>
                <tr>
                    <th style="width: 5%">#</th>
                    <th style="width: 30%">Product</th>
                    <th style="width: 15%">Brand</th>
                    <th style="width: 15%">Model</th>
                    <th style="width: 15%">IMEI/SN</th>
                    <th style="width: 5%" class="text-center">Qty</th>
                    <th style="width: 10%" class="text-right">Price</th>
                    <th style="width: 10%" class="text-right">Subtotal</th>
                </tr>
            </thead>
            <tbody>
                @php $itemCount = 1; @endphp
                @foreach ($sale->sellTransactions as $transaction)
                    <tr>
                        <td class="text-center">{{ $itemCount++ }}</td>
                        <td>{{ $transaction->name ?? 'N/A' }}</td>
                        <td>{{ $transaction->product->brand ?? 'N/A' }}</td>
                        <td>{{ $transaction->product->model ?? 'N/A' }}</td>
                        <td>{{ $transaction->product->imei_or_sn ?? 'N/A' }}</td>
                        <td class="text-center">{{ $transaction->sold_quantity ?? 0 }}</td>
                        <td class="text-right">BHD {{ number_format($transaction->sell_price, 2) }}</td>
                        <td class="text-right">BHD
                            {{ number_format($transaction->sell_price * $transaction->sold_quantity, 2) }}</td>
                    </tr>
                @endforeach
                @if ($sale->exchanges && $sale->exchanges->count() > 0)
                    @foreach ($sale->exchanges as $exchange)
                        <tr>
                            <td class="text-center">{{ $itemCount++ }}</td>
                            <td>Exchanged: {{ $exchange->brand->name ?? 'N/A' }}
                                {{ $exchange->mobileModel->name ?? 'N/A' }}</td>
                            <td>{{ $exchange->brand->name ?? 'N/A' }}</td>
                            <td>{{ $exchange->mobileModel->name ?? 'N/A' }}</td>
                            <td>{{ $exchange->imei ?? 'N/A' }}</td>
                            <td class="text-center">1</td>
                            <td class="text-right">BHD {{ number_format($exchange->price, 2) }}</td>
                            <td class="text-right">BHD {{ number_format($exchange->price, 2) }}</td>
                        </tr>
                    @endforeach
                @endif
            </tbody>
        </table>

        <!-- Totals Section -->
        <div class="totals-section">
            <table>
                <tr>
                    <td class="text-right"><strong>Subtotal:</strong></td>
                    <td class="text-right">BHD {{ number_format($sale->total_amount, 2) }}</td>
                </tr>
                @if ($sale->discount > 0)
                    <tr>
                        <td class="text-right"><strong>Exchange Discount:</strong></td>
                        <td class="text-right">-BHD {{ number_format($sale->discount, 2) }}</td>
                    </tr>
                    <tr>
                        <td class="text-right"><strong>Net Amount:</strong></td>
                        <td class="text-right">BHD {{ number_format($sale->net_amount, 2) }}</td>
                    </tr>
                @endif
                <tr>
                    <td class="text-right"><strong>Paid Amount:</strong></td>
                    <td class="text-right">BHD {{ number_format($sale->paid_amount, 2) }}</td>
                </tr>
                @if ($sale->due_amount > 0)
                    <tr>
                        <td class="text-right"><strong>Due Amount:</strong></td>
                        <td class="text-right">BHD {{ number_format($sale->due_amount, 2) }}</td>
                    </tr>
                @endif
            </table>
        </div>

        <!-- Footer -->
        <div class="invoice-footer">
            <p><strong>Thank you for your business!</strong></p>
            <p>Terms & Conditions: Goods once sold will not be taken back. Warranty as per manufacturer policy.</p>
            <p>For any queries, please contact us at +973 1234 5678</p>
        </div>
    </div>

    <div class="text-center">
        <button onclick="printInvoice()" class="print-btn">Print Invoice</button>
    </div>

    <script>
        function printInvoice() {
            const printContents = document.getElementById('invoice').outerHTML;
            const printWindow = window.open('', '', 'width=900,height=650');

            // copy existing styles for consistent design
            const styles = Array.from(document.styleSheets)
                .map(sheet => {
                    try {
                        return Array.from(sheet.cssRules).map(rule => rule.cssText).join('');
                    } catch (e) {
                        return '';
                    }
                }).join('');

            printWindow.document.write(`
                <html>
                    <head>
                        <title>Invoice</title>
                        <style>${styles}</style>
                    </head>
                    <body>
                        ${printContents}
                        <script>
                            window.onload = function() {
                                window.print();
                                window.onafterprint = function() { window.close(); };
                            };
                        <\/script>
                    </body>
                </html>
            `);

            printWindow.document.close();
        }
    </script>

</body>

</html>
