@extends('layouts.app')

@section('content')
<div class="container">
    <h1>Subscription Details</h1>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger">{{ session('error') }}</div>
    @endif

    @if($subscription && $subscription->active())
        <p>Your subscription is active.</p>
        <form action="{{ route('subscription.cancel') }}" method="POST">
            @csrf
            <button type="submit" class="btn btn-danger">Cancel Subscription</button>
        </form>
    @elseif($subscription && $subscription->cancelled())
        <p>Your subscription is cancelled but still active until period end.</p>
        <form action="{{ route('subscription.resume') }}" method="POST">
            @csrf
            <button type="submit" class="btn btn-primary">Resume Subscription</button>
        </form>
    @else
        <p>You do not have an active subscription.</p>
        <form action="{{ route('subscription.subscribe') }}" method="POST">
            @csrf
            <label for="payment_method">Payment Method:</label>
            <input type="text" name="payment_method" id="payment_method" required>
            <button type="submit" class="btn btn-success">Subscribe</button>
        </form>
    @endif
</div>
@endsection
