<?php

use App\Http\Controllers\CustomerController;
use App\Http\Controllers\MobileModelController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\SaleController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

// Route::get('/user', function (Request $request) {
//     return $request->user();
// })->middleware('auth:sanctum');

Route::middleware(['web', 'auth', 'tenant'])->group(function () {
    Route::get('/customers/search', [CustomerController::class, 'search'])->name('api.customers.search');
    Route::get('/get-models/{brandId}', [MobileModelController::class, 'getModels'])->name('get.models');
    Route::get('/products', [ProductController::class, 'fetchProducts'])->name('products.fetch');
    Route::get('/sales/{sale}', [SaleController::class, 'show'])->name('api.sales.show');
});
