<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DirectSales extends Model
{
    protected $fillable = [
        'tenant_id',
        'product_type',
        'direct_sell_price',
        'direct_cost_price',
        'direct_profit',
        'purchase_note',
        'direct_customer_name',
        'direct_sold_quantity',
        'direct_date_time'
    ];
    
    public function Customer()
    {
        return $this->belongsTo(Customer::class, 'direct_customer_name');
    }
}
