<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Exchange extends Model
{
    protected $fillable = [
        'sale_id',
        'brand_id',
        'mobile_model_id',
        'custom_brand',
        'custom_model',
        'price',
        'imei'
    ];

    public function brand()
    {
        return $this->belongsTo(Brand::class);
    }

    public function mobileModel()
    {
        return $this->belongsTo(MobileModel::class, 'mobile_model_id');
    }
}
