<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    protected $fillable = [
        'customer_info',
        'brand',
        'model',
        'imei_or_sn',
        'condition',
        'color',
        'gb',
        'buy_price',
        'sell_price',
        'stock',
        'name',
        'type',
        'tenant_id',
    ];

    public function Customer()
    {
        return $this->belongsTo(Customer::class, 'customer_info');
    }

    // Relationships to get brand and model names from IDs
    public function ProductBrand()
    {
        return $this->belongsTo(Brand::class, 'brand');
    }

    public function ProductModel()
    {
        return $this->belongsTo(MobileModel::class, 'model');
    }

    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }

    protected static function booted()
    {
        static::addGlobalScope('tenant', function ($builder) {
            if (app()->has('tenant')) {
                $builder->where('tenant_id', app('tenant')->id);
            }
        });
    }
}
