<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use App\Models\Sale;
use App\Models\SellTransaction;
use App\Models\DirectSales;
use App\Models\Customer;
use App\Models\Payment;
use App\Models\CustomerPayment;
use App\Models\Exchange;

class CleanSalesAndCustomersSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $this->command->info('Starting to clean sales and customer data...');
        
        // Disable foreign key checks to avoid constraint issues
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        
        try {
            // Clean sales-related data
            $this->command->info('Cleaning sales-related data...');
            
            // 1. Delete exchanges (might reference sales)
            $exchangeCount = DB::table('exchanges')->count();
            DB::table('exchanges')->truncate();
            $this->command->info("Deleted {$exchangeCount} exchanges");
            
            // 2. Delete customer payments
            $customerPaymentCount = DB::table('customer_payments')->count();
            DB::table('customer_payments')->truncate();
            $this->command->info("Deleted {$customerPaymentCount} customer payments");
            
            // 3. Delete payments
            $paymentCount = DB::table('payments')->count();
            DB::table('payments')->truncate();
            $this->command->info("Deleted {$paymentCount} payments");
            
            // 4. Delete sell transactions
            $sellTransactionCount = DB::table('sell_transactions')->count();
            DB::table('sell_transactions')->truncate();
            $this->command->info("Deleted {$sellTransactionCount} sell transactions");
            
            // 5. Delete direct sales
            $directSalesCount = DB::table('direct_sales')->count();
            DB::table('direct_sales')->truncate();
            $this->command->info("Deleted {$directSalesCount} direct sales");
            
            // 6. Delete sales
            $salesCount = DB::table('sales')->count();
            DB::table('sales')->truncate();
            $this->command->info("Deleted {$salesCount} sales");
            
            // Clean customer data
            $this->command->info('Cleaning customer data...');
            
            // 7. Delete customers
            $customerCount = DB::table('customers')->count();
            DB::table('customers')->truncate();
            $this->command->info("Deleted {$customerCount} customers");
            
            // Reset auto-increment counters
            $this->command->info('Resetting auto-increment counters...');
            DB::statement('ALTER TABLE sales AUTO_INCREMENT = 1;');
            DB::statement('ALTER TABLE sell_transactions AUTO_INCREMENT = 1;');
            DB::statement('ALTER TABLE direct_sales AUTO_INCREMENT = 1;');
            DB::statement('ALTER TABLE customers AUTO_INCREMENT = 1;');
            DB::statement('ALTER TABLE payments AUTO_INCREMENT = 1;');
            DB::statement('ALTER TABLE customer_payments AUTO_INCREMENT = 1;');
            DB::statement('ALTER TABLE exchanges AUTO_INCREMENT = 1;');
            
            $this->command->info('✅ Successfully cleaned all sales and customer data!');
            
        } catch (\Exception $e) {
            $this->command->error('Error cleaning data: ' . $e->getMessage());
            throw $e;
        } finally {
            // Re-enable foreign key checks
            DB::statement('SET FOREIGN_KEY_CHECKS=1;');
        }
        
        $this->command->info('Database cleanup completed successfully!');
    }
}
