<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class RolePermissionSeeder extends Seeder
{
    public function run()
    {
        // Create roles
        $superAdminRole = Role::firstOrCreate(['name' => 'super-admin']);
        $adminRole = Role::firstOrCreate(['name' => 'admin']);
        $userRole = Role::firstOrCreate(['name' => 'user']);

        // Create permissions
        $manageUsers = Permission::firstOrCreate(['name' => 'manage users']);
        $manageProducts = Permission::firstOrCreate(['name' => 'manage products']);
        $viewReports = Permission::firstOrCreate(['name' => 'view reports']);
        $managePlans = Permission::firstOrCreate(['name' => 'manage plans']);
        $manageSubscriptions = Permission::firstOrCreate(['name' => 'manage subscriptions']);

        // Assign permissions to roles
        $superAdminRole->givePermissionTo([$manageUsers, $manageProducts, $viewReports, $managePlans, $manageSubscriptions]);
        $adminRole->givePermissionTo([$manageUsers, $manageProducts, $viewReports, $managePlans, $manageSubscriptions]);
        $userRole->givePermissionTo([$viewReports, $manageSubscriptions]);
    }
}
