# POS System - cPanel Installer

Complete web-based installation wizard for deploying the POS System on cPanel hosting environments.

## 🎯 Features

- **Automated Requirements Check**: Verifies PHP version, extensions, and directory permissions
- **Database Setup**: Tests connections and creates database if needed
- **Admin Account Creation**: Secure administrator setup with validation
- **One-Click Installation**: Automated migration, optimization, and configuration
- **Error Handling**: Clear error messages with solutions
- **User-Friendly Interface**: Modern, responsive design with step-by-step progress
- **Security First**: Includes post-installation security checklist

## 📋 System Requirements

### Minimum Requirements
- **PHP**: 8.1 or higher
- **Database**: MySQL 5.7+ or MariaDB 10.3+
- **Web Server**: Apache or Nginx
- **Disk Space**: 500 MB minimum
- **Memory**: 256 MB PHP memory_limit

### Required PHP Extensions
- OpenSSL
- PDO & PDO MySQL
- Mbstring
- Tokenizer
- XML
- Ctype
- JSON
- BCMath
- Curl
- Fileinfo
- ZIP
- GD or Imagick

### Optional (Recommended)
- Composer
- Node.js & NPM
- SSL Certificate
- SSH Access

## 🚀 Quick Start

### Step 1: Upload Files
1. Download the installer package ZIP
2. Login to cPanel File Manager
3. Navigate to `public_html` directory
4. Upload the ZIP file
5. Extract the ZIP file

**OR via FTP:**
```bash
# Extract locally first
unzip pos-installer-v1.0.0.zip
# Upload via FTP client to public_html
```

### Step 2: Set Permissions
Via cPanel Terminal or SSH:
```bash
cd /home/username/public_html
chmod -R 775 storage bootstrap/cache
```

For shared hosting (if above doesn't work):
```bash
chmod -R 755 storage bootstrap/cache
```

### Step 3: Install Dependencies
```bash
composer install --no-dev --optimize-autoloader
```

**Note**: If Composer is not available on your server:
1. Install dependencies locally
2. Upload the entire `vendor` folder via FTP

### Step 4: Create Database
1. Login to cPanel
2. Go to **MySQL Databases**
3. Create a new database (e.g., `yourdomain_pos`)
4. Create a database user with a strong password
5. Add user to database with **ALL PRIVILEGES**
6. Note down: database name, username, password

### Step 5: Run Web Installer
1. Open your browser
2. Navigate to: `https://yourdomain.com/installer/install.php`
3. Follow the 5-step installation wizard:
   - **Step 1**: Requirements check
   - **Step 2**: Database configuration
   - **Step 3**: Admin account setup
   - **Step 4**: Installation process
   - **Step 5**: Complete & login

### Step 6: Secure Installation
```bash
# Delete installer directory
rm -rf installer/

# Or via cPanel File Manager:
# Navigate to public_html and delete "installer" folder
```

## 📖 Installation Wizard Steps

### Step 1: Requirements Check
- Checks PHP version (must be 8.1+)
- Verifies all required PHP extensions
- Tests directory write permissions
- Confirms Composer dependencies are installed

**What if requirements fail?**
- Contact your hosting provider to enable missing PHP extensions
- Use cPanel MultiPHP Manager to change PHP version
- Run `chmod -R 775 storage bootstrap/cache` for permissions

### Step 2: Database Configuration
- Enter database host (usually `localhost`)
- Enter database name, username, password
- Test connection before proceeding
- Creates database if it doesn't exist (with proper privileges)
- Configure application name, URL, and timezone

**Database Connection Tips:**
- Use `localhost` or `127.0.0.1` for host
- Database name format in cPanel: `cpanel_username_dbname`
- Username format: `cpanel_username_dbuser`
- Port is usually `3306` (default)

### Step 3: Admin Account
- Set administrator name
- Enter email (used for login)
- Create strong password (minimum 8 characters)
- Optional phone number
- Password confirmation for security

**Security Tips:**
- Use a unique, strong password
- Enable 2FA after installation
- Never share admin credentials

### Step 4: Installation Process
The installer automatically:
1. ✓ Creates `.env` configuration file
2. ✓ Generates secure application key
3. ✓ Clears configuration cache
4. ✓ Runs database migrations
5. ✓ Creates admin user account
6. ✓ Creates storage symlink
7. ✓ Optimizes application
8. ✓ Sets directory permissions

**Installation takes 1-2 minutes** - Do not close the browser!

### Step 5: Installation Complete
- View your login credentials
- Security checklist reminder
- Link to admin dashboard
- Instructions to delete installer

## 🔧 cPanel Specific Setup

### 1. PHP Version
- Go to cPanel → **MultiPHP Manager**
- Select your domain
- Choose PHP 8.1 or higher

### 2. PHP Extensions
- Go to cPanel → **Select PHP Version**
- Enable all required extensions (see list above)

### 3. Document Root
For better security, point your domain to the `/public` directory:
- cPanel → **Domains** → Select domain → **Document Root**
- Change to: `/home/username/public_html/public`

### 4. Cron Jobs (for scheduled tasks)
- Go to cPanel → **Cron Jobs**
- Add new cron job:
```
* * * * * cd /home/username/public_html && php artisan schedule:run >> /dev/null 2>&1
```

### 5. Email Configuration
After installation, update `.env` file:
```env
MAIL_MAILER=smtp
MAIL_HOST=mail.yourdomain.com
MAIL_PORT=587
MAIL_USERNAME=your-email@yourdomain.com
MAIL_PASSWORD=your-email-password
MAIL_ENCRYPTION=tls
MAIL_FROM_ADDRESS=your-email@yourdomain.com
MAIL_FROM_NAME="${APP_NAME}"
```

## 🐛 Troubleshooting

### Issue: "500 Internal Server Error"
**Cause**: Permission issues or missing .env file

**Solutions**:
```bash
# Fix permissions
chmod -R 775 storage bootstrap/cache

# Check if .env exists
ls -la .env

# Check error logs
tail -f storage/logs/laravel.log
```

### Issue: "Composer dependencies not found"
**Cause**: Vendor directory missing

**Solutions**:
```bash
# Install via SSH
composer install --no-dev --optimize-autoloader

# OR install locally and upload vendor folder via FTP
```

### Issue: "Database connection failed"
**Cause**: Incorrect credentials or database doesn't exist

**Solutions**:
- Verify credentials in cPanel MySQL Databases
- Ensure user is added to database with ALL PRIVILEGES
- Check if database exists or create it manually
- Try using `127.0.0.1` instead of `localhost`

### Issue: "Permission denied" during installation
**Cause**: Web server doesn't have write access

**Solutions**:
```bash
# Set ownership (SSH required)
chown -R username:username /home/username/public_html

# Or use cPanel File Manager
# Select directories → Change Permissions → 755
```

### Issue: "White screen after installation"
**Cause**: PHP errors or configuration issues

**Solutions**:
```bash
# Check Laravel logs
cat storage/logs/laravel.log

# Check PHP error logs in cPanel
# Go to cPanel → Errors

# Ensure .env file exists and is valid
```

### Issue: "Installer already completed" message
**Cause**: `.env` file already exists

**Solutions**:
- If you want to reinstall, delete `.env` file first
- OR use `?force=1` parameter: `installer/install.php?force=1`

## 🔒 Post-Installation Security

### Critical Security Steps
1. **Delete Installer**
   ```bash
   rm -rf installer/
   ```

2. **Change Admin Password**
   - Login to dashboard
   - Go to Profile Settings
   - Update password

3. **Enable SSL/HTTPS**
   - Use cPanel AutoSSL or Let's Encrypt
   - Ensure APP_URL uses `https://`

4. **Set Production Mode**
   Verify `.env` file has:
   ```env
   APP_ENV=production
   APP_DEBUG=false
   ```

5. **Configure Backups**
   - Enable cPanel automated backups
   - Set up database backup schedule
   - Store backups offsite

6. **Firewall Rules**
   - Use cPanel IP Blocker for security
   - Configure ModSecurity rules

7. **Regular Updates**
   - Keep application updated
   - Update PHP version when possible
   - Update Composer dependencies

### File Permissions (Production)
```bash
# Application directories
chmod 755 /path/to/app

# Storage and cache
chmod 775 storage bootstrap/cache

# Public directory
chmod 755 public
```

## 📦 Building Installer Package

To create the installer package, run:

```powershell
# Windows PowerShell
.\scripts\build-installer.ps1 -Version "1.0.0"

# Specify custom output directory
.\scripts\build-installer.ps1 -Version "1.0.0" -OutputDir "releases"
```

This will:
- Copy all application files
- Include installer wizard
- Clean up development files
- Create installation instructions
- Generate ZIP package
- Calculate SHA256 checksum

## 📞 Support

### Getting Help
- **Documentation**: See `README.md` in root directory
- **Error Logs**: Check `storage/logs/laravel.log`
- **cPanel Logs**: Check Error Log in cPanel
- **Support Email**: support@yourdomain.com

### Before Contacting Support
Please provide:
1. PHP version (`php -v`)
2. Error message (exact text)
3. Screenshot of the issue
4. Contents of `storage/logs/laravel.log`
5. Browser console errors (F12 → Console)

## 📄 License

This installer is part of the POS System application.
See the main LICENSE file for details.

## ✅ Installation Checklist

Before Installation:
- [ ] PHP 8.1+ available
- [ ] All PHP extensions enabled
- [ ] Database created in cPanel
- [ ] Database user created with privileges
- [ ] Files uploaded to server
- [ ] Permissions set (775 storage/bootstrap)
- [ ] Composer dependencies installed

During Installation:
- [ ] Step 1: All requirements pass
- [ ] Step 2: Database connection successful
- [ ] Step 3: Admin account created
- [ ] Step 4: Installation completed without errors
- [ ] Step 5: Login credentials saved

After Installation:
- [ ] Installer directory deleted
- [ ] Admin dashboard accessible
- [ ] SSL/HTTPS enabled
- [ ] APP_DEBUG=false in .env
- [ ] Cron job configured
- [ ] Email settings configured
- [ ] Backup system configured
- [ ] Admin password changed
- [ ] Test all major functions

---

**Version**: 1.0.0  
**Last Updated**: October 2025  
**Compatible with**: Laravel 11.x, PHP 8.1+
