-- Fix for installer errors: Missing columns in users table
-- Run this in phpMyAdmin if you get column-related errors

-- ==================================================
-- FIX 1: Add phone column if missing
-- ==================================================
-- Check if column exists (will error if missing - that's OK)
SELECT phone FROM users LIMIT 1;

-- If error above, run this:
ALTER TABLE users ADD COLUMN phone VARCHAR(20) NULL AFTER email;

-- ==================================================
-- FIX 2: Fix tenant_id column (allow NULL or set default)
-- ==================================================
-- Option A: Allow NULL values
ALTER TABLE users MODIFY COLUMN tenant_id INT(11) NULL;

-- Option B: Set default value to 1
ALTER TABLE users MODIFY COLUMN tenant_id INT(11) NOT NULL DEFAULT 1;

-- ==================================================
-- FIX 3: Create tenant first (required for foreign key)
-- ==================================================
-- Check if tenants table exists
SHOW TABLES LIKE 'tenants';

-- If tenants table exists, create a tenant first
-- Replace 'yourdomain.com' with your actual domain
INSERT INTO tenants (name, domain, created_at, updated_at) 
VALUES ('Main Business', 'yourdomain.com', NOW(), NOW());

-- Get the tenant ID (it will be 1 if this is the first tenant)
SELECT id FROM tenants ORDER BY id DESC LIMIT 1;

-- ==================================================
-- FIX 4: Manually create admin user (if installer failed)
-- ==================================================
-- Delete any incomplete user records first
DELETE FROM users WHERE email = 'your-email@domain.com';

-- Create admin user with all required fields (use tenant_id from above, usually 1)
INSERT INTO users (tenant_id, name, email, password, created_at, updated_at) 
VALUES (
    1,                          -- tenant_id (use the ID from the SELECT query above)
    'Administrator',            -- name
    'admin@pos.com',           -- email
    '$2y$12$LQv3c1yqBWVHxkd0LHAkCOYz6TtxMQJqhN8/LewY5OfOzYPqgsQ5u',  -- password: "password"
    NOW(),                      -- created_at
    NOW()                       -- updated_at
);

-- ==================================================
-- VERIFY SETUP
-- ==================================================
-- Check table structure
DESCRIBE users;

-- Check if admin was created
SELECT id, tenant_id, name, email, created_at FROM users;

-- ==================================================
-- LOGIN CREDENTIALS
-- ==================================================
-- Email: admin@pos.com
-- Password: password
-- CHANGE PASSWORD IMMEDIATELY AFTER LOGIN!
-- ==================================================
