-- =====================================================
-- FIX: Super Admin Not Working - Subscription Required
-- =====================================================
-- Run this in phpMyAdmin to fix the subscription issue
-- =====================================================

-- STEP 1: Verify your user has super-admin role
-- Replace 'your-email@domain.com' with your actual email
SELECT 
    u.id as user_id,
    u.name,
    u.email,
    u.tenant_id,
    r.name as role_name
FROM users u
LEFT JOIN model_has_roles mhr ON u.id = mhr.model_id
LEFT JOIN roles r ON mhr.role_id = r.id
WHERE u.email = 'your-email@domain.com';

-- If no role shown, run this:
-- Get your user ID and super-admin role ID
SET @user_id = (SELECT id FROM users WHERE email = 'your-email@domain.com' LIMIT 1);
SET @role_id = (SELECT id FROM roles WHERE name = 'super-admin' LIMIT 1);

-- If super-admin role doesn't exist, create it:
INSERT IGNORE INTO roles (name, guard_name, created_at, updated_at)
VALUES ('super-admin', 'web', NOW(), NOW());

-- Get the role ID again
SET @role_id = (SELECT id FROM roles WHERE name = 'super-admin' LIMIT 1);

-- Assign super-admin role to your user
INSERT IGNORE INTO model_has_roles (role_id, model_type, model_id)
VALUES (@role_id, 'App\\Models\\User', @user_id);

-- Grant ALL permissions to super-admin role
INSERT IGNORE INTO role_has_permissions (permission_id, role_id)
SELECT id, @role_id FROM permissions;


-- =====================================================
-- STEP 2: Create active subscription (bypass requirement)
-- =====================================================

-- Get your tenant ID
SET @tenant_id = (SELECT tenant_id FROM users WHERE email = 'your-email@domain.com' LIMIT 1);

-- Check if plans exist
SELECT * FROM plans LIMIT 1;

-- If no plans, create a Lifetime plan
INSERT IGNORE INTO plans (id, name, price, duration_months, features, created_at, updated_at)
VALUES (1, 'Lifetime Plan', 0, 999, 'Unlimited Access - Full Features', NOW(), NOW());

-- Get or use plan ID 1
SET @plan_id = (SELECT id FROM plans ORDER BY id ASC LIMIT 1);

-- Delete any old subscriptions for this tenant
DELETE FROM subscriptions WHERE tenant_id = @tenant_id;

-- Create active lifetime subscription (100 years = lifetime)
INSERT INTO subscriptions (tenant_id, plan_id, status, start_date, end_date, created_at, updated_at)
VALUES (@tenant_id, @plan_id, 'active', NOW(), DATE_ADD(NOW(), INTERVAL 100 YEAR), NOW(), NOW());


-- =====================================================
-- STEP 3: Verify everything is set up correctly
-- =====================================================

-- Check your user setup
SELECT 
    u.id as user_id,
    u.name,
    u.email,
    u.tenant_id,
    r.name as role_name,
    COUNT(DISTINCT p.id) as permission_count,
    t.name as tenant_name,
    t.domain
FROM users u
LEFT JOIN model_has_roles mhr ON u.id = mhr.model_id
LEFT JOIN roles r ON mhr.role_id = r.id
LEFT JOIN role_has_permissions rhp ON r.id = rhp.role_id
LEFT JOIN permissions p ON rhp.permission_id = p.id
LEFT JOIN tenants t ON u.tenant_id = t.id
WHERE u.email = 'your-email@domain.com'
GROUP BY u.id, r.id;

-- Check subscription
SELECT 
    s.id,
    s.tenant_id,
    t.name as tenant_name,
    p.name as plan_name,
    s.status,
    s.start_date,
    s.end_date,
    DATEDIFF(s.end_date, NOW()) as days_remaining
FROM subscriptions s
JOIN tenants t ON s.tenant_id = t.id
JOIN plans p ON s.plan_id = p.id
WHERE s.tenant_id = @tenant_id;


-- =====================================================
-- EXPECTED RESULTS:
-- =====================================================
-- User should have:
-- - role_name = 'super-admin'
-- - permission_count > 0 (should be 20+)
-- - tenant_id (should match subscription tenant_id)
--
-- Subscription should have:
-- - status = 'active'
-- - days_remaining > 36,000 (100 years)
-- =====================================================

-- =====================================================
-- QUICK FIX SUMMARY
-- =====================================================
-- 1. Creates 'super-admin' role if missing
-- 2. Assigns super-admin role to your user
-- 3. Grants ALL permissions to super-admin
-- 4. Creates Lifetime plan
-- 5. Creates active subscription for 100 years
--
-- After running this, clear cache and try logging in:
-- - Delete bootstrap/cache/*.php files
-- - Visit /login
-- - You should have full access!
-- =====================================================
