<?php
/**
 * POS System Installer for cPanel
 * Version: 1.0.0
 * Checks requirements, creates database, and sets up the application
 */

// Start output buffering to prevent header issues
ob_start();

// Prevent direct access after installation
if (file_exists(__DIR__ . '/../.env') && !isset($_GET['force'])) {
    die('Application already installed. Delete .env file to reinstall or use ?force=1');
}

// Set error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);
set_time_limit(300); // 5 minutes

// Start session
session_start();

// Installation step
$step = isset($_GET['step']) ? (int)$_GET['step'] : 1;

// Store form data in session
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    foreach ($_POST as $key => $value) {
        $_SESSION['install_data'][$key] = $value;
    }
}

// Process the step logic BEFORE any output
ob_start();
switch ($step) {
    case 1:
        include __DIR__ . '/steps/step1-requirements.php';
        break;
    case 2:
        include __DIR__ . '/steps/step2-database.php';
        break;
    case 3:
        include __DIR__ . '/steps/step3-admin.php';
        break;
    case 4:
        include __DIR__ . '/steps/step4-install.php';
        break;
    case 5:
        include __DIR__ . '/steps/step5-complete.php';
        break;
    default:
        header('Location: install.php?step=1');
        exit;
}
$stepContent = ob_get_clean();

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>POS System Installer</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            background: white;
            border-radius: 10px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            overflow: hidden;
        }
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 30px;
            text-align: center;
        }
        .header h1 {
            font-size: 28px;
            margin-bottom: 10px;
        }
        .header p {
            opacity: 0.9;
        }
        .progress-bar {
            background: #f5f5f5;
            height: 4px;
            position: relative;
        }
        .progress-fill {
            background: #667eea;
            height: 100%;
            transition: width 0.3s;
        }
        .content {
            padding: 40px;
        }
        .step-indicator {
            display: flex;
            justify-content: space-between;
            margin-bottom: 40px;
            padding: 0 20px;
        }
        .step-item {
            flex: 1;
            text-align: center;
            position: relative;
        }
        .step-item:not(:last-child)::after {
            content: '';
            position: absolute;
            top: 15px;
            right: -50%;
            width: 100%;
            height: 2px;
            background: #e0e0e0;
            z-index: -1;
        }
        .step-item.active:not(:last-child)::after,
        .step-item.completed:not(:last-child)::after {
            background: #667eea;
        }
        .step-number {
            width: 30px;
            height: 30px;
            border-radius: 50%;
            background: #e0e0e0;
            color: #999;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            margin-bottom: 8px;
        }
        .step-item.active .step-number {
            background: #667eea;
            color: white;
        }
        .step-item.completed .step-number {
            background: #4caf50;
            color: white;
        }
        .step-item.completed .step-number::before {
            content: '✓';
        }
        .step-label {
            font-size: 12px;
            color: #666;
        }
        .step-item.active .step-label {
            color: #667eea;
            font-weight: 600;
        }
        .form-group {
            margin-bottom: 25px;
        }
        label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: #333;
        }
        input[type="text"],
        input[type="password"],
        input[type="email"],
        select {
            width: 100%;
            padding: 12px;
            border: 2px solid #e0e0e0;
            border-radius: 6px;
            font-size: 14px;
            transition: border-color 0.3s;
        }
        input:focus,
        select:focus {
            outline: none;
            border-color: #667eea;
        }
        .help-text {
            font-size: 12px;
            color: #666;
            margin-top: 5px;
        }
        .btn {
            padding: 12px 30px;
            border: none;
            border-radius: 6px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
            text-decoration: none;
            display: inline-block;
        }
        .btn-primary {
            background: #667eea;
            color: white;
        }
        .btn-primary:hover {
            background: #5568d3;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.3);
        }
        .btn-secondary {
            background: #e0e0e0;
            color: #666;
        }
        .btn-secondary:hover {
            background: #d0d0d0;
        }
        .btn-group {
            display: flex;
            justify-content: space-between;
            margin-top: 30px;
        }
        .alert {
            padding: 15px;
            border-radius: 6px;
            margin-bottom: 20px;
        }
        .alert-success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        .alert-error {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        .alert-warning {
            background: #fff3cd;
            color: #856404;
            border: 1px solid #ffeaa7;
        }
        .alert-info {
            background: #d1ecf1;
            color: #0c5460;
            border: 1px solid #bee5eb;
        }
        .requirement-check {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 15px;
            background: #f9f9f9;
            border-radius: 6px;
            margin-bottom: 10px;
        }
        .requirement-check.pass {
            background: #d4edda;
            border-left: 4px solid #28a745;
        }
        .requirement-check.fail {
            background: #f8d7da;
            border-left: 4px solid #dc3545;
        }
        .requirement-check.warning {
            background: #fff3cd;
            border-left: 4px solid #ffc107;
        }
        .status-badge {
            padding: 5px 12px;
            border-radius: 4px;
            font-size: 12px;
            font-weight: bold;
        }
        .status-pass {
            background: #28a745;
            color: white;
        }
        .status-fail {
            background: #dc3545;
            color: white;
        }
        .status-warning {
            background: #ffc107;
            color: #333;
        }
        .loading {
            display: inline-block;
            width: 20px;
            height: 20px;
            border: 3px solid #f3f3f3;
            border-top: 3px solid #667eea;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin-left: 10px;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        .code-block {
            background: #f5f5f5;
            padding: 15px;
            border-radius: 6px;
            font-family: monospace;
            font-size: 13px;
            overflow-x: auto;
            margin: 15px 0;
        }
        .success-icon {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            background: #28a745;
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 40px;
            margin: 0 auto 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🚀 POS System Installer</h1>
            <p>Complete setup wizard for cPanel hosting</p>
        </div>
        
        <div class="progress-bar">
            <div class="progress-fill" style="width: <?php echo ($step / 5) * 100; ?>%"></div>
        </div>

        <div class="content">
            <div class="step-indicator">
                <div class="step-item <?php echo $step >= 1 ? 'active' : ''; ?> <?php echo $step > 1 ? 'completed' : ''; ?>">
                    <div class="step-number"><?php echo $step > 1 ? '' : '1'; ?></div>
                    <div class="step-label">Requirements</div>
                </div>
                <div class="step-item <?php echo $step >= 2 ? 'active' : ''; ?> <?php echo $step > 2 ? 'completed' : ''; ?>">
                    <div class="step-number"><?php echo $step > 2 ? '' : '2'; ?></div>
                    <div class="step-label">Database</div>
                </div>
                <div class="step-item <?php echo $step >= 3 ? 'active' : ''; ?> <?php echo $step > 3 ? 'completed' : ''; ?>">
                    <div class="step-number"><?php echo $step > 3 ? '' : '3'; ?></div>
                    <div class="step-label">Admin Account</div>
                </div>
                <div class="step-item <?php echo $step >= 4 ? 'active' : ''; ?> <?php echo $step > 4 ? 'completed' : ''; ?>">
                    <div class="step-number"><?php echo $step > 4 ? '' : '4'; ?></div>
                    <div class="step-label">Installation</div>
                </div>
                <div class="step-item <?php echo $step >= 5 ? 'active' : ''; ?>">
                    <div class="step-number"><?php echo $step > 5 ? '' : '5'; ?></div>
                    <div class="step-label">Complete</div>
                </div>
            </div>

            <?php
            // Output the buffered step content
            echo $stepContent;
            ?>
        </div>
    </div>
</body>
</html>
