<?php
/**
 * Step 2: Database Configuration
 */

$errors = [];
$testConnection = false;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['test_connection'])) {
    $testConnection = true;
    $host = $_POST['db_host'] ?? '';
    $port = $_POST['db_port'] ?? '3306';
    $database = $_POST['db_name'] ?? '';
    $username = $_POST['db_user'] ?? '';
    $password = $_POST['db_password'] ?? '';
    
    try {
        $dsn = "mysql:host={$host};port={$port}";
        $pdo = new PDO($dsn, $username, $password, [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
        ]);
        
        // Check if database exists
        $stmt = $pdo->query("SHOW DATABASES LIKE '{$database}'");
        $dbExists = $stmt->rowCount() > 0;
        
        if (!$dbExists) {
            // Try to create database
            try {
                $pdo->exec("CREATE DATABASE `{$database}` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
                $success = "✓ Database connection successful! Database '{$database}' created.";
            } catch (PDOException $e) {
                $errors[] = "Cannot create database '{$database}'. Please create it manually or check permissions.";
            }
        } else {
            $success = "✓ Database connection successful! Database '{$database}' already exists.";
        }
        
    } catch (PDOException $e) {
        $errors[] = "Database connection failed: " . $e->getMessage();
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['continue'])) {
    // Validate all fields
    if (empty($_POST['db_host'])) $errors[] = "Database host is required";
    if (empty($_POST['db_name'])) $errors[] = "Database name is required";
    if (empty($_POST['db_user'])) $errors[] = "Database username is required";
    if (empty($_POST['app_name'])) $errors[] = "Application name is required";
    if (empty($_POST['app_url'])) $errors[] = "Application URL is required";
    
    if (empty($errors)) {
        // Test connection one more time before proceeding
        try {
            $host = $_POST['db_host'];
            $port = $_POST['db_port'] ?? '3306';
            $database = $_POST['db_name'];
            $username = $_POST['db_user'];
            $password = $_POST['db_password'] ?? '';
            
            $dsn = "mysql:host={$host};port={$port};dbname={$database}";
            $pdo = new PDO($dsn, $username, $password, [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
            ]);
            
            // Connection successful, proceed to next step
            header('Location: install.php?step=3');
            exit;
        } catch (PDOException $e) {
            $errors[] = "Database connection failed. Please test the connection first.";
        }
    }
}

// Get saved data from session
$data = $_SESSION['install_data'] ?? [];
?>

<h2>Database Configuration</h2>
<p style="margin-bottom: 30px; color: #666;">Enter your database credentials. We'll create the database if it doesn't exist.</p>

<?php if (!empty($errors)): ?>
<div class="alert alert-error">
    <strong>⚠️ Errors Found</strong>
    <ul style="margin: 10px 0 0 20px;">
        <?php foreach ($errors as $error): ?>
            <li><?php echo htmlspecialchars($error); ?></li>
        <?php endforeach; ?>
    </ul>
</div>
<?php endif; ?>

<?php if (isset($success)): ?>
<div class="alert alert-success">
    <?php echo htmlspecialchars($success); ?>
</div>
<?php endif; ?>

<form method="POST" action="install.php?step=2" id="dbForm">
    <h3 style="margin-bottom: 20px;">Database Connection</h3>
    
    <div class="form-group">
        <label>Database Host *</label>
        <input type="text" name="db_host" value="<?php echo htmlspecialchars($data['db_host'] ?? 'localhost'); ?>" required>
        <div class="help-text">Usually "localhost" for cPanel hosting</div>
    </div>
    
    <div class="form-group">
        <label>Database Port</label>
        <input type="text" name="db_port" value="<?php echo htmlspecialchars($data['db_port'] ?? '3306'); ?>">
        <div class="help-text">Default MySQL port is 3306</div>
    </div>
    
    <div class="form-group">
        <label>Database Name *</label>
        <input type="text" name="db_name" value="<?php echo htmlspecialchars($data['db_name'] ?? ''); ?>" required>
        <div class="help-text">Create this database in cPanel MySQL Databases</div>
    </div>
    
    <div class="form-group">
        <label>Database Username *</label>
        <input type="text" name="db_user" value="<?php echo htmlspecialchars($data['db_user'] ?? ''); ?>" required>
        <div class="help-text">MySQL username with access to the database</div>
    </div>
    
    <div class="form-group">
        <label>Database Password</label>
        <input type="password" name="db_password" value="<?php echo htmlspecialchars($data['db_password'] ?? ''); ?>">
        <div class="help-text">Leave blank if no password</div>
    </div>
    
    <div style="background: #f0f0f0; padding: 15px; border-radius: 6px; margin: 20px 0;">
        <button type="submit" name="test_connection" class="btn btn-secondary" style="width: 100%;">
            🔍 Test Database Connection
        </button>
    </div>
    
    <h3 style="margin: 30px 0 20px;">Application Settings</h3>
    
    <div class="form-group">
        <label>Application Name *</label>
        <input type="text" name="app_name" value="<?php echo htmlspecialchars($data['app_name'] ?? 'POS System'); ?>" required>
        <div class="help-text">Your business or application name</div>
    </div>
    
    <div class="form-group">
        <label>Application URL *</label>
        <input type="text" name="app_url" value="<?php echo htmlspecialchars($data['app_url'] ?? 'https://' . $_SERVER['HTTP_HOST']); ?>" required>
        <div class="help-text">Full URL including https://</div>
    </div>
    
    <div class="form-group">
        <label>Timezone</label>
        <select name="app_timezone">
            <?php
            $timezones = [
                'UTC' => 'UTC',
                'Asia/Dhaka' => 'Asia/Dhaka (Bangladesh)',
                'Asia/Kolkata' => 'Asia/Kolkata (India)',
                'Asia/Karachi' => 'Asia/Karachi (Pakistan)',
                'America/New_York' => 'America/New_York (EST)',
                'America/Chicago' => 'America/Chicago (CST)',
                'America/Los_Angeles' => 'America/Los_Angeles (PST)',
                'Europe/London' => 'Europe/London (GMT)',
                'Europe/Paris' => 'Europe/Paris (CET)',
                'Asia/Dubai' => 'Asia/Dubai (UAE)',
                'Asia/Singapore' => 'Asia/Singapore',
                'Australia/Sydney' => 'Australia/Sydney'
            ];
            $selectedTz = $data['app_timezone'] ?? 'UTC';
            foreach ($timezones as $value => $label):
            ?>
                <option value="<?php echo $value; ?>" <?php echo $selectedTz === $value ? 'selected' : ''; ?>>
                    <?php echo $label; ?>
                </option>
            <?php endforeach; ?>
        </select>
    </div>
    
    <div class="btn-group">
        <a href="install.php?step=1" class="btn btn-secondary">← Back</a>
        <button type="submit" name="continue" class="btn btn-primary">Continue →</button>
    </div>
</form>
