<?php
/**
 * Step 3: Create Admin Account
 */

$errors = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Validate admin details
    if (empty($_POST['admin_name'])) $errors[] = "Admin name is required";
    if (empty($_POST['admin_email'])) $errors[] = "Admin email is required";
    if (empty($_POST['admin_password'])) $errors[] = "Admin password is required";
    if (empty($_POST['admin_password_confirm'])) $errors[] = "Password confirmation is required";
    
    if (!empty($_POST['admin_email']) && !filter_var($_POST['admin_email'], FILTER_VALIDATE_EMAIL)) {
        $errors[] = "Please enter a valid email address";
    }
    
    if (!empty($_POST['admin_password']) && strlen($_POST['admin_password']) < 8) {
        $errors[] = "Password must be at least 8 characters long";
    }
    
    if (!empty($_POST['admin_password']) && $_POST['admin_password'] !== $_POST['admin_password_confirm']) {
        $errors[] = "Passwords do not match";
    }
    
    if (empty($errors)) {
        header('Location: install.php?step=4');
        exit;
    }
}

$data = $_SESSION['install_data'] ?? [];
?>

<h2>Create Admin Account</h2>
<p style="margin-bottom: 30px; color: #666;">Set up your administrator account to manage the system.</p>

<?php if (!empty($errors)): ?>
<div class="alert alert-error">
    <strong>⚠️ Errors Found</strong>
    <ul style="margin: 10px 0 0 20px;">
        <?php foreach ($errors as $error): ?>
            <li><?php echo htmlspecialchars($error); ?></li>
        <?php endforeach; ?>
    </ul>
</div>
<?php endif; ?>

<div class="alert alert-info">
    <strong>ℹ️ Important</strong><br>
    This will be your main administrator account. Keep these credentials safe!
</div>

<form method="POST" action="install.php?step=3">
    <div class="form-group">
        <label>Full Name *</label>
        <input type="text" name="admin_name" value="<?php echo htmlspecialchars($data['admin_name'] ?? ''); ?>" required>
        <div class="help-text">Your full name or company name</div>
    </div>
    
    <div class="form-group">
        <label>Email Address *</label>
        <input type="email" name="admin_email" value="<?php echo htmlspecialchars($data['admin_email'] ?? ''); ?>" required>
        <div class="help-text">This will be your login username</div>
    </div>
    
    <div class="form-group">
        <label>Password *</label>
        <input type="password" name="admin_password" required minlength="8">
        <div class="help-text">Minimum 8 characters, use a strong password</div>
    </div>
    
    <div class="form-group">
        <label>Confirm Password *</label>
        <input type="password" name="admin_password_confirm" required minlength="8">
        <div class="help-text">Re-enter your password</div>
    </div>
    
    <div class="form-group">
        <label>Phone Number</label>
        <input type="text" name="admin_phone" value="<?php echo htmlspecialchars($data['admin_phone'] ?? ''); ?>">
        <div class="help-text">Optional contact number</div>
    </div>
    
    <div style="background: #fff3cd; padding: 15px; border-radius: 6px; margin: 20px 0; border-left: 4px solid #ffc107;">
        <strong>⚠️ Security Reminder</strong><br>
        <ul style="margin: 10px 0 0 20px; line-height: 1.8;">
            <li>Use a strong, unique password</li>
            <li>Never share your admin credentials</li>
            <li>Enable two-factor authentication after installation</li>
            <li>Save these credentials in a secure location</li>
        </ul>
    </div>
    
    <div class="btn-group">
        <a href="install.php?step=2" class="btn btn-secondary">← Back</a>
        <button type="submit" class="btn btn-primary">Continue →</button>
    </div>
</form>
