<?php
/**
 * Step 5: Installation Complete
 */

$data = $_SESSION['install_data'] ?? [];

// Clear installation session data
unset($_SESSION['install_data']);
?>

<div style="text-align: center;">
    <div class="success-icon">✓</div>
    <h2 style="color: #28a745; margin-bottom: 15px;">Installation Complete!</h2>
    <p style="color: #666; font-size: 16px; margin-bottom: 40px;">
        Your POS system has been successfully installed and is ready to use.
    </p>
</div>

<div class="alert alert-success">
    <strong>🎉 Congratulations!</strong><br>
    Your application is now fully configured and ready for use.
</div>

<div style="background: #f9f9f9; padding: 25px; border-radius: 6px; margin: 30px 0;">
    <h3 style="margin-bottom: 20px;">📝 Your Login Credentials</h3>
    
    <div style="background: white; padding: 15px; border-radius: 4px; margin-bottom: 15px;">
        <strong>Email:</strong>
        <div style="font-family: monospace; color: #667eea; margin-top: 5px;">
            <?php echo htmlspecialchars($data['admin_email'] ?? 'Not saved'); ?>
        </div>
    </div>
    
    <div style="background: white; padding: 15px; border-radius: 4px;">
        <strong>Password:</strong>
        <div style="font-family: monospace; color: #667eea; margin-top: 5px;">
            (The password you set in Step 3)
        </div>
    </div>
    
    <div class="alert alert-warning" style="margin-top: 20px;">
        <strong>⚠️ Important Security Steps</strong><br>
        <ul style="margin: 10px 0 0 20px; line-height: 1.8;">
            <li><strong>Delete the installer folder:</strong> Remove <code>/installer</code> directory from your server</li>
            <li><strong>Save your credentials:</strong> Store your login details in a secure password manager</li>
            <li><strong>Change default settings:</strong> Configure email, payment gateways, and other settings</li>
            <li><strong>Enable SSL:</strong> Ensure your site uses HTTPS for security</li>
            <li><strong>Regular backups:</strong> Set up automatic database and file backups</li>
        </ul>
    </div>
</div>

<div style="background: #d1ecf1; padding: 20px; border-radius: 6px; margin: 30px 0; border-left: 4px solid #0c5460;">
    <h3 style="margin-bottom: 15px;">🚀 Next Steps</h3>
    <ol style="margin-left: 20px; line-height: 2;">
        <li><strong>Login to your dashboard</strong> using the credentials above</li>
        <li><strong>Complete your profile</strong> and business information</li>
        <li><strong>Add products and inventory</strong> to start selling</li>
        <li><strong>Configure payment methods</strong> for transactions</li>
        <li><strong>Set up users and permissions</strong> for your team</li>
        <li><strong>Customize settings</strong> to match your business needs</li>
    </ol>
</div>

<div style="background: #fff3cd; padding: 20px; border-radius: 6px; margin: 30px 0; border-left: 4px solid #856404;">
    <h3 style="margin-bottom: 15px;">📚 Documentation & Support</h3>
    <ul style="margin-left: 20px; line-height: 2;">
        <li><strong>User Guide:</strong> Check the <code>/README.md</code> file for detailed documentation</li>
        <li><strong>Support:</strong> Contact support for any issues or questions</li>
        <li><strong>Updates:</strong> Keep your system updated for new features and security fixes</li>
    </ul>
</div>

<div class="code-block" style="margin: 30px 0;">
    <strong>🗑️ Delete Installer (Run this command in SSH/Terminal):</strong><br><br>
    <code>rm -rf installer/</code><br><br>
    <strong>Or via cPanel File Manager:</strong><br>
    Navigate to your public_html directory and delete the "installer" folder
</div>

<div style="text-align: center; margin-top: 40px;">
    <a href="<?php echo htmlspecialchars($data['app_url'] ?? '/'); ?>/login" class="btn btn-primary" style="font-size: 18px; padding: 15px 40px;">
        🔐 Login to Dashboard
    </a>
</div>

<div style="text-align: center; margin-top: 30px; padding-top: 30px; border-top: 2px solid #e0e0e0; color: #999;">
    <p>Thank you for choosing our POS System!</p>
    <p style="margin-top: 10px;">© <?php echo date('Y'); ?> - All Rights Reserved</p>
</div>
