<?php
/**
 * Debug 500 Error Script
 * Upload this to public/ and access it at: yourdomain.com/debug-500.php
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>POS System - 500 Error Debugger</h1>";
echo "<hr>";

// 1. Check PHP Version
echo "<h2>1. PHP Version</h2>";
echo "Current: " . PHP_VERSION . "<br>";
echo "Required: 8.1+<br>";
echo "Status: " . (version_compare(PHP_VERSION, '8.1.0') >= 0 ? '✅ OK' : '❌ UPGRADE NEEDED') . "<br>";

// 2. Check .env file
echo "<h2>2. Environment File</h2>";
$envPath = __DIR__ . '/../.env';
if (file_exists($envPath)) {
    echo "✅ .env file exists<br>";
    $envContent = file_get_contents($envPath);
    if (strpos($envContent, 'APP_KEY=base64:') !== false) {
        echo "✅ APP_KEY is set<br>";
    } else {
        echo "❌ APP_KEY is missing or invalid<br>";
    }
    if (strpos($envContent, 'DB_DATABASE=') !== false) {
        echo "✅ Database configured<br>";
    }
} else {
    echo "❌ .env file not found<br>";
}

// 3. Check bootstrap cache
echo "<h2>3. Bootstrap Cache</h2>";
$cacheFiles = [
    '../bootstrap/cache/config.php',
    '../bootstrap/cache/routes-v7.php',
    '../bootstrap/cache/packages.php',
    '../bootstrap/cache/services.php'
];

foreach ($cacheFiles as $file) {
    $fullPath = __DIR__ . '/' . $file;
    if (file_exists($fullPath)) {
        echo "Found: " . basename($file) . " - <a href='?delete=" . urlencode($file) . "'>Delete</a><br>";
    }
}

// Delete cache if requested
if (isset($_GET['delete'])) {
    $fileToDelete = __DIR__ . '/' . $_GET['delete'];
    if (file_exists($fileToDelete) && unlink($fileToDelete)) {
        echo "<br>✅ Deleted: " . basename($fileToDelete) . "<br>";
        echo "<a href='debug-500.php'>Refresh</a><br>";
    }
}

// 4. Check storage permissions
echo "<h2>4. Directory Permissions</h2>";
$dirs = [
    '../storage/logs' => 'Storage Logs',
    '../storage/framework/cache' => 'Cache',
    '../storage/framework/sessions' => 'Sessions',
    '../storage/framework/views' => 'Views',
    '../bootstrap/cache' => 'Bootstrap Cache'
];

foreach ($dirs as $dir => $name) {
    $fullPath = __DIR__ . '/' . $dir;
    if (is_dir($fullPath)) {
        $writable = is_writable($fullPath);
        echo $name . ": " . ($writable ? '✅ Writable' : '❌ Not Writable') . "<br>";
    } else {
        echo $name . ": ❌ Directory not found<br>";
    }
}

// 5. Check database connection
echo "<h2>5. Database Connection</h2>";
if (file_exists($envPath)) {
    preg_match('/DB_HOST=(.*)/', file_get_contents($envPath), $host);
    preg_match('/DB_DATABASE=(.*)/', file_get_contents($envPath), $database);
    preg_match('/DB_USERNAME=(.*)/', file_get_contents($envPath), $username);
    preg_match('/DB_PASSWORD=(.*)/', file_get_contents($envPath), $password);
    
    if (!empty($host[1]) && !empty($database[1])) {
        try {
            $pdo = new PDO(
                "mysql:host={$host[1]};dbname={$database[1]}",
                $username[1] ?? '',
                $password[1] ?? ''
            );
            echo "✅ Database connection successful<br>";
            
            // Check important tables
            $tables = ['users', 'tenants', 'roles', 'permissions'];
            foreach ($tables as $table) {
                $result = $pdo->query("SHOW TABLES LIKE '$table'");
                if ($result->rowCount() > 0) {
                    echo "✅ Table '$table' exists<br>";
                } else {
                    echo "❌ Table '$table' missing<br>";
                }
            }
        } catch (Exception $e) {
            echo "❌ Database error: " . $e->getMessage() . "<br>";
        }
    }
}

// 6. Check error logs
echo "<h2>6. Recent Error Logs</h2>";
$logPath = __DIR__ . '/../storage/logs/laravel.log';
if (file_exists($logPath)) {
    $logs = file_get_contents($logPath);
    $lines = explode("\n", $logs);
    $recentLines = array_slice($lines, -50); // Last 50 lines
    
    echo "<pre style='background: #f5f5f5; padding: 10px; max-height: 300px; overflow: auto;'>";
    echo htmlspecialchars(implode("\n", $recentLines));
    echo "</pre>";
} else {
    echo "No log file found yet<br>";
}

// 7. Try loading Laravel
echo "<h2>7. Try Loading Laravel</h2>";
try {
    if (file_exists(__DIR__ . '/../vendor/autoload.php')) {
        echo "✅ Vendor autoload found<br>";
        require __DIR__ . '/../vendor/autoload.php';
        
        if (file_exists(__DIR__ . '/../bootstrap/app.php')) {
            echo "✅ Bootstrap app found<br>";
            $app = require_once __DIR__ . '/../bootstrap/app.php';
            echo "✅ Laravel application loaded<br>";
        }
    } else {
        echo "❌ Vendor folder not found<br>";
    }
} catch (Exception $e) {
    echo "❌ Error loading Laravel: " . $e->getMessage() . "<br>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
}

echo "<hr>";
echo "<h2>Quick Fixes</h2>";
echo "<ol>";
echo "<li><a href='?clear_cache=1'>Clear All Cache Files</a></li>";
echo "<li><a href='debug-500.php'>Refresh This Page</a></li>";
echo "<li><a href='/'>Try Homepage</a></li>";
echo "<li><a href='/login'>Try Login Page</a></li>";
echo "</ol>";

// Clear cache action
if (isset($_GET['clear_cache'])) {
    echo "<h3>Clearing Cache...</h3>";
    foreach ($cacheFiles as $file) {
        $fullPath = __DIR__ . '/' . $file;
        if (file_exists($fullPath) && unlink($fullPath)) {
            echo "✅ Deleted: " . basename($fullPath) . "<br>";
        }
    }
    echo "<a href='debug-500.php'>Done - Refresh</a>";
}
?>
