@extends('layouts.app')

@section('title', 'Invoice Settings')

@push('style')
<style>
    .settings-card {
        border-radius: 15px;
        box-shadow: 0 4px 15px rgba(0,0,0,0.1);
        border: none;
    }
    .settings-header {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        border-radius: 15px 15px 0 0;
        padding: 20px;
    }
    .form-group label {
        font-weight: 600;
        color: #495057;
        margin-bottom: 8px;
    }
    .template-preview {
        background: #f8f9fa;
        border: 2px dashed #dee2e6;
        border-radius: 8px;
        padding: 20px;
        text-align: center;
        transition: all 0.3s ease;
    }
    .template-preview:hover {
        border-color: #007bff;
        background: #e7f3ff;
    }
    .whatsapp-preview {
        background: #25d366;
        color: white;
        border-radius: 20px;
        padding: 15px;
        font-family: 'Segoe UI', sans-serif;
        white-space: pre-line;
        max-height: 300px;
        overflow-y: auto;
    }
    .toggle-switch {
        position: relative;
        display: inline-block;
        width: 60px;
        height: 34px;
    }
    .toggle-switch input {
        opacity: 0;
        width: 0;
        height: 0;
    }
    .slider {
        position: absolute;
        cursor: pointer;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background-color: #ccc;
        transition: .4s;
        border-radius: 34px;
    }
    .slider:before {
        position: absolute;
        content: "";
        height: 26px;
        width: 26px;
        left: 4px;
        bottom: 4px;
        background-color: white;
        transition: .4s;
        border-radius: 50%;
    }
    input:checked + .slider {
        background-color: #28a745;
    }
    input:checked + .slider:before {
        transform: translateX(26px);
    }
    .variable-tag {
        background: #e9ecef;
        border: 1px solid #ced4da;
        border-radius: 4px;
        padding: 2px 8px;
        margin: 2px;
        display: inline-block;
        font-size: 12px;
        color: #495057;
        cursor: pointer;
    }
    .variable-tag:hover {
        background: #007bff;
        color: white;
    }
</style>
@endpush

@section('main')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Invoice Settings</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item active">Invoice Settings</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<section class="content">
    <div class="container-fluid">
        @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show">
                <i class="fas fa-check-circle mr-2"></i>{{ session('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        @if(session('error'))
            <div class="alert alert-danger alert-dismissible fade show">
                <i class="fas fa-exclamation-circle mr-2"></i>{{ session('error') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

            <form action="{{ route('invoice-settings.update') }}" method="POST" id="settingsForm">
            @csrf
            @method('PUT')
            
            <!-- Hidden fields for WhatsApp advanced settings -->
            <input type="hidden" name="whatsapp_welcome_message" value="{{ $settings->whatsapp_welcome_message ?? '' }}">
            <input type="hidden" name="whatsapp_payment_reminder_message" value="{{ $settings->whatsapp_payment_reminder_message ?? '' }}">
            <input type="hidden" name="whatsapp_delivery_message" value="{{ $settings->whatsapp_delivery_message ?? '' }}">
            <input type="hidden" name="whatsapp_thank_you_message" value="{{ $settings->whatsapp_thank_you_message ?? '' }}">
            <input type="hidden" name="whatsapp_include_business_hours" value="{{ $settings->whatsapp_include_business_hours ? '1' : '0' }}">
            <input type="hidden" name="whatsapp_business_hours" value="{{ $settings->whatsapp_business_hours ?? '' }}">
            
            <div class="row">
                <!-- Company & Basic Settings -->
                <div class="col-md-6">
                    <div class="card settings-card mb-4">
                        <div class="settings-header">
                            <h4 class="mb-0"><i class="fas fa-building mr-2"></i>Company Information</h4>
                        </div>
                        <div class="card-body">
                            <div class="form-group">
                                <label for="company_name">Company Name</label>
                                <input type="text" class="form-control" id="company_name" name="company_name" 
                                       value="{{ $settings->company_name ?? '' }}" required>
                            </div>

                            <div class="form-group">
                                <label for="invoice_header_text">Invoice Header Text</label>
                                <input type="text" class="form-control" id="invoice_header_text" name="invoice_header_text" 
                                       value="{{ $settings->invoice_header_text ?? 'INVOICE' }}" required>
                            </div>

                            <div class="form-group">
                                <label for="invoice_footer_text">Invoice Footer Text</label>
                                <textarea class="form-control" id="invoice_footer_text" name="invoice_footer_text" 
                                          rows="3">{{ $settings->invoice_footer_text ?? '' }}</textarea>
                            </div>

                            <div class="form-group">
                                <label for="invoice_template">Invoice Template</label>
                                <select class="form-control" id="invoice_template" name="invoice_template">
                                    <option value="default" {{ ($settings->invoice_template ?? 'default') == 'default' ? 'selected' : '' }}>Default</option>
                                    <option value="modern" {{ ($settings->invoice_template ?? '') == 'modern' ? 'selected' : '' }}>Modern</option>
                                    <option value="classic" {{ ($settings->invoice_template ?? '') == 'classic' ? 'selected' : '' }}>Classic</option>
                                    <option value="minimal" {{ ($settings->invoice_template ?? '') == 'minimal' ? 'selected' : '' }}>Minimal</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <!-- WhatsApp Settings -->
                    <div class="card settings-card mb-4">
                        <div class="settings-header">
                            <h4 class="mb-0">
                                <i class="fab fa-whatsapp mr-2"></i>WhatsApp Settings
                                <a href="{{ route('whatsapp.management') }}" class="btn btn-sm btn-light float-right">
                                    <i class="fas fa-cogs mr-1"></i>Advanced Management
                                </a>
                            </h4>
                        </div>
                        <div class="card-body">
                            <div class="form-group">
                                <label for="whatsapp_country_code">Default Country Code</label>
                                <select class="form-control" id="whatsapp_country_code" name="whatsapp_country_code">
                                    <!-- South Asian Countries -->
                                    <option value="+880" {{ ($settings->whatsapp_country_code ?? '+880') == '+880' ? 'selected' : '' }}>🇧🇩 +880 (Bangladesh)</option>
                                    <option value="+91" {{ ($settings->whatsapp_country_code ?? '') == '+91' ? 'selected' : '' }}>🇮🇳 +91 (India)</option>
                                    <option value="+92" {{ ($settings->whatsapp_country_code ?? '') == '+92' ? 'selected' : '' }}>🇵🇰 +92 (Pakistan)</option>
                                    <option value="+94" {{ ($settings->whatsapp_country_code ?? '') == '+94' ? 'selected' : '' }}>🇱🇰 +94 (Sri Lanka)</option>
                                    <option value="+977" {{ ($settings->whatsapp_country_code ?? '') == '+977' ? 'selected' : '' }}>🇳🇵 +977 (Nepal)</option>
                                    <option value="+975" {{ ($settings->whatsapp_country_code ?? '') == '+975' ? 'selected' : '' }}>🇧🇹 +975 (Bhutan)</option>
                                    <option value="+960" {{ ($settings->whatsapp_country_code ?? '') == '+960' ? 'selected' : '' }}>🇲🇻 +960 (Maldives)</option>
                                    <option value="+93" {{ ($settings->whatsapp_country_code ?? '') == '+93' ? 'selected' : '' }}>🇦🇫 +93 (Afghanistan)</option>
                                    
                                    <!-- Southeast Asian Countries -->
                                    <option value="+60" {{ ($settings->whatsapp_country_code ?? '') == '+60' ? 'selected' : '' }}>🇲🇾 +60 (Malaysia)</option>
                                    <option value="+62" {{ ($settings->whatsapp_country_code ?? '') == '+62' ? 'selected' : '' }}>🇮🇩 +62 (Indonesia)</option>
                                    <option value="+63" {{ ($settings->whatsapp_country_code ?? '') == '+63' ? 'selected' : '' }}>🇵🇭 +63 (Philippines)</option>
                                    <option value="+65" {{ ($settings->whatsapp_country_code ?? '') == '+65' ? 'selected' : '' }}>🇸🇬 +65 (Singapore)</option>
                                    <option value="+66" {{ ($settings->whatsapp_country_code ?? '') == '+66' ? 'selected' : '' }}>🇹🇭 +66 (Thailand)</option>
                                    <option value="+84" {{ ($settings->whatsapp_country_code ?? '') == '+84' ? 'selected' : '' }}>🇻🇳 +84 (Vietnam)</option>
                                    <option value="+855" {{ ($settings->whatsapp_country_code ?? '') == '+855' ? 'selected' : '' }}>🇰🇭 +855 (Cambodia)</option>
                                    <option value="+856" {{ ($settings->whatsapp_country_code ?? '') == '+856' ? 'selected' : '' }}>🇱🇦 +856 (Laos)</option>
                                    <option value="+95" {{ ($settings->whatsapp_country_code ?? '') == '+95' ? 'selected' : '' }}>🇲🇲 +95 (Myanmar)</option>
                                    <option value="+673" {{ ($settings->whatsapp_country_code ?? '') == '+673' ? 'selected' : '' }}>🇧🇳 +673 (Brunei)</option>
                                    
                                    <!-- East Asian Countries -->
                                    <option value="+86" {{ ($settings->whatsapp_country_code ?? '') == '+86' ? 'selected' : '' }}>🇨🇳 +86 (China)</option>
                                    <option value="+81" {{ ($settings->whatsapp_country_code ?? '') == '+81' ? 'selected' : '' }}>🇯🇵 +81 (Japan)</option>
                                    <option value="+82" {{ ($settings->whatsapp_country_code ?? '') == '+82' ? 'selected' : '' }}>🇰🇷 +82 (South Korea)</option>
                                    <option value="+852" {{ ($settings->whatsapp_country_code ?? '') == '+852' ? 'selected' : '' }}>🇭🇰 +852 (Hong Kong)</option>
                                    <option value="+853" {{ ($settings->whatsapp_country_code ?? '') == '+853' ? 'selected' : '' }}>🇲🇴 +853 (Macau)</option>
                                    <option value="+886" {{ ($settings->whatsapp_country_code ?? '') == '+886' ? 'selected' : '' }}>🇹🇼 +886 (Taiwan)</option>
                                    <option value="+976" {{ ($settings->whatsapp_country_code ?? '') == '+976' ? 'selected' : '' }}>🇲🇳 +976 (Mongolia)</option>
                                    
                                    <!-- Middle Eastern Countries -->
                                    <option value="+971" {{ ($settings->whatsapp_country_code ?? '') == '+971' ? 'selected' : '' }}>🇦� +971 (UAE)</option>
                                    <option value="+966" {{ ($settings->whatsapp_country_code ?? '') == '+966' ? 'selected' : '' }}>🇸🇦 +966 (Saudi Arabia)</option>
                                    <option value="+965" {{ ($settings->whatsapp_country_code ?? '') == '+965' ? 'selected' : '' }}>🇰🇼 +965 (Kuwait)</option>
                                    <option value="+974" {{ ($settings->whatsapp_country_code ?? '') == '+974' ? 'selected' : '' }}>🇶🇦 +974 (Qatar)</option>
                                    <option value="+973" {{ ($settings->whatsapp_country_code ?? '') == '+973' ? 'selected' : '' }}>🇧🇭 +973 (Bahrain)</option>
                                    <option value="+968" {{ ($settings->whatsapp_country_code ?? '') == '+968' ? 'selected' : '' }}>🇴🇲 +968 (Oman)</option>
                                    <option value="+967" {{ ($settings->whatsapp_country_code ?? '') == '+967' ? 'selected' : '' }}>🇾🇪 +967 (Yemen)</option>
                                    <option value="+964" {{ ($settings->whatsapp_country_code ?? '') == '+964' ? 'selected' : '' }}>🇮🇶 +964 (Iraq)</option>
                                    <option value="+962" {{ ($settings->whatsapp_country_code ?? '') == '+962' ? 'selected' : '' }}>🇯🇴 +962 (Jordan)</option>
                                    <option value="+961" {{ ($settings->whatsapp_country_code ?? '') == '+961' ? 'selected' : '' }}>🇱🇧 +961 (Lebanon)</option>
                                    <option value="+963" {{ ($settings->whatsapp_country_code ?? '') == '+963' ? 'selected' : '' }}>🇸🇾 +963 (Syria)</option>
                                    <option value="+98" {{ ($settings->whatsapp_country_code ?? '') == '+98' ? 'selected' : '' }}>🇮🇷 +98 (Iran)</option>
                                    <option value="+90" {{ ($settings->whatsapp_country_code ?? '') == '+90' ? 'selected' : '' }}>🇹🇷 +90 (Turkey)</option>
                                    <option value="+972" {{ ($settings->whatsapp_country_code ?? '') == '+972' ? 'selected' : '' }}>🇮🇱 +972 (Israel)</option>
                                    <option value="+970" {{ ($settings->whatsapp_country_code ?? '') == '+970' ? 'selected' : '' }}>🇵🇸 +970 (Palestine)</option>
                                    <option value="+994" {{ ($settings->whatsapp_country_code ?? '') == '+994' ? 'selected' : '' }}>🇦🇿 +994 (Azerbaijan)</option>
                                    <option value="+995" {{ ($settings->whatsapp_country_code ?? '') == '+995' ? 'selected' : '' }}>🇬🇪 +995 (Georgia)</option>
                                    <option value="+374" {{ ($settings->whatsapp_country_code ?? '') == '+374' ? 'selected' : '' }}>🇦🇲 +374 (Armenia)</option>
                                    
                                    <!-- Central Asian Countries -->
                                    <option value="+7" {{ ($settings->whatsapp_country_code ?? '') == '+7' ? 'selected' : '' }}>🇰🇿 +7 (Kazakhstan)</option>
                                    <option value="+996" {{ ($settings->whatsapp_country_code ?? '') == '+996' ? 'selected' : '' }}>🇰🇬 +996 (Kyrgyzstan)</option>
                                    <option value="+998" {{ ($settings->whatsapp_country_code ?? '') == '+998' ? 'selected' : '' }}>🇺🇿 +998 (Uzbekistan)</option>
                                    <option value="+993" {{ ($settings->whatsapp_country_code ?? '') == '+993' ? 'selected' : '' }}>🇹🇲 +993 (Turkmenistan)</option>
                                    <option value="+992" {{ ($settings->whatsapp_country_code ?? '') == '+992' ? 'selected' : '' }}>🇹🇯 +992 (Tajikistan)</option>
                                    
                                    <!-- European Countries -->
                                    <option value="+44" {{ ($settings->whatsapp_country_code ?? '') == '+44' ? 'selected' : '' }}>🇬🇧 +44 (United Kingdom)</option>
                                    <option value="+49" {{ ($settings->whatsapp_country_code ?? '') == '+49' ? 'selected' : '' }}>🇩🇪 +49 (Germany)</option>
                                    <option value="+33" {{ ($settings->whatsapp_country_code ?? '') == '+33' ? 'selected' : '' }}>🇫🇷 +33 (France)</option>
                                    <option value="+39" {{ ($settings->whatsapp_country_code ?? '') == '+39' ? 'selected' : '' }}>🇮🇹 +39 (Italy)</option>
                                    <option value="+34" {{ ($settings->whatsapp_country_code ?? '') == '+34' ? 'selected' : '' }}>🇪🇸 +34 (Spain)</option>
                                    <option value="+31" {{ ($settings->whatsapp_country_code ?? '') == '+31' ? 'selected' : '' }}>🇳🇱 +31 (Netherlands)</option>
                                    <option value="+32" {{ ($settings->whatsapp_country_code ?? '') == '+32' ? 'selected' : '' }}>🇧🇪 +32 (Belgium)</option>
                                    <option value="+41" {{ ($settings->whatsapp_country_code ?? '') == '+41' ? 'selected' : '' }}>🇨🇭 +41 (Switzerland)</option>
                                    <option value="+43" {{ ($settings->whatsapp_country_code ?? '') == '+43' ? 'selected' : '' }}>🇦🇹 +43 (Austria)</option>
                                    <option value="+48" {{ ($settings->whatsapp_country_code ?? '') == '+48' ? 'selected' : '' }}>🇵🇱 +48 (Poland)</option>
                                    <option value="+420" {{ ($settings->whatsapp_country_code ?? '') == '+420' ? 'selected' : '' }}>🇨🇿 +420 (Czech Republic)</option>
                                    <option value="+421" {{ ($settings->whatsapp_country_code ?? '') == '+421' ? 'selected' : '' }}>🇸🇰 +421 (Slovakia)</option>
                                    <option value="+36" {{ ($settings->whatsapp_country_code ?? '') == '+36' ? 'selected' : '' }}>🇭🇺 +36 (Hungary)</option>
                                    <option value="+40" {{ ($settings->whatsapp_country_code ?? '') == '+40' ? 'selected' : '' }}>🇷🇴 +40 (Romania)</option>
                                    <option value="+359" {{ ($settings->whatsapp_country_code ?? '') == '+359' ? 'selected' : '' }}>🇧🇬 +359 (Bulgaria)</option>
                                    <option value="+30" {{ ($settings->whatsapp_country_code ?? '') == '+30' ? 'selected' : '' }}>🇬🇷 +30 (Greece)</option>
                                    <option value="+351" {{ ($settings->whatsapp_country_code ?? '') == '+351' ? 'selected' : '' }}>🇵🇹 +351 (Portugal)</option>
                                    <option value="+46" {{ ($settings->whatsapp_country_code ?? '') == '+46' ? 'selected' : '' }}>🇸🇪 +46 (Sweden)</option>
                                    <option value="+47" {{ ($settings->whatsapp_country_code ?? '') == '+47' ? 'selected' : '' }}>🇳🇴 +47 (Norway)</option>
                                    <option value="+45" {{ ($settings->whatsapp_country_code ?? '') == '+45' ? 'selected' : '' }}>🇩🇰 +45 (Denmark)</option>
                                    <option value="+358" {{ ($settings->whatsapp_country_code ?? '') == '+358' ? 'selected' : '' }}>🇫🇮 +358 (Finland)</option>
                                    <option value="+380" {{ ($settings->whatsapp_country_code ?? '') == '+380' ? 'selected' : '' }}>🇺🇦 +380 (Ukraine)</option>
                                    <option value="+375" {{ ($settings->whatsapp_country_code ?? '') == '+375' ? 'selected' : '' }}>🇧🇾 +375 (Belarus)</option>
                                    <option value="+372" {{ ($settings->whatsapp_country_code ?? '') == '+372' ? 'selected' : '' }}>🇪🇪 +372 (Estonia)</option>
                                    <option value="+371" {{ ($settings->whatsapp_country_code ?? '') == '+371' ? 'selected' : '' }}>🇱🇻 +371 (Latvia)</option>
                                    <option value="+370" {{ ($settings->whatsapp_country_code ?? '') == '+370' ? 'selected' : '' }}>🇱🇹 +370 (Lithuania)</option>
                                    <option value="+353" {{ ($settings->whatsapp_country_code ?? '') == '+353' ? 'selected' : '' }}>🇮🇪 +353 (Ireland)</option>
                                    <option value="+354" {{ ($settings->whatsapp_country_code ?? '') == '+354' ? 'selected' : '' }}>🇮🇸 +354 (Iceland)</option>
                                    
                                    <!-- African Countries -->
                                    <option value="+27" {{ ($settings->whatsapp_country_code ?? '') == '+27' ? 'selected' : '' }}>🇿🇦 +27 (South Africa)</option>
                                    <option value="+20" {{ ($settings->whatsapp_country_code ?? '') == '+20' ? 'selected' : '' }}>🇪🇬 +20 (Egypt)</option>
                                    <option value="+234" {{ ($settings->whatsapp_country_code ?? '') == '+234' ? 'selected' : '' }}>🇳🇬 +234 (Nigeria)</option>
                                    <option value="+254" {{ ($settings->whatsapp_country_code ?? '') == '+254' ? 'selected' : '' }}>🇰🇪 +254 (Kenya)</option>
                                    <option value="+233" {{ ($settings->whatsapp_country_code ?? '') == '+233' ? 'selected' : '' }}>🇬🇭 +233 (Ghana)</option>
                                    <option value="+255" {{ ($settings->whatsapp_country_code ?? '') == '+255' ? 'selected' : '' }}>🇹🇿 +255 (Tanzania)</option>
                                    <option value="+256" {{ ($settings->whatsapp_country_code ?? '') == '+256' ? 'selected' : '' }}>🇺🇬 +256 (Uganda)</option>
                                    <option value="+212" {{ ($settings->whatsapp_country_code ?? '') == '+212' ? 'selected' : '' }}>🇲🇦 +212 (Morocco)</option>
                                    <option value="+213" {{ ($settings->whatsapp_country_code ?? '') == '+213' ? 'selected' : '' }}>🇩🇿 +213 (Algeria)</option>
                                    <option value="+216" {{ ($settings->whatsapp_country_code ?? '') == '+216' ? 'selected' : '' }}>🇹🇳 +216 (Tunisia)</option>
                                    <option value="+218" {{ ($settings->whatsapp_country_code ?? '') == '+218' ? 'selected' : '' }}>🇱🇾 +218 (Libya)</option>
                                    <option value="+251" {{ ($settings->whatsapp_country_code ?? '') == '+251' ? 'selected' : '' }}>🇪🇹 +251 (Ethiopia)</option>
                                    
                                    <!-- North American Countries -->
                                    <option value="+1" {{ ($settings->whatsapp_country_code ?? '') == '+1' ? 'selected' : '' }}>��🇸 +1 (USA/Canada)</option>
                                    <option value="+52" {{ ($settings->whatsapp_country_code ?? '') == '+52' ? 'selected' : '' }}>🇲🇽 +52 (Mexico)</option>
                                    
                                    <!-- South American Countries -->
                                    <option value="+55" {{ ($settings->whatsapp_country_code ?? '') == '+55' ? 'selected' : '' }}>�🇷 +55 (Brazil)</option>
                                    <option value="+54" {{ ($settings->whatsapp_country_code ?? '') == '+54' ? 'selected' : '' }}>�🇦🇷 +54 (Argentina)</option>
                                    <option value="+56" {{ ($settings->whatsapp_country_code ?? '') == '+56' ? 'selected' : '' }}>🇨🇱 +56 (Chile)</option>
                                    <option value="+57" {{ ($settings->whatsapp_country_code ?? '') == '+57' ? 'selected' : '' }}>🇨🇴 +57 (Colombia)</option>
                                    <option value="+51" {{ ($settings->whatsapp_country_code ?? '') == '+51' ? 'selected' : '' }}>🇵🇪 +51 (Peru)</option>
                                    <option value="+58" {{ ($settings->whatsapp_country_code ?? '') == '+58' ? 'selected' : '' }}>🇻🇪 +58 (Venezuela)</option>
                                    <option value="+593" {{ ($settings->whatsapp_country_code ?? '') == '+593' ? 'selected' : '' }}>🇪🇨 +593 (Ecuador)</option>
                                    <option value="+595" {{ ($settings->whatsapp_country_code ?? '') == '+595' ? 'selected' : '' }}>🇵🇾 +595 (Paraguay)</option>
                                    <option value="+598" {{ ($settings->whatsapp_country_code ?? '') == '+598' ? 'selected' : '' }}>🇺🇾 +598 (Uruguay)</option>
                                    
                                    <!-- Oceania Countries -->
                                    <option value="+61" {{ ($settings->whatsapp_country_code ?? '') == '+61' ? 'selected' : '' }}>🇦🇺 +61 (Australia)</option>
                                    <option value="+64" {{ ($settings->whatsapp_country_code ?? '') == '+64' ? 'selected' : '' }}>🇳🇿 +64 (New Zealand)</option>
                                    <option value="+679" {{ ($settings->whatsapp_country_code ?? '') == '+679' ? 'selected' : '' }}>🇫🇯 +679 (Fiji)</option>
                                </select>
                                <small class="text-muted">Default country code for customer phone numbers</small>
                            </div>

                            <div class="form-group">
                                <div class="d-flex justify-content-between align-items-center">
                                    <label class="mb-0">Enable WhatsApp Integration</label>
                                    <label class="toggle-switch">
                                        <input type="checkbox" name="whatsapp_enabled" value="1" 
                                               {{ ($settings->whatsapp_enabled ?? true) ? 'checked' : '' }}>
                                        <span class="slider"></span>
                                    </label>
                                </div>
                                <small class="text-muted">Allow sending invoices via WhatsApp</small>
                            </div>

                            <div class="form-group">
                                <div class="d-flex justify-content-between align-items-center">
                                    <label class="mb-0">Auto-Send WhatsApp</label>
                                    <label class="toggle-switch">
                                        <input type="checkbox" name="auto_send_whatsapp" value="1" 
                                               {{ ($settings->auto_send_whatsapp ?? false) ? 'checked' : '' }}>
                                        <span class="slider"></span>
                                    </label>
                                </div>
                                <small class="text-muted">Automatically prompt to send WhatsApp after sale</small>
                            </div>

                            <div class="form-group">
                                <div class="d-flex justify-content-between align-items-center">
                                    <label class="mb-0">Auto-Format Phone Numbers</label>
                                    <label class="toggle-switch">
                                        <input type="checkbox" name="whatsapp_auto_format_numbers" value="1" 
                                               {{ ($settings->whatsapp_auto_format_numbers ?? true) ? 'checked' : '' }}>
                                        <span class="slider"></span>
                                    </label>
                                </div>
                                <small class="text-muted">Automatically add country code to local numbers</small>
                            </div>

                            <div class="alert alert-info">
                                <i class="fas fa-qrcode mr-2"></i>
                                <strong>QR Code System Active!</strong> Visit the 
                                <a href="{{ route('whatsapp.management') }}" class="alert-link">Advanced WhatsApp Management</a> 
                                page to configure QR code settings, message templates, and test QR functionality.
                            </div>

                            <!-- Quick QR Test -->
                            <div class="card bg-light">
                                <div class="card-body text-center">
                                    <h6><i class="fas fa-qrcode mr-2"></i>Quick Test</h6>
                                    <button type="button" class="btn btn-success btn-sm" onclick="testQuickQr()">
                                        <i class="fab fa-whatsapp mr-1"></i>Generate Test QR
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Additional Options -->
                    <div class="card settings-card">
                        <div class="settings-header">
                            <h4 class="mb-0"><i class="fas fa-cogs mr-2"></i>Additional Options</h4>
                        </div>
                        <div class="card-body">
                            <div class="form-group">
                                <div class="d-flex justify-content-between align-items-center">
                                    <label class="mb-0">Include Company Logo</label>
                                    <label class="toggle-switch">
                                        <input type="checkbox" name="include_company_logo" value="1" 
                                               {{ ($settings->include_company_logo ?? true) ? 'checked' : '' }}>
                                        <span class="slider"></span>
                                    </label>
                                </div>
                                <small class="text-muted">Show company logo on invoices</small>
                            </div>

                            <div class="form-group">
                                <div class="d-flex justify-content-between align-items-center">
                                    <label class="mb-0">Include QR Code</label>
                                    <label class="toggle-switch">
                                        <input type="checkbox" name="include_qr_code" value="1" 
                                               {{ ($settings->include_qr_code ?? false) ? 'checked' : '' }}>
                                        <span class="slider"></span>
                                    </label>
                                </div>
                                <small class="text-muted">Add QR code for digital verification</small>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- WhatsApp Message Template -->
                <div class="col-md-6">
                    <div class="card settings-card mb-4">
                        <div class="settings-header">
                            <h4 class="mb-0"><i class="fas fa-comment-alt mr-2"></i>WhatsApp Message Template</h4>
                        </div>
                        <div class="card-body">
                            <div class="form-group">
                                <label for="invoice_message_template">Message Template</label>
                                <textarea class="form-control" id="invoice_message_template" name="invoice_message_template" 
                                          rows="12" required>{{ $settings->invoice_message_template ?? '' }}</textarea>
                                <small class="text-muted">Customize your WhatsApp invoice message</small>
                            </div>

                            <div class="mb-3">
                                <label class="font-weight-bold">Available Variables:</label>
                                <div class="mt-2">
                                    <span class="variable-tag" data-variable="{invoice_number}">Invoice Number</span>
                                    <span class="variable-tag" data-variable="{customer_name}">Customer Name</span>
                                    <span class="variable-tag" data-variable="{customer_phone}">Customer Phone</span>
                                    <span class="variable-tag" data-variable="{invoice_date}">Invoice Date</span>
                                    <span class="variable-tag" data-variable="{item_list}">Item List</span>
                                    <span class="variable-tag" data-variable="{currency}">Currency</span>
                                    <span class="variable-tag" data-variable="{total_amount}">Total Amount</span>
                                    <span class="variable-tag" data-variable="{paid_amount}">Paid Amount</span>
                                    <span class="variable-tag" data-variable="{due_amount}">Due Amount</span>
                                    <span class="variable-tag" data-variable="{customer_total_due}">Customer Total Due</span>
                                    <span class="variable-tag" data-variable="{payment_method}">Payment Method</span>
                                    <span class="variable-tag" data-variable="{payment_status}">Payment Status</span>
                                    <span class="variable-tag" data-variable="{invoice_link}">Invoice Link</span>
                                </div>
                            </div>

                            <div class="whatsapp-preview" id="whatsappPreview">
                                <!-- Preview will be updated via JavaScript -->
                            </div>
                        </div>
                    </div>

                    <!-- Terms & Conditions -->
                    <div class="card settings-card">
                        <div class="settings-header">
                            <h4 class="mb-0"><i class="fas fa-file-contract mr-2"></i>Terms & Conditions</h4>
                        </div>
                        <div class="card-body">
                            <div class="form-group">
                                <label for="invoice_terms_conditions">Terms & Conditions</label>
                                <textarea class="form-control" id="invoice_terms_conditions" name="invoice_terms_conditions" 
                                          rows="8">{{ $settings->invoice_terms_conditions ?? '' }}</textarea>
                                <small class="text-muted">These will appear at the bottom of invoices</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body text-center">
                            <button type="submit" class="btn btn-success btn-lg mr-3">
                                <i class="fas fa-save mr-2"></i>Save Settings
                            </button>
                            <button type="button" class="btn btn-info btn-lg mr-3" onclick="previewTemplate()">
                                <i class="fas fa-eye mr-2"></i>Preview Invoice
                            </button>
                            <a href="{{ route('invoice-settings.reset-defaults') }}" class="btn btn-warning btn-lg mr-3" 
                               onclick="return confirm('Are you sure you want to reset to default settings?')">
                                <i class="fas fa-undo mr-2"></i>Reset to Defaults
                            </a>
                            <a href="{{ route('dashboard') }}" class="btn btn-secondary btn-lg">
                                <i class="fas fa-arrow-left mr-2"></i>Back to Dashboard
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</section>

@include('components.whatsapp-qr-modal')
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Update WhatsApp preview when template changes
    function updateWhatsAppPreview() {
        let template = $('#invoice_message_template').val();
        
        // Replace variables with sample data
        template = template.replace(/{invoice_number}/g, 'INV-2025-001');
        template = template.replace(/{customer_name}/g, 'John Doe');
        template = template.replace(/{customer_phone}/g, '+8801712345678');
        template = template.replace(/{invoice_date}/g, new Date().toLocaleDateString());
        template = template.replace(/{item_list}/g, '• iPhone 15 Pro x1 @ BDT 120,000 = BDT 120,000\n• Samsung Galaxy S24 x2 @ BDT 95,000 = BDT 190,000');
        template = template.replace(/{currency}/g, 'BDT');
        template = template.replace(/{total_amount}/g, '310,000.00');
        template = template.replace(/{paid_amount}/g, '150,000.00');
        template = template.replace(/{due_amount}/g, '160,000.00');
        template = template.replace(/{customer_total_due}/g, '275,000.00');
        template = template.replace(/{payment_method}/g, 'Credit');
        template = template.replace(/{payment_status}/g, 'Partial');
        template = template.replace(/{invoice_link}/g, 'http://yoursite.com/invoice/INV-2025-001');
        
        $('#whatsappPreview').text(template);
    }

    // Initial preview update
    updateWhatsAppPreview();

    // Update preview when template changes
    $('#invoice_message_template').on('input', updateWhatsAppPreview);

    // Variable tag click to insert
    $('.variable-tag').click(function() {
        const variable = $(this).data('variable');
        const textarea = document.getElementById('invoice_message_template');
        const cursorPos = textarea.selectionStart;
        const textBefore = textarea.value.substring(0, cursorPos);
        const textAfter = textarea.value.substring(cursorPos);
        
        textarea.value = textBefore + variable + textAfter;
        textarea.selectionStart = textarea.selectionEnd = cursorPos + variable.length;
        textarea.focus();
        
        updateWhatsAppPreview();
    });

    // Form validation
    $('#settingsForm').on('submit', function(e) {
        const companyName = $('#company_name').val().trim();
        const headerText = $('#invoice_header_text').val().trim();
        const messageTemplate = $('#invoice_message_template').val().trim();

        if (!companyName) {
            alert('Company Name is required');
            e.preventDefault();
            return false;
        }

        if (!headerText) {
            alert('Invoice Header Text is required');
            e.preventDefault();
            return false;
        }

        if (!messageTemplate) {
            alert('WhatsApp Message Template is required');
            e.preventDefault();
            return false;
        }

        return true;
    });
});

function testQuickQr() {
    const countryCode = $('#whatsapp_country_code').val() || '+880';
    const phone = countryCode.replace('+', '') + '1712345678';
    const companyName = $('#company_name').val() || 'Your Mobile Store';
    
    const data = {
        customer_name: 'Test Customer',
        phone: phone,
        invoice_number: 'TEST-001',
        message: `🎉 Hello from ${companyName}!\n\nThis is a test message to verify our WhatsApp QR system is working properly.\n\n📱 Thank you for choosing us!`,
        whatsapp_url: `https://wa.me/${phone}?text=${encodeURIComponent(`Hello from ${companyName}! This is a test message.`)}`,
        qr_code_url: `https://api.qrserver.com/v1/create-qr-code/?size=300x300&data=${encodeURIComponent(`https://wa.me/${phone}?text=Hello from ${companyName}! This is a test message.`)}`,
        qr_code_url_alt: `https://chart.googleapis.com/chart?chs=300x300&cht=qr&chl=${encodeURIComponent(`https://wa.me/${phone}?text=Hello from ${companyName}! This is a test message.`)}&choe=UTF-8`
    };
    
    showWhatsAppQr(data);
}

function previewTemplate() {
    const template = $('#invoice_template').val();
    window.open(`{{ route('invoice-settings.preview') }}?template=${template}`, '_blank');
}
</script>
@endpush