@extends('layouts.app')
@push('style')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
    <style>
        /* Style for the search results dropdown */
        #customer_results {
            position: absolute;
            z-index: 1000;
            /* Ensure it appears above other elements */
            background-color: #fff;
            border: 1px solid #ccc;
            border-top: none;
            max-height: 200px;
            overflow-y: auto;
            width: 100%;
            /* Match the width of the input field */
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        /* Style for individual search items */
        .search-item {
            padding: 8px 12px;
            cursor: pointer;
            list-style-type: none;
            /* Remove bullet points */
        }

        .search-item:hover {
            background-color: #f8f9fa;
            /* Highlight on hover */
        }

        /* Hide the dropdown by default */
        #customer_results {
            display: none;
        }
    </style>
@endpush
@section('main')
    {{-- {{ $brands }} --}}
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Project Add</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item active">Project Add</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
        {{-- =============================================== --}}
        @if (session('success'))
            {{-- <div class="alert alert-success">
                {{ session('success') }}
            </div> --}}
            <div class="modal fade show" style="display: block;" id="print_invoice_modal">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                Product Added Successfully!
                            </h4>

                        </div>

                        <div class="modal-body">
                            <div class="popup-content">
                                <a href="{{ route('product.print', session('success')) }}" target="_blank"
                                    class="btn btn-block btn-outline-success btn-sm">
                                    Print Receipt
                                </a>
                                <button type="button" class="btn btn-block btn-outline-danger btn-sm"
                                    id="close_modal_btn">Close</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <script>
                // Play success sound when product is added successfully
                document.addEventListener('DOMContentLoaded', function() {
                    setTimeout(function() {
                        // Play success sound
                        if (typeof playSound === 'function') {
                            console.log('Playing success sound for product added');
                            playSound('success');
                        }
                        
                        // Also show notification
                        if (typeof window.notificationSystem !== 'undefined') {
                            window.notificationSystem.show({
                                type: 'success',
                                title: 'Product Added Successfully!',
                                message: 'Your product has been added to inventory',
                                duration: 4000
                            });
                        }
                    }, 1000);
                });
            </script>
        @endif
        {{-- =============================================== --}}
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-6">
                <div class="card card-primary">
                    <div class="card-header">
                        <h3 class="card-title">General</h3>

                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse" data-toggle="tooltip"
                                title="Collapse">
                                <i class="fas fa-minus"></i></button>
                        </div>
                    </div>
                    <form method="POST" action="{{ route('product.store') }}">
                        @csrf
                        <!-- Customer Info -->
                        <div class="card-body">
                            <div class="form-group">
                                <label for="customer_search">Search Customer:</label>
                                <input type="text" class="form-control" id="customer_search"
                                    placeholder="Search by name or mobile..." autocomplete="off">
                                <input type="hidden" id="customer_info" name="customer_info" readonly>
                                <div id="customer_results" class="search-results"></div> <!-- Dropdown for results -->

                                <button type="button" data-toggle="modal" data-target="#modal-add-customer"
                                    class="btn btn-block">
                                    <i class="fas fa-plus"></i> Add New Customer
                                </button>

                            </div>

                            <!-- Mobile Brand -->
                            <div class="form-group">
                                <label for="brand">Mobile Brand:</label>
                                <select id="brandDropdown" class="form-control" name="brand" required>
                                    <option value="">-- Select Brand --</option>
                                    @foreach ($brands as $brand)
                                        <option value="{{ $brand->id }}">{{ $brand->name }}</option>
                                    @endforeach

                                </select>
                                <button type="button" class="btn btn-block" data-toggle="modal"
                                    data-target="#modal-add-brand">+</button>
                            </div>

                            <!-- Mobile Model -->
                            <div class="form-group">
                                <label for="model">Mobile Model:</label>
                                <select id="modelDropdown" class="form-control" name="model" required>
                                    <option value="">-- Select Model --</option>
                                    <!-- Models will be populated here dynamically -->
                                </select>
                                <!-- Button to open model modal -->
                                <button type="button" id="openAddModelModal" class="btn btn-block" data-toggle="modal"
                                    data-target="#modal-add-model">+</button>
                            </div>

                            <!-- IMEI/SN Number -->
                            <div class="form-group">
                                <label for="imei_or_sn">IMEI/SN Number:</label>
                                <input type="text" class="form-control" id="imei_or_sn" name="imei_or_sn" required>
                            </div>

                            <!-- Condition -->
                            <div class="form-group">
                                <label for="condition">Condition:</label>
                                <select id="condition" class="form-control" name="condition" required>
                                    <option value="new">New</option>
                                    <option value="old">Old</option>
                                </select>
                            </div>

                            <!-- Color -->
                            <div class="form-group">
                                <label for="color">Phone Color:</label>
                                <select id="color" class="form-control" name="color" required>
                                    <option value="Black">Black</option>
                                    <option value="White">White</option>
                                    <option value="Silver">Silver</option>
                                    <option value="Gold">Gold</option>
                                    <option value="Rose Gold">Rose Gold</option>
                                    <option value="Blue">Blue</option>
                                    <option value="Green">Green</option>
                                    <option value="Purple">Purple</option>
                                </select>
                            </div>

                            <div class="form-group">
                                <label for="gb">Storage (GB):</label>
                                <select id="gb" class="form-control" name="gb" required>
                                    <option value="16">16 GB</option>
                                    <option value="32">32 GB</option>
                                    <option value="64">64 GB</option>
                                    <option value="128">128 GB</option>
                                    <option value="256">256 GB</option>
                                    <option value="512">512 GB</option>
                                    <option value="1024">1 TB</option>
                                </select>
                            </div>

                            <div class="form-group">
                                <label for="buy_price">Buy Price:</label>
                                <input type="number" class="form-control" step="0.01" id="buy_price"
                                    name="buy_price" required>
                            </div>

                            <div class="form-group">
                                <label for="stock">Stock Quantity:</label>
                                <input type="number" class="form-control" id="stock" value="1" name="stock"
                                    required>
                            </div>

                            <button type="submit" class="btn btn-block bg-gradient-primary">Add Product and Generate
                                Receipt</button>

                            <!-- Popup will display here after successful form submission -->
                    </form>
                </div>


            </div>
            <!-- /.card -->
        </div>
        <div class="col-md-6">
            <div class="card card-secondary">
                <div class="card-header">
                    <h3 class="card-title">Direct Add Product</h3>

                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse" data-toggle="tooltip"
                            title="Collapse">
                            <i class="fas fa-minus"></i></button>
                    </div>
                </div>
                <form method="POST" action="{{ route('product.direct.store') }}">
    @csrf
    <div class="card-body">
        <!-- Instructions -->
        <div class="alert alert-info" role="alert">
            <i class="fas fa-info-circle"></i> <strong>Smart Product Entry:</strong>
            <br>• Type product name to search existing products
            <br>• Click found products to update stock instead of creating duplicates
            <br>• New products will be created if no matches found
        </div>
        <!-- Product Type (Brand) -->
        <div class="form-group">
            <label for="ProductType">Product Type:</label>
            <select id="ProductType" class="form-control" name="ProductType" required>
                <option value="">-- Select Product Type --</option>
                <option value="Repair">Repair</option>
                <option value="Accessories">Accessories</option>
                <option value="Phone">Phone</option>
                <option value="Others">Others</option>
            </select>
        </div>

        <!-- Product Name (Model) -->
        <div class="form-group">
            <label for="product_name">Item Name :</label>
            <input type="text" class="form-control" id="product_name" name="product_name" placeholder="Enter model name (type to search existing)" required autocomplete="off">
            <div id="product_search_results" class="search-dropdown"></div>
            <small class="form-text text-muted">Start typing to search existing products and update their stock.</small>
            <button type="button" id="test_search" class="btn btn-sm btn-info mt-1">Test Search</button>
        </div>

        <!-- Buy Price -->
        <div class="form-group">
            <label for="item_price">Buy Price:</label>
            <input type="number" class="form-control" step="0.01" id="item_price" name="item_price" placeholder="Enter price" required>
        </div>

        <!-- Stock Quantity -->
        <div class="form-group">
            <label for="stock_quantity">Stock Quantity:</label>
            <input type="number" class="form-control" id="stock_quantity" name="stock_quantity" placeholder="Enter stock quantity" required>
        </div>
    </div>

    <div class="card-footer">
        <button type="submit" class="btn btn-block bg-gradient-info">Save Product</button>
    </div>
</form>


    {{-- Add Customer --}}
    <div class="modal fade" id="modal-add-customer">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header bg-info text-white">
                    <h4 class="modal-title">
                        <i class="fas fa-user-plus mr-2"></i>Add New Customer
                    </h4>
                    <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="customer_form">
                    @csrf <!-- CSRF Token -->
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="customer_name">
                                        <i class="fas fa-user mr-1"></i>Customer Name <span class="text-danger">*</span>
                                    </label>
                                    <input type="text" id="customer_name" class="form-control" name="customer_name" placeholder="Enter customer name" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="customer_number">
                                        <i class="fas fa-phone mr-1"></i>Phone Number <span class="text-danger">*</span>
                                    </label>
                                    <input type="tel" id="customer_number" class="form-control" name="customer_number" placeholder="Enter phone number" required>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="customer_email">
                                        <i class="fas fa-envelope mr-1"></i>Email Address
                                    </label>
                                    <input type="email" id="customer_email" class="form-control" name="customer_email" placeholder="Enter email address">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="customer_cpr">
                                        <i class="fas fa-id-card mr-1"></i>CPR/ID Number
                                    </label>
                                    <input type="text" id="customer_cpr" class="form-control" name="customer_cpr" placeholder="Enter CPR/ID number">
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="address">
                                <i class="fas fa-map-marker-alt mr-1"></i>Address
                            </label>
                            <textarea id="address" class="form-control" name="address" rows="2" placeholder="Enter full address"></textarea>
                        </div>

                        <div class="form-group">
                            <label for="customer_notes">
                                <i class="fas fa-sticky-note mr-1"></i>Notes
                            </label>
                            <textarea id="customer_notes" class="form-control" name="customer_notes" rows="2" placeholder="Any additional notes about the customer"></textarea>
                        </div>

                        <div class="form-group">
                            <label for="cpr_photo">
                                <i class="fas fa-camera mr-1"></i>CPR/ID Photo
                            </label>
                            <div class="custom-file">
                                <input type="file" class="custom-file-input" id="cpr_photo" name="cpr_photo" accept="image/*">
                                <label class="custom-file-label" for="cpr_photo">Choose photo...</label>
                            </div>
                            <small class="form-text text-muted">Supported formats: JPG, PNG, GIF (Max: 2MB)</small>
                            <div id="photo_preview" style="display: none; margin-top: 10px; text-align: center;">
                                <img id="preview_image" src="" alt="Photo Preview" style="max-width: 200px; max-height: 150px; border: 1px solid #ddd; border-radius: 5px; box-shadow: 0 2px 8px rgba(0,0,0,0.1);">
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">
                            <i class="fas fa-times mr-1"></i>Cancel
                        </button>
                        <button type="submit" class="btn btn-info">
                            <i class="fas fa-save mr-1"></i>Save Customer
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    {{-- Add Customer --}}

    {{-- Add Brand --}}
    <div class="modal fade" id="modal-add-brand">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Add New Brand</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        {{-- <span aria-hidden="true">&times;</span> --}}
                    </button>
                </div>
                <form method="POST" action="{{ route('brand.store') }}">
                    @csrf <!-- CSRF Token -->
                    <div class="modal-body">
                        <label for="brand_name">Brand Name:</label>
                        <input type="text" id="brand_name" class="form-control" name="brand_name" required>


                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Save Brand</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    {{-- Add Brand --}}

    {{-- Add Mobile Model --}}
    <div class="modal fade" id="modal-add-model">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Add New Model</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        {{-- <span aria-hidden="true">&times;</span> --}}
                    </button>
                </div>
                <form method="POST" action="{{ route('mobile-models.store') }}">
                    @csrf <!-- CSRF Token -->
                    <div class="modal-body">
                        <label for="model_name">Model Name:</label>
                        <input type="hidden" id="brand_id" name="brand_id" required>
                        <input type="text" id="model_name" class="form-control" name="model_name" required>


                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Save Model</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    {{-- Add Mobile Model --}}

    <!-- Professional Product Found Modal -->
    <div class="modal fade" id="productFoundModal" tabindex="-1" role="dialog" aria-labelledby="productFoundModalLabel" aria-hidden="true" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content shadow-lg border-0">
                <div class="modal-header bg-gradient-primary text-white border-0">
                    <h5 class="modal-title" id="productFoundModalLabel">
                        <i class="fas fa-box-open animate__animated animate__pulse animate__infinite mr-2"></i>
                        Product Found!
                    </h5>
                    <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close" onclick="playSound('cancel')">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body p-4">
                    <div class="row">
                        <div class="col-md-8">
                            <div class="product-details">
                                <h6 class="text-primary mb-3">
                                    <i class="fas fa-info-circle mr-2"></i>
                                    Existing Product Information
                                </h6>
                                <div class="product-info-card bg-light p-3 rounded mb-3">
                                    <div class="row">
                                        <div class="col-sm-4"><strong>Product Name:</strong></div>
                                        <div class="col-sm-8" id="modalProductName">-</div>
                                    </div>
                                    <div class="row mt-2">
                                        <div class="col-sm-4"><strong>Current Stock:</strong></div>
                                        <div class="col-sm-8">
                                            <span class="badge badge-info badge-lg" id="modalCurrentStock">0</span> units
                                        </div>
                                    </div>
                                    <div class="row mt-2">
                                        <div class="col-sm-4"><strong>Current Price:</strong></div>
                                        <div class="col-sm-8">
                                            <span class="text-success font-weight-bold" id="modalCurrentPrice">BHD 0.00</span>
                                        </div>
                                    </div>
                                </div>
                                
                                <h6 class="text-success mb-3">
                                    <i class="fas fa-plus-circle mr-2"></i>
                                    Add Stock to Inventory
                                </h6>
                                <div class="form-group">
                                    <label for="additionalStockInput" class="form-label">Additional Stock Quantity:</label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text">
                                                <i class="fas fa-cubes text-primary"></i>
                                            </span>
                                        </div>
                                        <input type="number" class="form-control form-control-lg" id="additionalStockInput" 
                                               min="1" value="1" placeholder="Enter quantity to add">
                                        <div class="input-group-append">
                                            <span class="input-group-text">units</span>
                                        </div>
                                    </div>
                                    <small class="form-text text-muted">
                                        <i class="fas fa-lightbulb mr-1"></i>
                                        This will be added to your existing inventory
                                    </small>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="summary-card bg-gradient-info text-white p-3 rounded">
                                <h6 class="mb-3">
                                    <i class="fas fa-calculator mr-2"></i>
                                    Stock Summary
                                </h6>
                                <div class="summary-item mb-2">
                                    <small>Current Stock:</small>
                                    <div class="h5" id="summaryCurrentStock">0 units</div>
                                </div>
                                <div class="summary-item mb-2">
                                    <small>Adding:</small>
                                    <div class="h5" id="summaryAddingStock">+1 units</div>
                                </div>
                                <hr class="bg-white">
                                <div class="summary-item">
                                    <small>New Total:</small>
                                    <div class="h4 font-weight-bold" id="summaryNewTotal">1 units</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer bg-light border-0">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal" onclick="playSound('cancel')">
                        <i class="fas fa-times mr-2"></i>
                        Cancel
                    </button>
                    <button type="button" class="btn btn-success btn-lg" id="confirmStockUpdate" onclick="confirmStockUpdate()">
                        <i class="fas fa-check-circle mr-2"></i>
                        Update Stock
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Loading Modal -->
    <div class="modal fade" id="loadingModal" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content border-0 shadow-lg">
                <div class="modal-body text-center p-5">
                    <div class="spinner-border text-primary mb-3" role="status" style="width: 3rem; height: 3rem;">
                        <span class="sr-only">Loading...</span>
                    </div>
                    <h5 class="text-primary" id="loadingMessage">Updating stock...</h5>
                    <p class="text-muted mb-0">Please wait while we process your request</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Success Modal -->
    <div class="modal fade" id="successModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content border-0 shadow-lg">
                <div class="modal-body text-center p-5">
                    <div class="success-icon mb-3">
                        <i class="fas fa-check-circle text-success" style="font-size: 4rem;"></i>
                    </div>
                    <h4 class="text-success mb-3">Stock Updated Successfully!</h4>
                    <div id="successDetails" class="text-muted mb-4"></div>
                    <button type="button" class="btn btn-success" onclick="closeSuccessModal()">
                        <i class="fas fa-thumbs-up mr-2"></i>
                        Continue
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Audio elements for sound effects -->
    <audio id="foundSound" preload="auto">
        <source src="data:audio/wav;base64,UklGRnoGAABXQVZFZm10IBAAAAABAAEAQB8AAEAfAAABAAgAZGF0YQoGAACBhYqFbF1fdJivrJBhNjVgodDbq2EcBj+a2/LDciUFLIHO8tiJNwgZaLvt559NEAxQp+PwtmMcBzuR0fPAayIGAj6a2/LDciUFLYDO8tiJNwgYaLvt559NEAxQp+PwtmMcBzqR0fPAayIGAj6a2/LDciUFLYDO8tiJNwgYaLvt559NEAxPp+PwtmMcBzqR0fPAayIGAj6a2/LDciUFLYDO8tiJNwgYaLvt559NEAxPp+PwtmMcBzqR0fPAayIGAj6a2/LDciUFLYDO8tiJNwgYaLvt559NEAxPp+PwtmMcBzqR0fPAayIGAj6a2/LDciUFLYDO8tiJNwgYaLvt559NEAxPp+PwtmMcBzqR0fPAayIGAj6a2/LDciUFLYDO8tiJNwgYaLvt559NEAxPp+PwtmMcBzqR0fPAayIGAj6a2/LDciUFLYDO8tiJNwgYaLvt55c=" type="audio/wav">
    </audio>
    <audio id="successSound" preload="auto">
        <source src="data:audio/wav;base64,UklGRpIGAABXQVZFZm10IBAAAAABAAEAQB8AAEAfAAABAAgAZGF0YW4GAACBhYqFbF1fdJivrJBhNjVgodDbq2EcBj+a2/LDciUFLIHO8tiJNwgZaLvt559NEAxQp+PwtmMcBzuR0fPAayIGAj6a2/LDciUFLYDO8tiJNwgYaLvt559NEAxPp+PwtmMcBzqR0fPAayIGAj6a2/LDciUFLYDO8tiJNwgYaLvt559NEAxPp+PwtmMcBzqR0fPAayIGAj6a2/LDciUFLYDO8tiJNwgYaLvt55c=" type="audio/wav">
    </audio>
    <audio id="cancelSound" preload="auto">
        <source src="data:audio/wav;base64,UklGRtYGAABXQVZFZm10IBAAAAABAAEAQB8AAEAfAAABAAgAZGF0YbIGAACBhYqFbF1fdJivrJBhNjVgodDbq2EcBj+a2/LDciUFLIHO8tiJNwgZaLvt559NEAxQp+PwtmMcBzuR0fPAayIGAj6a2/LDciUFLYDO8tiJNwgYaLvt559NEAxPp+PwtmMcBzqR0fPAayIGAj6a2/LDciUFLYDO8tiJNwgYaLvt559NEAxPp+PwtmMcBzqR0fPAayIGAj6a2/LDciUFLYDO8tiJNwgYaLvt559NEAxPp+PwtmMcBzqR0fPAayIGAj6a2/LDciUFLYDO8tiJNwgYaLvt55c=" type="audio/wav">
    </audio>
@endsection

@push('script')
    <script>
        $(document).ready(function() {
            console.log("Document ready - jQuery loaded successfully!");
            console.log("Product name field exists:", $("#product_name").length > 0);

            // +++++++++++++++++++++++++   ( 5 )    ++++++++++++++++++++++++++++++++++++++++
            $("#close_modal_btn").click(function() {
                $("#print_invoice_modal").hide(); // Hides the modal
            });

            // Also hide modal when clicking outside of it
            $(window).click(function(event) {
                if ($(event.target).is("#print_invoice_modal")) {
                    $("#print_invoice_modal").hide();
                }
            });
            // +++++++++++++++++++++++++   ( 5 )    ++++++++++++++++++++++++++++++++++++++++

            // +++++++++++++++++++++++++   ( 4 )    ++++++++++++++++++++++++++++++++++++++++
            $('#openAddModelModal').click(function() {
                var brandId = $('#brandDropdown').val(); // Get selected brand ID
                $("#brand_id").val(brandId)
                if (!brandId) {
                    $('#modal-add-model button[type="submit"]').hide();
                    alert('Please select a brand first!');
                    return; // Stop the modal from opening if no brand is selected
                }

                $('#modal-add-model button[type="submit"]').show();
                // Open modal if a brand is selected
                // $('#modal-add-model').modal('show');
            });
            // +++++++++++++++++++++++++   ( 4 )    ++++++++++++++++++++++++++++++++++++++++

            // +++++++++++++++++++++++++   ( 3 )    ++++++++++++++++++++++++++++++++++++++++
            $('#brandDropdown').on('change', function() {
                var brandId = $(this).val(); // Get selected brand ID

                if (brandId) {
                    $.ajax({
                        url: "{{ route('get.models', '') }}/" + brandId, // Call Laravel route
                        type: "GET",
                        success: function(response) {
                            console.log("modelDropdown", response);
                            if (response.success) {
                                var modelDropdown = $('#modelDropdown');
                                modelDropdown.empty(); // Clear existing options
                                modelDropdown.append(
                                    '<option value="">-- Select Model --</option>');

                                $.each(response.models, function(key, model) {
                                    modelDropdown.append('<option value="' + model.id +
                                        '">' + model.name + '</option>');
                                });
                            } else {
                                alert('Error: ' + response.message);
                            }
                        },
                        error: function() {
                            alert("Error fetching models.");
                        }
                    });
                } else {
                    $('#modelDropdown').html(
                        '<option value="">-- Select Model --</option>'
                    ); // Reset models if no brand is selected
                }
            });
            // +++++++++++++++++++++++++   ( 3 )    ++++++++++++++++++++++++++++++++++++++++



            // +++++++++++++++++++++++++   ( 2 )    ++++++++++++++++++++++++++++++++++++++++
            $('#customer_form').on('submit', function(e) {
                e.preventDefault(); // Prevent default form submission

                // Create FormData object to handle file upload
                let formData = new FormData();
                formData.append('customer_name', $('#customer_name').val());
                formData.append('customer_number', $('#customer_number').val());
                formData.append('email', $('#customer_email').val());
                formData.append('customer_cpr', $('#customer_cpr').val());
                formData.append('address', $('#address').val());
                formData.append('_token', '{{ csrf_token() }}');
                
                // Add photo if selected
                let photoFile = $('#cpr_photo')[0].files[0];
                if (photoFile) {
                    formData.append('cpr_photo', photoFile);
                }

                // Disable submit button and show loading
                let submitBtn = $('#customer_form button[type="submit"]');
                let originalText = submitBtn.html();
                submitBtn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin mr-1"></i>Saving...');

                $.ajax({
                    url: "{{ route('customer.store') }}",
                    type: "POST",
                    data: formData,
                    processData: false,
                    contentType: false,
                    success: function(response, status, xhr) {
                        if (xhr.status === 201 || response.success || response.customer) { // HTTP 201 Created
                            // Show success message with photo status
                            let message = 'Customer added successfully!';
                            if (response.photo_saved) {
                                message += ' Photo uploaded successfully.';
                            } else if (photoFile) {
                                message += ' Note: Photo upload failed, but customer was saved.';
                            }
                            
                            // Play success sound
                            if (typeof playSound === 'function') {
                                playSound('success');
                            }
                            
                            // Show enhanced notification
                            if (typeof window.notificationSystem !== 'undefined') {
                                window.notificationSystem.show({
                                    type: 'success',
                                    title: 'Customer Added!',
                                    message: message,
                                    duration: 3000
                                });
                            } else {
                                alert(message);
                            }
                            
                            $('#customer_form')[0].reset(); // Reset the form
                            $('#photo_preview').hide(); // Hide photo preview
                            $('.custom-file-label').text('Choose photo...'); // Reset file label
                            $('#modal-add-customer').modal('hide'); // Hide modal
                        } else {
                            console.log("Unexpected response status: " + xhr.status);
                        }
                    },
                    error: function(xhr) {
                        // Play error sound
                        if (typeof playSound === 'function') {
                            playSound('cancel');
                        }
                        
                        let errorMessage = 'Failed to add customer';
                        if (xhr.status === 422) { // Validation error
                            let errors = xhr.responseJSON.errors;
                            errorMessage = Object.values(errors).flat().join(', ');
                        } else if (xhr.status === 500) { // Server error
                            errorMessage = "Server Error! Please try again.";
                        } else if (xhr.responseJSON && xhr.responseJSON.message) {
                            errorMessage = xhr.responseJSON.message;
                        } else {
                            errorMessage = "An error occurred. Status: " + xhr.status;
                        }
                        
                        // Show enhanced notification
                        if (typeof window.notificationSystem !== 'undefined') {
                            window.notificationSystem.show({
                                type: 'error',
                                title: 'Customer Creation Failed!',
                                message: errorMessage,
                                duration: 5000
                            });
                        } else {
                            alert('Error: ' + errorMessage);
                        }
                        console.log(xhr.responseText);
                    },
                    complete: function() {
                        // Re-enable submit button
                        submitBtn.prop('disabled', false).html(originalText);
                    }
                });
            });
            // +++++++++++++++++++++++++   ( 2 )    ++++++++++++++++++++++++++++++++++++++++

            // Photo preview and validation for customer modal
            $('#cpr_photo').on('change', function() {
                const file = this.files[0];
                const previewContainer = $('#photo_preview');
                const label = $(this).next('.custom-file-label');
                
                if (file) {
                    // Validate file type
                    const allowedTypes = ['image/jpeg', 'image/png', 'image/jpg', 'image/gif'];
                    if (!allowedTypes.includes(file.type)) {
                        alert('Please select a valid image file (JPEG, PNG, JPG, or GIF)');
                        this.value = '';
                        label.text('Choose photo...');
                        previewContainer.hide();
                        return;
                    }
                    
                    // Validate file size (max 5MB)
                    const maxSize = 5 * 1024 * 1024; // 5MB in bytes
                    if (file.size > maxSize) {
                        alert('File size must be less than 5MB');
                        this.value = '';
                        label.text('Choose photo...');
                        previewContainer.hide();
                        return;
                    }
                    
                    // Update label with filename
                    label.text(file.name);
                    
                    // Show preview
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        previewContainer.html(`
                            <div class="text-center">
                                <img src="${e.target.result}" alt="Preview" style="max-width: 150px; max-height: 150px; border-radius: 8px;" class="img-thumbnail">
                                <p class="text-muted mt-2 mb-0" style="font-size: 12px;">Photo Preview</p>
                            </div>
                        `).show();
                    };
                    reader.readAsDataURL(file);
                } else {
                    label.text('Choose photo...');
                    previewContainer.hide();
                }
            });

            // Clear form and preview when customer modal is hidden
            $('#modal-add-customer').on('hidden.bs.modal', function() {
                $('#customer_form')[0].reset();
                $('#photo_preview').hide();
                $('.custom-file-label').text('Choose photo...');
            });


            // +++++++++++++++++++++++++   ( 1 )    ++++++++++++++++++++++++++++++++++++++++
            $("#customer_search").on("keyup", function() {
                let query = $(this).val().trim();
                if (query.length < 2) {
                    $("#customer_results").html("").hide(); // Hide if query is too short
                    return;
                }

                $.ajax({
                    url: "{{ route('api.customers.search') }}",
                    type: "GET",
                    data: {
                        query: query
                    },
                    success: function(response) {
                        let resultHTML = "";
                        if (response.length > 0) {
                            resultHTML += '<ul class="">';
                            $.each(response, function(index, customer) {
                                resultHTML += `<li class=" search-item" data-id="${customer.id}" data-name="${customer.name}" data-number="${customer.number}">
                            <strong>${customer.name}</strong> - ${customer.number}
                        </li>`;
                            });
                            resultHTML += '</ul>';
                        } else {
                            resultHTML =
                                '<p class="dropdown-item text-muted">No results found</p>';
                        }

                        $("#customer_results").html(resultHTML).show(); // Show results
                    }
                });
            });

            // Handle selection
            $(document).on("click", ".search-item", function() {
                let customerId = $(this).data("id");
                let customerName = $(this).data("name");
                let customerNumber = $(this).data("number");

                $("#customer_search").val(`${customerName} (${customerNumber})`);
                $("#customer_info").val(customerId); // Store customer ID
                $("#customer_results").hide(); // Hide dropdown after selection
            });

            // Hide dropdown on clicking outside
            $(document).on("click", function(e) {
                if (!$(e.target).closest("#customer_search, #customer_results").length) {
                    $("#customer_results").hide();
                }
            });
            // +++++++++++++++++++++++++   ( 1 )    ++++++++++++++++++++++++++++++++++++++++
            
            // Test search functionality
            $("#test_search").click(function() {
                alert("Test search button clicked! Check console for details.");
                console.log("Test search clicked - jQuery is working");
                testSearchFunction();
            });

            // Product name auto-search functionality
            $("#product_name").on("input keyup", function() {
                var query = $(this).val().trim();
                console.log("Input changed, query:", query);
                
                if (query.length >= 2) {
                    console.log("Query length >= 2, searching...");
                    searchExistingProducts(query);
                } else {
                    $("#product_search_results").hide().empty();
                    console.log("Query too short, hiding results");
                }
            });

            // Hide search results when clicking outside
            $(document).click(function(e) {
                if (!$(e.target).closest("#product_name, #product_search_results").length) {
                    $("#product_search_results").hide();
                }
            });

            function testSearchFunction() {
                console.log("Testing search with 'Test'");
                console.log("Route URL: {{ route('product.search') }}");
                
                // Test basic connectivity first
                $.ajax({
                    url: "{{ route('product.search') }}",
                    method: "GET",
                    data: { q: "Test" },
                    success: function(response) {
                        console.log("Test search successful:", response);
                        alert("Search test successful! Found " + response.length + " products.");
                    },
                    error: function(xhr, status, error) {
                        console.error("Test search failed:");
                        console.error("Status:", xhr.status);
                        console.error("Error:", error);
                        console.error("Response:", xhr.responseText);
                        alert("Search test failed: " + xhr.status + " - " + error);
                    }
                });
            }

            function searchExistingProducts(query) {
                console.log("Searching for products with query:", query);
                
                // Show loading indicator
                $("#product_search_results").html('<div style="padding: 10px; background: white; border: 1px solid #ccc;">Searching...</div>').show();
                
                $.ajax({
                    url: "{{ route('product.search') }}",
                    method: "GET",
                    data: { q: query },
                    dataType: 'json',
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    success: function(response) {
                        console.log("Search successful, found " + response.length + " products:", response);
                        showSearchResults(response);
                    },
                    error: function(xhr, status, error) {
                        console.error("Search failed:", status, error);
                        console.error("Status Code:", xhr.status);
                        console.error("Response:", xhr.responseText);
                        
                        var errorMsg = "Search failed: ";
                        if (xhr.status === 404) {
                            errorMsg += "Route not found";
                        } else if (xhr.status === 401) {
                            errorMsg += "Authentication required";
                        } else if (xhr.status === 500) {
                            errorMsg += "Server error";
                        } else {
                            errorMsg += error;
                        }
                        
                        $("#product_search_results").html('<div style="padding: 10px; background: white; border: 1px solid #ccc; color: red;">' + errorMsg + '</div>').show();
                        setTimeout(function() {
                            $("#product_search_results").hide();
                        }, 3000);
                    }
                });
            }

            function showSearchResults(products) {
                console.log("Showing search results for", products.length, "products");
                var resultsDiv = $("#product_search_results");
                resultsDiv.empty();

                if (products && products.length > 0) {
                    var html = '<div style="background: white; border: 2px solid #007bff; max-height: 200px; overflow-y: auto; position: absolute; z-index: 1000; width: 100%; box-shadow: 0 4px 6px rgba(0,0,0,0.1);">';
                    html += '<div style="background: #007bff; color: white; padding: 8px; font-weight: bold; text-align: center;">🔍 Found ' + products.length + ' existing product(s) - Click to update stock:</div>';
                    
                    $.each(products, function(index, product) {
                        html += '<div class="search-item" data-id="' + product.id + '" style="padding: 12px; cursor: pointer; border-bottom: 1px solid #eee; transition: all 0.3s;" onmouseover="this.style.backgroundColor=\'#f0f8ff\'" onmouseout="this.style.backgroundColor=\'white\'">';
                        html += '<div style="display: flex; justify-content: space-between; align-items: center;">';
                        html += '<div>';
                        html += '<strong style="color: #333; font-size: 14px;">' + product.name + '</strong>';
                        html += '<br><small style="color: #666;">Current Stock: <span style="color: #28a745; font-weight: bold;">' + product.stock + '</span> | Price: <span style="color: #007bff; font-weight: bold;">BHD ' + parseFloat(product.buy_price).toFixed(2) + '</span></small>';
                        html += '</div>';
                        html += '<div style="background: #28a745; color: white; padding: 5px 10px; border-radius: 15px; font-size: 11px; font-weight: bold;">📦 UPDATE STOCK</div>';
                        html += '</div>';
                        html += '</div>';
                    });
                    
                    html += '</div>';
                    resultsDiv.html(html).show();
                    
                    // Add click handlers with visual feedback
                    resultsDiv.find('.search-item').click(function() {
                        console.log("Product clicked");
                        var productId = $(this).data('id');
                        var product = products.find(function(p) { return p.id == productId; });
                        if (product) {
                            // Visual feedback
                            $(this).css('background-color', '#d4edda');
                            selectProduct(product);
                        }
                    });
                } else {
                    resultsDiv.html('<div style="background: #fff3cd; border: 2px solid #ffc107; padding: 10px; position: absolute; z-index: 1000; width: 100%; text-align: center; color: #856404;">⚠️ No existing products found. You can create a new one.</div>').show();
                    setTimeout(function() {
                        resultsDiv.hide();
                    }, 3000);
                }
            }

            function selectProduct(product) {
                console.log("Selected product:", product);
                
                $("#product_search_results").hide();
                
                // Play found sound
                playSound('found');
                
                // Store product data globally for the modal
                window.currentProduct = product;
                
                // Populate modal with product information
                $('#modalProductName').text(product.name);
                $('#modalCurrentStock').text(product.stock);
                $('#modalCurrentPrice').text('BHD ' + parseFloat(product.buy_price).toFixed(2));
                
                // Initialize summary
                updateStockSummary();
                
                // Show the professional modal
                $('#productFoundModal').modal('show');
                
                // Focus on the input field
                setTimeout(function() {
                    $('#additionalStockInput').focus().select();
                }, 500);
            }

            function updateStock(productId, additionalStock, productName, oldStock) {
                console.log("Updating stock - ID:", productId, "Additional:", additionalStock);
                
                // No loading modal - process directly for faster UX
                
                $.ajax({
                    url: "{{ route('product.updateStock') }}",
                    method: "POST",
                    data: {
                        product_id: productId,
                        additional_stock: additionalStock,
                        _token: $('meta[name="csrf-token"]').attr('content')
                    },
                    timeout: 5000, // 5 second timeout for faster response
                    beforeSend: function(xhr, settings) {
                        console.log("Starting AJAX request to update stock...");
                        console.log("URL:", "{{ route('product.updateStock') }}");
                        console.log("Method:", settings.type);
                        console.log("Data:", {
                            product_id: productId,
                            additional_stock: additionalStock,
                            _token: $('meta[name="csrf-token"]').attr('content')
                        });
                        console.log("CSRF Token:", $('meta[name="csrf-token"]').attr('content'));
                        console.log("Request Headers:", xhr.getAllResponseHeaders);
                    },
                    success: function(response) {
                        console.log("Stock update response:", response);
                        
                        // Show success modal with details directly
                        var successDetails = '';
                        successDetails += '<div class="row text-left">';
                        successDetails += '<div class="col-6"><strong>Product:</strong></div>';
                        successDetails += '<div class="col-6">' + productName + '</div>';
                        successDetails += '<div class="col-6"><strong>Previous Stock:</strong></div>';
                        successDetails += '<div class="col-6">' + oldStock + ' units</div>';
                        successDetails += '<div class="col-6"><strong>Added:</strong></div>';
                        successDetails += '<div class="col-6">+' + additionalStock + ' units</div>';
                        successDetails += '<div class="col-6"><strong>New Total:</strong></div>';
                        successDetails += '<div class="col-6 font-weight-bold text-success">' + response.new_stock + ' units</div>';
                        successDetails += '</div>';
                        
                        $('#successDetails').html(successDetails);
                        $('#successModal').modal('show');
                        
                        // Play success sound
                        playSound('success');
                    },
                    error: function(xhr, status, error) {
                        console.error("Stock update failed:");
                        console.error("Status:", status);
                        console.error("Error:", error);
                        console.error("Response:", xhr.responseText);
                        console.error("Status Code:", xhr.status);
                        
                        // Determine error message based on the type of error
                        var errorMsg = "Error updating stock";
                        
                        if (status === 'timeout') {
                            errorMsg = "Request timed out. Please check your internet connection and try again.";
                        } else if (status === 'error') {
                            if (xhr.status === 0) {
                                errorMsg = "Network error. Please check your internet connection.";
                            } else if (xhr.status === 404) {
                                errorMsg = "Update endpoint not found. Please contact support.";
                            } else if (xhr.status === 500) {
                                errorMsg = "Server error. Please try again later.";
                            } else if (xhr.responseJSON && xhr.responseJSON.message) {
                                errorMsg = xhr.responseJSON.message;
                            } else {
                                errorMsg = "HTTP " + xhr.status + " error occurred.";
                            }
                        }
                        
                        // Use toastr for errors instead of alert
                        if (typeof toastr !== 'undefined') {
                            toastr.error(errorMsg, 'Stock Update Failed', {
                                timeOut: 8000,
                                closeButton: true,
                                progressBar: true
                            });
                        } else {
                            alert("❌ ERROR: " + errorMsg);
                        }
                    },
                    complete: function() {
                        console.log("AJAX request completed");
                    }
                });
            }
            
            // New functions for professional modal system
            function updateStockSummary() {
                if (!window.currentProduct) return;
                
                var additionalStock = parseInt($('#additionalStockInput').val()) || 1;
                var currentStock = window.currentProduct.stock;
                var newTotal = currentStock + additionalStock;
                
                $('#summaryCurrentStock').text(currentStock + ' units');
                $('#summaryAddingStock').text('+' + additionalStock + ' units');
                $('#summaryNewTotal').text(newTotal + ' units');
            }
            
            // Make confirmStockUpdate globally accessible
            window.confirmStockUpdate = function() {
                var additionalStock = parseInt($('#additionalStockInput').val());
                
                if (isNaN(additionalStock) || additionalStock < 1) {
                    // Show error using toastr if available
                    if (typeof toastr !== 'undefined') {
                        toastr.error('Please enter a valid positive number for additional stock.', 'Invalid Input');
                    } else {
                        alert("❌ Please enter a valid positive number for additional stock.");
                    }
                    $('#additionalStockInput').focus().select();
                    return;
                }
                
                // Hide the product found modal
                $('#productFoundModal').modal('hide');
                
                // Update stock using the existing function
                updateStock(window.currentProduct.id, additionalStock, window.currentProduct.name, window.currentProduct.stock);
            }
            
            // Make closeSuccessModal globally accessible
            window.closeSuccessModal = function() {
                // Play success sound
                playSound('success');
                
                // Close the modal
                $('#successModal').modal('hide');
                
                // Clear form for next entry
                $("#ProductType").val("");
                $("#product_name").val("");
                $("#item_price").val("");
                $("#stock_quantity").val("");
                
                // Focus back to product name for next entry
                setTimeout(function() {
                    $("#product_name").focus();
                }, 300);
            }
            
            // Make playSound globally accessible
            window.playSound = function(type) {
                try {
                    // Create Web Audio API context for generating sounds
                    var audioContext = new (window.AudioContext || window.webkitAudioContext)();
                    var oscillator = audioContext.createOscillator();
                    var gainNode = audioContext.createGain();
                    
                    oscillator.connect(gainNode);
                    gainNode.connect(audioContext.destination);
                    
                    // Different sounds for different actions
                    var frequency, duration;
                    switch(type) {
                        case 'found':
                            frequency = 800; // Higher pitch for found
                            duration = 0.3;
                            break;
                        case 'success':
                            frequency = 600; // Lower pitch for success
                            duration = 0.5;
                            break;
                        case 'cancel':
                            frequency = 400; // Even lower for cancel
                            duration = 0.2;
                            break;
                        default:
                            frequency = 500;
                            duration = 0.3;
                    }
                    
                    oscillator.frequency.setValueAtTime(frequency, audioContext.currentTime);
                    oscillator.type = 'sine'; // Smooth sine wave
                    
                    // Volume envelope
                    gainNode.gain.setValueAtTime(0, audioContext.currentTime);
                    gainNode.gain.linearRampToValueAtTime(0.3, audioContext.currentTime + 0.01);
                    gainNode.gain.exponentialRampToValueAtTime(0.001, audioContext.currentTime + duration);
                    
                    oscillator.start(audioContext.currentTime);
                    oscillator.stop(audioContext.currentTime + duration);
                } catch (e) {
                    console.log('Sound not supported:', e);
                    // Fallback: try to use existing audio elements if they exist
                    try {
                        var audio = document.getElementById(type + 'Sound');
                        if (audio) {
                            audio.currentTime = 0;
                            audio.play().catch(function(error) {
                                console.log('Audio play failed:', error);
                            });
                        }
                    } catch (fallbackError) {
                        console.log('Fallback audio failed:', fallbackError);
                    }
                }
            }
            
            // Update summary when input changes
            $(document).on('input', '#additionalStockInput', function() {
                updateStockSummary();
            });
            
            // Handle Enter key in the modal input
            $(document).on('keypress', '#additionalStockInput', function(e) {
                if (e.which === 13) { // Enter key
                    confirmStockUpdate();
                }
            });
        });
    </script>

    <style>
        .search-results {
            position: relative;
            z-index: 1000;
        }

        .search-results-container {
            position: absolute;
            top: 100%;
            left: 0;
            right: 0;
            background: white;
            border: 1px solid #ddd;
            border-radius: 4px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            max-height: 300px;
            overflow-y: auto;
        }

        .search-header {
            background: #f8f9fa;
            padding: 8px 12px;
            font-size: 12px;
            font-weight: bold;
            color: #6c757d;
            border-bottom: 1px solid #eee;
        }

        .search-result-item {
            padding: 12px;
            border-bottom: 1px solid #eee;
            cursor: pointer;
            display: flex;
            justify-content: space-between;
            align-items: center;
            transition: background-color 0.2s;
        }

        .search-result-item:hover {
            background-color: #f8f9fa;
        }

        .search-result-item:last-child {
            border-bottom: none;
        }

        .product-info {
            flex: 1;
        }

        .update-badge {
            background: #007bff;
            color: white;
            padding: 4px 8px;
            border-radius: 12px;
            font-size: 11px;
            font-weight: bold;
        }

        .search-result-item:hover .update-badge {
            background: #0056b3;
        }

        .search-dropdown {
            position: relative;
        }

        .search-item:hover {
            background-color: #f8f9fa !important;
        }
        
        /* Professional Modal Styles */
        .modal-content {
            border-radius: 15px !important;
            overflow: hidden;
        }
        
        .bg-gradient-primary {
            background: linear-gradient(135deg, #007bff 0%, #0056b3 100%) !important;
        }
        
        .bg-gradient-info {
            background: linear-gradient(135deg, #17a2b8 0%, #117a8b 100%) !important;
        }
        
        .product-info-card {
            border-left: 4px solid #007bff;
        }
        
        .summary-card {
            border-radius: 10px;
        }
        
        .success-icon {
            animation: bounceIn 0.6s ease-out;
        }
        
        @keyframes bounceIn {
            0% { transform: scale(0); opacity: 0; }
            50% { transform: scale(1.1); opacity: 1; }
            100% { transform: scale(1); opacity: 1; }
        }
        
        .animate__animated.animate__pulse {
            animation-duration: 1.5s;
        }
        
        .badge-lg {
            font-size: 0.9em;
            padding: 0.5em 0.8em;
        }
        
        .spinner-border {
            animation-duration: 0.75s;
        }
        
        #productFoundModal .modal-body {
            background: linear-gradient(135deg, #f8f9fa 0%, #ffffff 100%);
        }
        
        .input-group-lg .form-control {
            font-size: 1.1rem;
        }
        
        .summary-item {
            border-bottom: 1px solid rgba(255,255,255,0.2);
            padding-bottom: 0.5rem;
        }
        
        .summary-item:last-child {
            border-bottom: none;
        }
        
        /* Hover effects */
        .btn:hover {
            transform: translateY(-1px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.2);
        }
        
        .product-info-card:hover {
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            transition: box-shadow 0.3s ease;
        }
    </style>
@endpush
