

    <h1>Create Sale</h1>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <form action="{{ route('sales.store') }}" method="POST">
        @csrf

        <!-- Customer Selection -->
        <div>
            <label for="customer_id">Customer:</label>
            <select name="customer_id" id="customer_id" required>
                @foreach($customers as $customer)
                    <option value="{{ $customer->id }}">{{ $customer->name }}</option>
                @endforeach
            </select>
        </div>

        <!-- Product Selection -->
        <div>
            <label for="products">Products:</label>
            <div id="product-list">
                <select name="products[0][id]" required>
                    @foreach($products as $product)
                        <option value="{{ $product->id }}">{{ $product->name }} - ${{ $product->buy_price }}</option>
                    @endforeach
                </select>
                <input type="number" name="products[0][quantity]" placeholder="Quantity" required>
                <input type="number" name="products[0][price]" placeholder="Price" required>
            </div>
        </div>

        <!-- Payment Method -->
        <div>
            <label for="payment_method">Payment Method:</label>
            <select name="payment_method" id="payment_method" required>
                <option value="cash">Cash</option>
                <option value="credit">Credit</option>
            </select>
        </div>

        <button type="submit">Complete Sale</button>
    </form>

