@extends('layouts.admin')

@section('title', 'Invoice View')

@section('content')
<div class="content-wrapper">
    <!-- Content Header -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Invoice #{{ $sale->id }}</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('sales.index') }}">Sales</a></li>
                        <li class="breadcrumb-item active">Invoice #{{ $sale->id }}</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Invoice Actions -->
                    <div class="card mb-3">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <h4>Invoice Actions</h4>
                                </div>
                                <div class="col-md-6 text-right">
                                    <div class="btn-group" role="group">
                                        <a href="{{ route('sales.table.invoice.public', $sale->id) }}" 
                                           class="btn btn-primary" target="_blank">
                                            <i class="fas fa-print mr-2"></i>Print Invoice
                                        </a>
                                        <a href="{{ route('sales.edit', $sale->id) }}" 
                                           class="btn btn-warning">
                                            <i class="fas fa-edit mr-2"></i>Edit Sale
                                        </a>
                                        @include('whatsapp.send-button', [
                                            'type' => 'invoice', 
                                            'data' => $sale,
                                            'size' => 'md'
                                        ])
                                        <a href="{{ route('sales.index') }}" 
                                           class="btn btn-secondary">
                                            <i class="fas fa-arrow-left mr-2"></i>Back to Sales
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Invoice Details -->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-file-invoice mr-2"></i>Invoice Details
                            </h3>
                        </div>
                        <div class="card-body">
                            <!-- Company Info & Invoice Info -->
                            <div class="row mb-4">
                                <div class="col-md-6">
                                    <h5 class="mb-3">
                                        <i class="fas fa-building mr-2"></i>{{ config('app.name', 'POS System') }}
                                    </h5>
                                    <address>
                                        <strong>{{ config('app.name', 'POS System') }}</strong><br>
                                        123 Business Street<br>
                                        Business City, BC 12345<br>
                                        Phone: (123) 456-7890<br>
                                        Email: info@possystem.com
                                    </address>
                                </div>
                                <div class="col-md-6 text-right">
                                    <h5 class="mb-3">Invoice Information</h5>
                                    <p>
                                        <strong>Invoice #:</strong> {{ $sale->id }}<br>
                                        <strong>Date:</strong> {{ $sale->created_at->format('M d, Y h:i A') }}<br>
                                        <strong>Status:</strong> 
                                        @if($sale->payment_status == 'paid')
                                            <span class="badge badge-success">Paid</span>
                                        @elseif($sale->payment_status == 'partial')
                                            <span class="badge badge-warning">Partial Payment</span>
                                        @else
                                            <span class="badge badge-danger">Unpaid</span>
                                        @endif
                                    </p>
                                </div>
                            </div>

                            <!-- Customer Info -->
                            <div class="row mb-4">
                                <div class="col-md-6">
                                    <h5 class="mb-3">
                                        <i class="fas fa-user mr-2"></i>Bill To:
                                    </h5>
                                    @if($sale->customer)
                                        <address>
                                            <strong>{{ $sale->customer->name }}</strong><br>
                                            @if($sale->customer->address)
                                                {{ $sale->customer->address }}<br>
                                            @endif
                                            @if($sale->customer->phone)
                                                Phone: {{ $sale->customer->phone }}<br>
                                            @endif
                                            @if($sale->customer->email)
                                                Email: {{ $sale->customer->email }}
                                            @endif
                                        </address>
                                    @else
                                        <p class="text-muted">Walk-in Customer</p>
                                    @endif
                                </div>
                                <div class="col-md-6 text-right">
                                    <h5 class="mb-3">Payment Information</h5>
                                    <p>
                                        <strong>Payment Method:</strong> {{ ucfirst($sale->payment_method ?? 'Cash') }}<br>
                                        <strong>Total Amount:</strong> ${{ number_format($sale->total_amount, 2) }}<br>
                                        <strong>Paid Amount:</strong> ${{ number_format($sale->paid_amount ?? 0, 2) }}<br>
                                        @if($sale->due_amount > 0)
                                            <strong class="text-danger">Due Amount:</strong> ${{ number_format($sale->due_amount, 2) }}
                                        @endif
                                    </p>
                                </div>
                            </div>

                            <!-- Items Table -->
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead class="thead-light">
                                        <tr>
                                            <th>#</th>
                                            <th>Product</th>
                                            <th>Description</th>
                                            <th class="text-center">Qty</th>
                                            <th class="text-right">Unit Price</th>
                                            <th class="text-right">Total</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($sale->items as $index => $item)
                                            <tr>
                                                <td>{{ $index + 1 }}</td>
                                                <td>
                                                    <strong>{{ $item->product_name ?? $item->product->name ?? 'Unknown Product' }}</strong>
                                                    @if($item->product && $item->product->ProductBrand)
                                                        <br><small class="text-muted">Brand: {{ $item->product->ProductBrand->name }}</small>
                                                    @endif
                                                </td>
                                                <td>
                                                    @if($item->product && $item->product->description)
                                                        {{ Str::limit($item->product->description, 100) }}
                                                    @else
                                                        <span class="text-muted">No description</span>
                                                    @endif
                                                </td>
                                                <td class="text-center">{{ $item->quantity }}</td>
                                                <td class="text-right">${{ number_format($item->unit_price, 2) }}</td>
                                                <td class="text-right">${{ number_format($item->total_price, 2) }}</td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="6" class="text-center">No items found</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="5" class="text-right"><strong>Subtotal:</strong></td>
                                            <td class="text-right"><strong>${{ number_format($sale->subtotal ?? $sale->total_amount, 2) }}</strong></td>
                                        </tr>
                                        @if($sale->tax_amount > 0)
                                            <tr>
                                                <td colspan="5" class="text-right">Tax:</td>
                                                <td class="text-right">${{ number_format($sale->tax_amount, 2) }}</td>
                                            </tr>
                                        @endif
                                        @if($sale->discount_amount > 0)
                                            <tr>
                                                <td colspan="5" class="text-right">Discount:</td>
                                                <td class="text-right">-${{ number_format($sale->discount_amount, 2) }}</td>
                                            </tr>
                                        @endif
                                        <tr class="table-active">
                                            <td colspan="5" class="text-right"><strong>Total Amount:</strong></td>
                                            <td class="text-right"><strong>${{ number_format($sale->total_amount, 2) }}</strong></td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>

                            <!-- Notes -->
                            @if($sale->notes)
                                <div class="row mt-4">
                                    <div class="col-12">
                                        <h5>Notes:</h5>
                                        <p class="text-muted">{{ $sale->notes }}</p>
                                    </div>
                                </div>
                            @endif

                            <!-- Terms & Conditions -->
                            <div class="row mt-4">
                                <div class="col-12">
                                    <h6>Terms & Conditions:</h6>
                                    <p class="text-muted small">
                                        Thank you for your business! Payment is due within 30 days of invoice date.
                                        A late fee of 1.5% per month will be applied to overdue accounts.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection

@section('scripts')
<script>
$(document).ready(function() {
    // Auto-focus on print button for easy printing
    setTimeout(function() {
        $('.btn-group .btn-primary').focus();
    }, 500);
});
</script>
@endsection

@section('styles')
<style>
.invoice-header {
    border-bottom: 3px solid #007bff;
    padding-bottom: 20px;
    margin-bottom: 30px;
}

.invoice-info {
    background-color: #f8f9fa;
    padding: 15px;
    border-radius: 5px;
    margin-bottom: 20px;
}

.table-invoice {
    margin-bottom: 0;
}

.table-invoice th {
    background-color: #343a40;
    color: white;
    border-color: #454d55;
}

address {
    line-height: 1.6;
}

.card {
    box-shadow: 0 0 10px rgba(0,0,0,.1);
}

@media print {
    .btn-group, .card-header, .breadcrumb, .content-header {
        display: none !important;
    }
    
    .content-wrapper {
        margin: 0 !important;
        padding: 0 !important;
    }
    
    .card {
        border: none !important;
        box-shadow: none !important;
    }
}
</style>
@endsection