@extends('layouts.app')

@push('style')
    <style>
        /* Style for the exchange fields */
        #exchange_fields {
            display: none;
            margin-top: 20px;
        }

        #exchange_fields .form-group {
            margin-bottom: 15px;
        }

        /* Customer search results styling */
        .search-results {
            position: absolute;
            top: 100%;
            left: 0;
            right: 0;
            background: white;
            border: 1px solid #ddd;
            border-top: none;
            max-height: 200px;
            overflow-y: auto;
            z-index: 1000;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }

        .search-results ul {
            list-style: none;
            margin: 0;
            padding: 0;
        }

        .search-results .search-item {
            padding: 10px 15px;
            cursor: pointer;
            border-bottom: 1px solid #eee;
            transition: background-color 0.2s;
        }

        .search-results .search-item:hover {
            background-color: #f8f9fa;
        }

        .search-results .search-item:last-child {
            border-bottom: none;
        }

        .form-group {
            position: relative;
        }

        /* Photo upload styling */
        .custom-file-label::after {
            content: "Browse";
        }
        
        #photo_preview {
            text-align: center;
        }
        
        #preview_image {
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
    </style>
@endpush

@section('main')
    <div class="container mt-5">
        <h1 class="mb-4">Sell Product</h1>

        @if (session('error'))
            <div class="alert alert-danger">{{ session('error') }}</div>
        @endif

        <div class="card shadow-sm mb-4">
            <div class="card-header bg-primary text-white">
                <h5 class="card-title mb-0">Product Details</h5>
            </div>
            <div class="card-body">
                @if ($product->brand)
                    <p><strong>Brand:</strong> {{ $product->brand }}</p>
                @endif
                @if ($product->model)
                    <p><strong>Model:</strong> {{ $product->model }}</p>
                @endif
                @if ($product->type)
                    <p><strong>Product category:</strong> {{ $product->type }}</p>
                @endif
                @if ($product->name)
                    <p><strong>Product Name:</strong> {{ $product->name }}</p>
                @endif
                @if ($product->stock)
                    <p><strong>Stock:</strong> {{ $product->stock }}</p>
                @endif
            </div>
        </div>

        <form action="{{ route('sell.process', $product->id) }}" method="POST">
            @csrf

            <div class="form-group">
                <label for="customer_search">Customer Name:</label>
                <input type="text" class="form-control" name="customer_name" id="customer_search" required>
                <input type="hidden" name="customer_id" id="customer_info">
                <div id="customer_results" class="search-results"></div>
            </div>

            <button type="button" class="btn btn-outline-primary mb-3" data-toggle="modal" data-target="#modal-add-customer">
                <i class="fas fa-plus"></i> Add New Customer
            </button>

            <div class="form-group">
                <label for="sell_price">Selling Price:</label>
                <input type="number" step="0.01" class="form-control" name="sell_price" required>
            </div>

            <div class="form-group">
                <label for="sold_quantity">Quantity Sold:</label>
                <input type="number" class="form-control" value="1" id="qty" name="sold_quantity" required>
            </div>

            <div class="form-group">
                <label for="warranty">Warranty:</label>
                <select class="form-control" name="warranty" id="warranty">
                    <option value="No Warranty">No Warranty</option>
                    <option value="1 Day">1 Day</option>
                    <option value="7 Days">7 Days</option>
                    <option value="1 Month">1 Month</option>
                    <option value="3 Months">3 Months</option>
                    <option value="6 Months">6 Months</option>
                    <option value="1 Year">1 Year</option>
                    <option value="Custom">Custom</option>
                </select>
            </div>

            <div id="customWarranty" class="form-group" style="display: none;">
                <label for="custom_warranty_value">Custom Warranty Value:</label>
                <input type="number" name="custom_warranty_value" class="form-control">
                <label for="custom_warranty_unit">Custom Warranty Unit:</label>
                <select name="custom_warranty_unit" class="form-control">
                    <option value="Days">Days</option>
                    <option value="Months">Months</option>
                    <option value="Years">Years</option>
                </select>
            </div>

           <!-- Exchange Product -->
<div class="form-group">
    <label for="exchange_product">Exchange Product:</label>
    <input type="text" class="form-control" name="exchange_product" id="exchange_product" placeholder="Search for exchange product">
    <!-- Button to open the Add Product Modal -->
    <button type="button" class="btn btn-outline-primary mt-2" data-toggle="modal" data-target="#modal-add-exchange-product">
        <i class="fas fa-plus"></i> Add New Product for Exchange
    </button>
</div>
--model exchange --
            <!-- Exchange Fields -->
            <div id="exchange_fields">
                <div class="form-group">
                    <label for="exchange_product">Exchange Product:</label>
                    <input type="text" class="form-control" name="exchange_product" id="exchange_product" placeholder="Search for exchange product">
                </div>

                <div class="form-group">
                    <label for="exchange_value">Exchange Value3:</label>
                    <input type="number" step="0.01" class="form-control" name="exchange_value" id="exchange_value" placeholder="Value of the exchanged product">
                </div>
            </div>

            <button type="submit" class="btn btn-success btn-block">Sell Product</button>
        </form>
    </div>
<!-- Add Product for Exchange Modal -->
<div class="modal fade" id="modal-add-exchange-product" tabindex="-1" role="dialog" aria-labelledby="modal-add-exchange-product-label" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modal-add-exchange-product-label">Add Exchange Product</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="product_form">
                @csrf
                <div class="modal-body">
                    <div class="form-group">
                        <label for="brand">Product Brand:</label>
                        <input type="text" class="form-control" name="brand" id="brand" required>
                    </div>

                    <div class="form-group">
                        <label for="model">Produc Model:</label>
                        <input type="text" class="form-control" name="model" id="model" required>
                    </div>

                    <div class="form-group">
                        <label for="buy_price">Product Price:</label>
                        <input type="number" step="0.01" class="form-control" name="buy_price" id="buy_price" required>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Add Product</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

    {{-- Add Customer Modal --}}
    <div class="modal fade" id="modal-add-customer" tabindex="-1" role="dialog" aria-labelledby="modal-add-customer-label" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header bg-info text-white">
                    <h5 class="modal-title" id="modal-add-customer-label">
                        <i class="fas fa-user-plus mr-2"></i>Add New Customer
                    </h5>
                    <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="customer_form">
                    @csrf
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="customer_name">
                                        <i class="fas fa-user mr-1"></i>Customer Name <span class="text-danger">*</span>
                                    </label>
                                    <input type="text" id="customer_name" class="form-control" name="customer_name" placeholder="Enter customer name" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="customer_number">
                                        <i class="fas fa-phone mr-1"></i>Phone Number <span class="text-danger">*</span>
                                    </label>
                                    <input type="tel" id="customer_number" class="form-control" name="customer_number" placeholder="Enter phone number" required>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="customer_email">
                                        <i class="fas fa-envelope mr-1"></i>Email Address
                                    </label>
                                    <input type="email" id="customer_email" class="form-control" name="customer_email" placeholder="Enter email address">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="customer_cpr">
                                        <i class="fas fa-id-card mr-1"></i>CPR/ID Number
                                    </label>
                                    <input type="text" id="customer_cpr" class="form-control" name="customer_cpr" placeholder="Enter CPR/ID number">
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="address">
                                <i class="fas fa-map-marker-alt mr-1"></i>Address
                            </label>
                            <textarea id="address" class="form-control" name="address" rows="2" placeholder="Enter full address"></textarea>
                        </div>

                        <div class="form-group">
                            <label for="customer_notes">
                                <i class="fas fa-sticky-note mr-1"></i>Notes
                            </label>
                            <textarea id="customer_notes" class="form-control" name="customer_notes" rows="2" placeholder="Any additional notes about the customer"></textarea>
                        </div>

                        <div class="form-group">
                            <label for="cpr_photo">
                                <i class="fas fa-camera mr-1"></i>CPR/ID Photo
                            </label>
                            <div class="custom-file">
                                <input type="file" class="custom-file-input" id="cpr_photo" name="cpr_photo" accept="image/*">
                                <label class="custom-file-label" for="cpr_photo">Choose photo...</label>
                            </div>
                            <small class="form-text text-muted">Supported formats: JPG, PNG, GIF (Max: 2MB)</small>
                            <div id="photo_preview" style="display: none; margin-top: 10px;">
                                <img id="preview_image" src="" alt="Photo Preview" style="max-width: 200px; max-height: 150px; border: 1px solid #ddd; border-radius: 5px;">
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">
                            <i class="fas fa-times mr-1"></i>Cancel
                        </button>
                        <button type="submit" class="btn btn-info">
                            <i class="fas fa-save mr-1"></i>Save Customer
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('script')
    <script>
        document.getElementById("warranty").addEventListener("change", function() {
            document.getElementById("customWarranty").style.display = this.value === "Custom" ? "block" : "none";
        });

        $("#customer_search").on("keyup", function() {
            let query = $(this).val().trim();
            if (query.length < 2) {
                $("#customer_results").html("").hide(); // Hide if query is too short
                return;
            }

            $.ajax({
                url: "{{ route('api.customers.search') }}",
                type: "GET",
                data: { query: query },
                success: function(response) {
                    let resultHTML = "";
                    if (response.length > 0) {
                        resultHTML += '<ul>';
                        $.each(response, function(index, customer) {
                            resultHTML += `
                                <li class="search-item" data-id="${customer.id}" data-name="${customer.name}" data-number="${customer.number}">
                                    <strong>${customer.name}</strong> - ${customer.number}
                                </li>`;
                        });
                        resultHTML += '</ul>';
                    } else {
                        resultHTML = '<p class="dropdown-item text-muted">No results found</p>';
                    }
                    $("#customer_results").html(resultHTML).show();
                }
            });
        });

        $(document).on("click", ".search-item", function() {
            let customerId = $(this).data("id");
            let customerName = $(this).data("name");
            let customerNumber = $(this).data("number");

            $("#customer_search").val(`${customerName} (${customerNumber})`);
            $("#customer_info").val(customerId);
            $("#customer_results").hide();
        });

        $(document).on("click", function(e) {
            if (!$(e.target).closest("#customer_search, #customer_results").length) {
                $("#customer_results").hide();
            }
        });

        // Toggle exchange fields visibility
        $('#exchange_checkbox').on('change', function() {
            if ($(this).is(':checked')) {
                $('#exchange_fields').show();
            } else {
                $('#exchange_fields').hide();
            }
        });

        // Handle customer form submission
        $('#customer_form').on('submit', function(e) {
            e.preventDefault();
            
            // Create FormData object to handle file upload
            let formData = new FormData();
            formData.append('customer_name', $('#customer_name').val());
            formData.append('customer_number', $('#customer_number').val());
            formData.append('email', $('#customer_email').val());
            formData.append('customer_cpr', $('#customer_cpr').val());
            formData.append('address', $('#address').val());
            formData.append('_token', '{{ csrf_token() }}');
            
            // Add photo if selected
            let photoFile = $('#cpr_photo')[0].files[0];
            if (photoFile) {
                formData.append('cpr_photo', photoFile);
            }

            // Disable submit button and show loading
            let submitBtn = $('#customer_form button[type="submit"]');
            let originalText = submitBtn.html();
            submitBtn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin mr-1"></i>Saving...');

            // Submit form via AJAX
            $.ajax({
                url: "{{ route('customer.store') }}",
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    if (response.success || response.customer) {
                        // Show success message with photo status
                        let message = 'Customer added successfully!';
                        if (response.photo_saved) {
                            message += ' Photo uploaded successfully.';
                        } else if ($('#cpr_photo')[0].files[0]) {
                            message += ' Note: Photo upload failed, but customer was saved.';
                        }
                        alert(message);
                        
                        // If customer was created, update the customer search field
                        if (response.customer) {
                            $('#customer_search').val(`${response.customer.name} (${response.customer.number})`);
                            $('#customer_info').val(response.customer.id);
                        }
                        
                        // Reset form and preview
                        $('#customer_form')[0].reset();
                        $('#photo_preview').hide();
                        $('.custom-file-label').text('Choose photo...');
                        
                        // Close modal
                        $('#modal-add-customer').modal('hide');
                    } else {
                        alert('Error: ' + (response.message || 'Failed to add customer'));
                    }
                },
                error: function(xhr, status, error) {
                    let errorMessage = 'Failed to add customer';
                    if (xhr.responseJSON && xhr.responseJSON.message) {
                        errorMessage = xhr.responseJSON.message;
                    } else if (xhr.responseJSON && xhr.responseJSON.errors) {
                        let errors = xhr.responseJSON.errors;
                        errorMessage = Object.values(errors).flat().join('\n');
                    }
                    alert('Error: ' + errorMessage);
                },
                complete: function() {
                    // Re-enable submit button
                    submitBtn.prop('disabled', false).html(originalText);
                }
            });
        });

        // Handle photo file input change
        $('#cpr_photo').on('change', function() {
            const file = this.files[0];
            const label = $(this).next('.custom-file-label');
            
            if (file) {
                // Validate file size (2MB = 2 * 1024 * 1024 bytes)
                if (file.size > 2 * 1024 * 1024) {
                    alert('File size must be less than 2MB. Please choose a smaller file.');
                    $(this).val('');
                    label.text('Choose photo...');
                    $('#photo_preview').hide();
                    return;
                }
                
                // Validate file type
                if (!file.type.startsWith('image/')) {
                    alert('Please select a valid image file (JPG, PNG, GIF).');
                    $(this).val('');
                    label.text('Choose photo...');
                    $('#photo_preview').hide();
                    return;
                }
                
                // Update label with filename
                label.text(file.name);
                
                // Show preview
                const reader = new FileReader();
                reader.onload = function(e) {
                    $('#preview_image').attr('src', e.target.result);
                    $('#photo_preview').show();
                };
                reader.readAsDataURL(file);
            } else {
                label.text('Choose photo...');
                $('#photo_preview').hide();
            }
        });
    </script>
@endpush
