

<?php $__env->startSection('main'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Create Subscription</h3>
                </div>
                <div class="card-body">
                    <?php if(isset($existingSubscription)): ?>
                        <div class="alert
                            <?php if($existingSubscription->status == 'pending'): ?> alert-warning
                            <?php elseif($existingSubscription->status == 'cancelled'): ?> alert-danger
                            <?php elseif($existingSubscription->status == 'expired'): ?> alert-secondary
                            <?php else: ?> alert-info
                            <?php endif; ?>
                            alert-dismissible fade show" role="alert">
                            <strong>
                                <?php if($existingSubscription->status == 'pending'): ?> Subscription Pending:
                                <?php elseif($existingSubscription->status == 'cancelled'): ?> Subscription Cancelled:
                                <?php elseif($existingSubscription->status == 'expired'): ?> Subscription Expired:
                                <?php else: ?> Status: <?php echo e(ucfirst($existingSubscription->status)); ?>:
                                <?php endif; ?>
                            </strong>
                            <?php if($existingSubscription->status == 'pending'): ?>
                                You have a subscription request pending approval. Please wait for admin approval before creating a new one.
                            <?php elseif($existingSubscription->status == 'cancelled'): ?>
                                Your previous subscription was cancelled. You can create a new subscription if needed.
                            <?php elseif($existingSubscription->status == 'expired'): ?>
                                Your previous subscription has expired. You can create a new subscription if needed.
                            <?php else: ?>
                                Your subscription status is <?php echo e(ucfirst($existingSubscription->status)); ?>.
                            <?php endif; ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    <?php endif; ?>
                    <form action="<?php echo e(route('subscriptions.store')); ?>" method="POST" <?php if(isset($existingSubscription) && $existingSubscription->status == 'pending'): ?> style="pointer-events: none; opacity: 0.5;" <?php endif; ?>>
                        <?php echo csrf_field(); ?>
                        <div class="form-group">
                            <label for="plan_id">Plan</label>
                            <select class="form-control" id="plan_id" name="plan_id" required <?php if(isset($existingSubscription) && $existingSubscription->status == 'pending'): ?> disabled <?php endif; ?>>
                                <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($plan->id); ?>"><?php echo e($plan->name); ?> - $<?php echo e($plan->price); ?>/<?php echo e($plan->interval); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <button type="submit" class="btn btn-primary" <?php if(isset($existingSubscription) && $existingSubscription->status == 'pending'): ?> disabled <?php endif; ?>>Create</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/quickphone/public_html/bh.quickphone.us/test/resources/views/admin/subscriptions/create.blade.php ENDPATH**/ ?>