

<?php $__env->startSection('main'); ?>
    <section class="content-header">
        <section class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Sales Profit Report</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item active">Sales Profit Report</li>
                    </ol>
                </div>
            </div>
        </section>
    </section>

    <section class="content">
        <div class="card">
            <div class="card-body">
                <!-- Date Range Picker -->
                <div class="row">
                    <div class="col-md-4">
                        <label>Select Date Range:</label>
                        <input type="text" name="date_range" id="date_range" class="form-control"
                            placeholder="Select Date Range">
                    </div>
                </div>

                <!-- Table to Display Transactions -->
                <table id="data_table" class="table table-bordered table-striped mt-3">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Brand</th>
                            <th>Model</th>
                            <th>Product ID</th>
                            <th>Warranty</th>
                            <th>Customer Name</th>
                            <th>Sale Date</th>
                            <th>Buy Price</th>
                            <th>Sell Price</th>
                            <th>Sold Quantity</th>
                            <th>Profit</th>
                        </tr>
                    </thead>
                    <tbody id="table_body">
                        <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($transaction->id); ?></td>
                                <td><?php echo e($transaction->product->brand ?? '-'); ?></td>
                                <td><?php echo e($transaction->product->model ?? '-'); ?></td>
                                <td><?php echo e($transaction->product->id); ?></td>
                                <td><?php echo e($transaction->warranty); ?></td>
                                <td><?php echo e(optional($transaction->sale->customer)->name); ?></td>
                                <td><?php echo e(\Carbon\Carbon::parse($transaction->created_at)->format('Y-m-d')); ?></td>
                                <td><?php echo e(env('APP_CURRENCY')); ?> <?php echo e($transaction->product->buy_price); ?></td>
                                <td><?php echo e(env('APP_CURRENCY')); ?> <?php echo e($transaction->sell_price); ?></td>
                                <td><?php echo e($transaction->sold_quantity); ?></td>
                                <td><?php echo e(env('APP_CURRENCY')); ?> <?php echo e($transaction->profit); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        $(document).ready(function() {
            $('#date_range').daterangepicker({
                autoUpdateInput: false,
                locale: {
                    cancelLabel: 'Clear',
                    format: 'YYYY-MM-DD'
                },
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1,
                        'month').endOf('month')],
                    'This Year': [moment().startOf('year'), moment().endOf('year')],
                    'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year')
                        .endOf('year')
                    ],
                    'Custom Range': []
                }
            });

            // When a predefined range is selected
            $('#date_range').on('apply.daterangepicker', function(ev, picker) {
                $(this).val(picker.startDate.format('YYYY-MM-DD') + ' - ' + picker.endDate.format(
                    'YYYY-MM-DD'));
                fetchFilteredData($(this).val());
            });

            // Clear input on cancel
            $('#date_range').on('cancel.daterangepicker', function(ev, picker) {
                $(this).val('');
                fetchFilteredData('');
            });

            function fetchFilteredData(dateRange) {
                $.ajax({
                    url: "<?php echo e(route('sales.profit.report')); ?>",
                    type: "GET",
                    data: {
                        date_range: dateRange
                    },
                    success: function(response) {
                        console.log("reps", response);

                        $('#table_body').empty();

                        if (response.transactions.length > 0) {
                            $.each(response.transactions, function(index, transaction) {
                                $('#table_body').append(`
                            <tr>
                                <td>${transaction.id}</td>
                                <td>${transaction.product.product_brand.name}</td>
                                <td>${transaction.product.product_model.name}</td>
                                <td>${transaction.product.id}</td>
                                <td>${transaction.warranty}</td>
                                <td>${transaction.sale.customer ? transaction.sale.customer.name : 'N/A'}</td>
                                <td>${transaction.created_at}</td>
                                <td><?php echo e(env('APP_CURRENCY')); ?> ${transaction.sell_price}</td>
                                <td>${transaction.sold_quantity}</td>
                                <td><?php echo e(env('APP_CURRENCY')); ?> ${transaction.profit}</td>
                            </tr>
                        `);
                            });
                        } else {
                            $('#table_body').append(
                                '<tr><td colspan="11" class="text-center">No records found</td></tr>'
                            );
                        }
                    }
                });
            }
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/quickphone/public_html/bh.quickphone.us/pos/resources/views/sell/profit_report.blade.php ENDPATH**/ ?>