<?php $__env->startSection('main'); ?>

<!-- Include DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.21/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css">

<div class="container-fluid">
    <h1 class="mt-5">Expense Report</h1>

    <div class="row">
        <div class="col-lg-12 col-md-12 col-12">
            <div class="small-box bg-info">
                <div class="inner">
                    <h3>$<?php echo e(number_format($totalExpenses, 2)); ?></h3>
                    <p>Total Expenses</p>
                </div>
                <div class="icon">
                    <i class="ion ion-pie-graph"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Date Range Picker -->
    <div class="row mb-3">
        <div class="col-md-6">
            <div class="form-group">
                <label>Date Range:</label>
                <div class="input-group">
                    <button type="button" class="btn btn-default float-right" id="daterange-btn">
                        <i class="far fa-calendar-alt"></i> <span>Select Date Range</span>
                        <i class="fas fa-caret-down"></i>
                    </button>
                </div>
            </div>
        </div>
    </div>

    <table id="expensesTable" class="table table-striped table-bordered mt-3">
        <thead>
            <tr>
                <th>#</th>
                <th>Expense Date</th>
                <th>Category</th>
                <th>Expense For</th>
                <th>Amount</th>
                <th>Note</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $expense): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($index + 1); ?></td>
                    <td><?php echo e($expense->expense_date); ?></td>
                    <td><?php echo e($expense->category_name); ?></td>
                    <td><?php echo e($expense->expense_for); ?></td>
                    <td>$<?php echo e(number_format($expense->amount, 2)); ?></td>
                    <td><?php echo e($expense->note); ?></td>
                    <td>
                        <form action="<?php echo e(route('expenses.destroy', $expense->id)); ?>" method="POST" style="display: inline-block;">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')">
                                <i class="fas fa-trash"></i> Delete
                            </button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
        <tfoot>
            <tr>
                <th colspan="4">Total</th>
                <th>$<?php echo e(number_format($totalExpenses, 2)); ?></th>
                <th colspan="2"></th>
            </tr>
        </tfoot>
    </table>
</div>

<!-- Include jQuery and DataTables JS -->
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>

<!-- Include AdminLTE 3 Date Range Picker JS -->
<script src="<?php echo e(asset('adminlte/plugins/moment/moment.min.js')); ?>"></script>
<script src="<?php echo e(asset('adminlte/plugins/daterangepicker/daterangepicker.js')); ?>"></script>

<script>
    $(document).ready(function() {
        // Initialize DataTable
        var table = $('#expensesTable').DataTable({
            "paging": true,
            "lengthChange": true,
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": false,
            "responsive": true,
            "footerCallback": function(row, data, start, end, display) {
                var api = this.api();

                // Calculate total for all rows
                var total = api
                    .column(4, { search: 'applied' })
                    .data()
                    .reduce(function(a, b) {
                        return parseFloat(a) + parseFloat(b.replace(/[^0-9.-]+/g, ""));
                    }, 0);

                // Update footer
                $(api.column(4).footer()).html('$' + total.toFixed(2));
            }
        });

        // Initialize Date Range Picker
        if ($.fn.daterangepicker) {
            $('#daterange-btn').daterangepicker(
                {
                    ranges: {
                        'Today': [moment(), moment()],
                        'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                        'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                        'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                        'This Month': [moment().startOf('month'), moment().endOf('month')],
                        'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                    },
                    startDate: moment().subtract(29, 'days'),
                    endDate: moment()
                },
                function(start, end) {
                    $('#daterange-btn span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));

                    // Filter DataTable based on date range
                    var startDate = start.format('YYYY-MM-DD');
                    var endDate = end.format('YYYY-MM-DD');

                    table.draw(); // Redraw the table

                    // Update total amount in the box
                    updateTotalAmount(startDate, endDate);
                }
            );
        } else {
            console.error('Date Range Picker plugin is not loaded.');
        }

        // Custom DataTable filtering for date range
        $.fn.dataTable.ext.search.push(function(settings, data, dataIndex) {
            var min = $('#daterange-btn').data('daterangepicker').startDate.format('YYYY-MM-DD');
            var max = $('#daterange-btn').data('daterangepicker').endDate.format('YYYY-MM-DD');
            var date = data[1]; // Assuming the date is in the second column

            if (
                (min === null && max === null) ||
                (min === null && date <= max) ||
                (min <= date && max === null) ||
                (min <= date && date <= max)
            ) {
                return true;
            }
            return false;
        });

        // Function to update total amount in the box
        function updateTotalAmount(startDate, endDate) {
            var total = 0;

            table.rows({ search: 'applied' }).every(function(rowIdx, tableLoop, rowLoop) {
                var data = this.data();
                var date = data[1]; // Assuming the date is in the second column
                var amount = parseFloat(data[4].replace(/[^0-9.-]+/g, "")); // Assuming the amount is in the fifth column

                if (date >= startDate && date <= endDate) {
                    total += amount;
                }
            });

            $('.small-box .inner h3').text('$' + total.toFixed(2));
        }

        // Initial total amount calculation
        var initialStartDate = $('#daterange-btn').data('daterangepicker').startDate.format('YYYY-MM-DD');
        var initialEndDate = $('#daterange-btn').data('daterangepicker').endDate.format('YYYY-MM-DD');
        updateTotalAmount(initialStartDate, initialEndDate);
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/quickphone/public_html/bh.quickphone.us/pos/resources/views/expenses/report.blade.php ENDPATH**/ ?>