<?php $__env->startSection('content'); ?>
<div class="container">
    <h2>Edit Expense</h2>
    <form action="<?php echo e(route('expenses.update', $expense->id)); ?>" method="POST">
  
        <?php echo method_field('PUT'); ?>
        <div class="form-group">
            <label for="expense_date">Expense Date *</label>
            <input type="date" name="expense_date" id="expense_date" class="form-control" value="<?php echo e($expense->expense_date); ?>" required>
        </div>

        <div class="form-group">
            <label for="category">Category *</label>
            <select name="category" id="category" class="form-control" required>
                <option value="Food" <?php echo e($expense->category == 'Food' ? 'selected' : ''); ?>>Food</option>
                <option value="Transport" <?php echo e($expense->category == 'Transport' ? 'selected' : ''); ?>>Transport</option>
                <option value="Accommodation" <?php echo e($expense->category == 'Accommodation' ? 'selected' : ''); ?>>Accommodation</option>
            </select>
        </div>

        <div class="form-group">
            <label for="expense_for">Expense For *</label>
            <input type="text" name="expense_for" id="expense_for" class="form-control" value="<?php echo e($expense->expense_for); ?>" required>
        </div>

        <div class="form-group">
            <label for="amount">Amount *</label>
            <input type="number" name="amount" id="amount" class="form-control" value="<?php echo e($expense->amount); ?>" required>
        </div>

        <div class="form-group">
            <label for="reference_no">Reference No.</label>
            <input type="text" name="reference_no" id="reference_no" class="form-control" value="<?php echo e($expense->reference_no); ?>">
        </div>

        <div class="form-group">
            <label for="note">Note</label>
            <textarea name="note" id="note" class="form-control"><?php echo e($expense->note); ?></textarea>
        </div>

        <button type="submit" class="btn btn-success">Save Changes</button>
        <a href="<?php echo e(route('expenses.index')); ?>" class="btn btn-warning">Close</a>
    </form>
</div>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/quickphone/public_html/bh.quickphone.us/pos/resources/views/expenses/edit.blade.php ENDPATH**/ ?>