

<?php $__env->startSection('content'); ?>
<div class="container mt-5">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header 
                    <?php if($existingSubscription->status == 'pending'): ?> bg-warning text-white
                    <?php elseif($existingSubscription->status == 'cancelled'): ?> bg-danger text-white
                    <?php elseif($existingSubscription->status == 'expired'): ?> bg-secondary text-white
                    <?php else: ?> bg-info text-white
                    <?php endif; ?>
                ">
                    <h4 class="mb-0">
                        <i class="fas 
                            <?php if($existingSubscription->status == 'pending'): ?> fa-clock
                            <?php elseif($existingSubscription->status == 'cancelled'): ?> fa-times-circle
                            <?php elseif($existingSubscription->status == 'expired'): ?> fa-calendar-times
                            <?php else: ?> fa-info-circle
                            <?php endif; ?>
                        "></i> 
                        <?php if($existingSubscription->status == 'pending'): ?> Subscription Pending Approval
                        <?php elseif($existingSubscription->status == 'cancelled'): ?> Subscription Cancelled
                        <?php elseif($existingSubscription->status == 'expired'): ?> Subscription Expired
                        <?php else: ?> Subscription Status: <?php echo e(ucfirst($existingSubscription->status)); ?>

                        <?php endif; ?>
                    </h4>
                </div>
                <div class="card-body text-center">
                    <div class="mb-4">
                        <i class="fas 
                            <?php if($existingSubscription->status == 'pending'): ?> fa-hourglass-half fa-4x text-warning
                            <?php elseif($existingSubscription->status == 'cancelled'): ?> fa-times-circle fa-4x text-danger
                            <?php elseif($existingSubscription->status == 'expired'): ?> fa-calendar-times fa-4x text-secondary
                            <?php else: ?> fa-info-circle fa-4x text-info
                            <?php endif; ?>
                        "></i>
                    </div>
                    <h5 class="card-title">
                        <?php if($existingSubscription->status == 'pending'): ?> Your subscription request is still under review
                        <?php elseif($existingSubscription->status == 'cancelled'): ?> Your subscription has been cancelled
                        <?php elseif($existingSubscription->status == 'expired'): ?> Your subscription has expired
                        <?php else: ?> Your subscription status is: <?php echo e(ucfirst($existingSubscription->status)); ?>

                        <?php endif; ?>
                    </h5>
                    <p class="card-text">
                        <?php if($existingSubscription->status == 'pending'): ?>
                            You have already submitted a subscription request that is currently pending approval from the super admin.
                            Please wait for the admin to review and approve your subscription before creating a new one.
                        <?php elseif($existingSubscription->status == 'cancelled'): ?>
                            Your previous subscription has been cancelled. You can create a new subscription request if needed.
                        <?php elseif($existingSubscription->status == 'expired'): ?>
                            Your previous subscription has expired. You can create a new subscription request if needed.
                        <?php else: ?>
                            Your current subscription status does not allow creating a new subscription at this time.
                        <?php endif; ?>
                    </p>
                    <?php if($existingSubscription->status != 'pending'): ?>
                        <p class="text-muted">You can create a new subscription request below.</p>
                        <a href="<?php echo e(route('subscriptions.create')); ?>" class="btn btn-primary">
                            <i class="fas fa-plus"></i> Create New Subscription
                        </a>
                    <?php else: ?>
                        <p class="text-muted">
                            If you have any questions, please contact the administrator.
                        </p>
                    <?php endif; ?>
                    <br><br>
                    <a href="<?php echo e(route('dashboard')); ?>" class="btn btn-secondary">
                        <i class="fas fa-home"></i> Go to Dashboard
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/quickphone/public_html/bh.quickphone.us/pos/resources/views/admin/subscriptions/pending.blade.php ENDPATH**/ ?>