<!-- Laser Print Layout -->
<div class="invoice-container laser-printer">
    <style>
        .laser-printer {
            font-family: Arial, sans-serif;
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
        }
        .laser-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 30px;
            padding-bottom: 15px;
            border-bottom: 2px solid #333;
        }
        .company-details h3 {
            margin: 0 0 10px 0;
            color: #333;
            font-size: 20px;
        }
        .company-details p {
            margin: 3px 0;
            color: #666;
            font-size: 12px;
        }
        .invoice-info {
            text-align: right;
        }
        .invoice-info h4 {
            margin: 0 0 10px 0;
            color: #333;
        }
        .customer-section {
            margin: 20px 0;
            padding: 15px;
            background-color: #f9f9f9;
            border-radius: 5px;
        }
        .laser-printer table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }
        .laser-printer th, .laser-printer td {
            padding: 10px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }
        .laser-printer th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        .total-section {
            text-align: right;
            margin-top: 20px;
            padding-top: 15px;
            border-top: 2px solid #333;
        }
        .total-amount {
            font-size: 18px;
            font-weight: bold;
            color: #333;
        }
    </style>

    <!-- Header with Company Information -->
    <div class="laser-header">
        <div class="company-details">
            <?php if(isset($all_settings) && $all_settings): ?>
                <h3><?php echo e($all_settings->company_name ?? 'Your Company, Inc.'); ?></h3>
                <?php if($all_settings->address): ?>
                    <p><strong>Address:</strong> <?php echo e($all_settings->address); ?></p>
                <?php endif; ?>
                <?php if($all_settings->number): ?>
                    <p><strong>Phone:</strong> <?php echo e($all_settings->number); ?></p>
                <?php endif; ?>
                <?php if($all_settings->company_email): ?>
                    <p><strong>Email:</strong> <?php echo e($all_settings->company_email); ?></p>
                <?php endif; ?>
                <?php if($all_settings->website): ?>
                    <p><strong>Website:</strong> <?php echo e($all_settings->website); ?></p>
                <?php endif; ?>
                <?php if($all_settings->company_registration_number): ?>
                    <p><strong>Registration:</strong> <?php echo e($all_settings->company_registration_number); ?></p>
                <?php endif; ?>
            <?php else: ?>
                <h3>Your Company, Inc.</h3>
                <p>Company Address</p>
                <p>Phone & Email</p>
            <?php endif; ?>
        </div>
        <div class="invoice-info">
            <h4>INVOICE</h4>
            <p><strong>Invoice #:</strong> <?php echo e($sale->id ?? 'INV-001'); ?></p>
            <p><strong>Date:</strong> <?php echo e(\Carbon\Carbon::parse($sale->sale_date ?? now())->format('M d, Y')); ?></p>
            <p><strong>Time:</strong> <?php echo e(\Carbon\Carbon::parse($sale->sale_date ?? now())->format('h:i A')); ?></p>
        </div>
    </div>

    <!-- Customer Information -->
    <div class="customer-section">
        <h4>Bill To:</h4>
        <p><strong><?php echo e($sale->customer_name ?? 'Walk-in Customer'); ?></strong></p>
        <?php if(isset($sale->customer)): ?>
            <?php if($sale->customer->phone): ?>
                <p>Phone: <?php echo e($sale->customer->phone); ?></p>
            <?php endif; ?>
            <?php if($sale->customer->email): ?>
                <p>Email: <?php echo e($sale->customer->email); ?></p>
            <?php endif; ?>
            <?php if($sale->customer->address): ?>
                <p>Address: <?php echo e($sale->customer->address); ?></p>
            <?php endif; ?>
        <?php endif; ?>
    </div>

    <!-- Items Table -->
    <table>
        <thead>
            <tr>
                <th>Description</th>
                <th>Unit Price</th>
                <th>Quantity</th>
                <th>Total</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td><?php echo e($sale->product->brand ?? 'Product'); ?> - <?php echo e($sale->product->type ?? 'Item'); ?></td>
                <td><?php echo e(($all_settings->currency ?? env('APP_CURRENCY', '$')) . number_format($sale->sell_price, 2)); ?></td>
                <td><?php echo e($sale->sold_quantity ?? 1); ?></td>
                <td><?php echo e(($all_settings->currency ?? env('APP_CURRENCY', '$')) . number_format($sale->sell_price * ($sale->sold_quantity ?? 1), 2)); ?></td>
            </tr>
        </tbody>
    </table>

    <!-- Total Section -->
    <div class="total-section">
        <p class="total-amount">
            <strong>Total Amount: <?php echo e(($all_settings->currency ?? env('APP_CURRENCY', '$')) . number_format($sale->sell_price * ($sale->sold_quantity ?? 1), 2)); ?></strong>
        </p>
    </div>

    <!-- Footer -->
    <div style="text-align: center; margin-top: 30px; font-size: 12px; color: #666;">
        <p>Thank you for your business!</p>
        <?php if(isset($all_settings) && $all_settings->website): ?>
            <p>Visit us online: <?php echo e($all_settings->website); ?></p>
        <?php endif; ?>
    </div>
</div>
<?php /**PATH /home/quickphone/public_html/bh.quickphone.us/pos/resources/views/invoice/print-laser.blade.php ENDPATH**/ ?>