<?php $__env->startSection('main'); ?>
<style>
    .card {
        box-shadow: 0 0 10px rgba(0,0,0,0.1);
        border: none;
        border-radius: 10px;
    }
    .profit-positive {
        color: #28a745;
        font-weight: bold;
    }
    .profit-negative {
        color: #dc3545;
        font-weight: bold;
    }
    .summary-card {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
    }
    .chart-container {
        position: relative;
        height: 400px;
    }
    .filter-section {
        background: #f8f9fa;
        padding: 20px;
        border-radius: 10px;
        margin-bottom: 20px;
    }
    .export-buttons {
        margin-top: 10px;
    }
    .table-responsive {
        border-radius: 10px;
        overflow: hidden;
    }
</style>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h3 class="card-title mb-0">
                        <i class="fas fa-chart-line mr-2"></i>Profit & Loss Statement
                    </h3>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters Section -->
    <div class="filter-section">
        <form method="GET" action="<?php echo e(route('report.profit.loss')); ?>" class="row g-3">
            <div class="col-md-3">
                <label for="filter_date" class="form-label">Time Period</label>
                <select name="filter_date" id="filter_date" class="form-select">
                    <option value="all" <?php echo e($data['filterDate'] == 'all' ? 'selected' : ''); ?>>All Time</option>
                    <option value="today" <?php echo e($data['filterDate'] == 'today' ? 'selected' : ''); ?>>Today</option>
                    <option value="yesterday" <?php echo e($data['filterDate'] == 'yesterday' ? 'selected' : ''); ?>>Yesterday</option>
                    <option value="last_7_days" <?php echo e($data['filterDate'] == 'last_7_days' ? 'selected' : ''); ?>>Last 7 Days</option>
                    <option value="last_30_days" <?php echo e($data['filterDate'] == 'last_30_days' ? 'selected' : ''); ?>>Last 30 Days</option>
                    <option value="last_year" <?php echo e($data['filterDate'] == 'last_year' ? 'selected' : ''); ?>>Last Year</option>
                    <option value="custom" <?php echo e($data['filterDate'] == 'custom' ? 'selected' : ''); ?>>Custom Range</option>
                </select>
            </div>
            <div class="col-md-3 custom-date-range" style="display: <?php echo e($data['filterDate'] == 'custom' ? 'block' : 'none'); ?>;">
                <label for="start_date" class="form-label">Start Date</label>
                <input type="date" name="start_date" id="start_date" class="form-control" value="<?php echo e($data['startDate']); ?>">
            </div>
            <div class="col-md-3 custom-date-range" style="display: <?php echo e($data['filterDate'] == 'custom' ? 'block' : 'none'); ?>;">
                <label for="end_date" class="form-label">End Date</label>
                <input type="date" name="end_date" id="end_date" class="form-control" value="<?php echo e($data['endDate']); ?>">
            </div>
            <div class="col-md-3">
                <label class="form-label">&nbsp;</label>
                <div>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-search"></i> Generate Report
                    </button>
                </div>
            </div>
        </form>

        <!-- Export Buttons -->
        <div class="export-buttons">
            <a href="<?php echo e(route('report.profit.loss', array_merge(request()->query(), ['export' => 'pdf']))); ?>" class="btn btn-danger">
                <i class="fas fa-file-pdf"></i> Export PDF
            </a>
            <a href="<?php echo e(route('report.profit.loss', array_merge(request()->query(), ['export' => 'excel']))); ?>" class="btn btn-success">
                <i class="fas fa-file-excel"></i> Export Excel
            </a>
        </div>
    </div>

    <!-- Summary Cards -->
    <div class="row mb-4">
        <div class="col-lg-3 col-md-6">
            <div class="card summary-card">
                <div class="card-body text-center">
                    <h5 class="card-title">Total Revenue</h5>
                    <h3 class="mb-0">BHD <?php echo e(number_format($data['totalRevenue'], 2)); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6">
            <div class="card summary-card">
                <div class="card-body text-center">
                    <h5 class="card-title">Gross Profit</h5>
                    <h3 class="mb-0 <?php echo e($data['grossProfit'] >= 0 ? 'profit-positive' : 'profit-negative'); ?>">
                        BHD <?php echo e(number_format($data['grossProfit'], 2)); ?>

                    </h3>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6">
            <div class="card summary-card">
                <div class="card-body text-center">
                    <h5 class="card-title">Total Expenses</h5>
                    <h3 class="mb-0">BHD <?php echo e(number_format($data['totalExpenses'], 2)); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6">
            <div class="card summary-card">
                <div class="card-body text-center">
                    <h5 class="card-title">Net Profit</h5>
                    <h3 class="mb-0 <?php echo e($data['netProfit'] >= 0 ? 'profit-positive' : 'profit-negative'); ?>">
                        BHD <?php echo e(number_format($data['netProfit'], 2)); ?>

                    </h3>
                </div>
            </div>
        </div>
    </div>

    <!-- Detailed P&L Statement -->
    <div class="row">
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Profit & Loss Statement</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead class="table-dark">
                                <tr>
                                    <th>Description</th>
                                    <th class="text-right">Amount (BHD)</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr class="table-primary">
                                    <td><strong>Revenue</strong></td>
                                    <td class="text-right"><strong><?php echo e(number_format($data['totalRevenue'], 2)); ?></strong></td>
                                </tr>
                                <tr>
                                    <td>&nbsp;&nbsp;&nbsp;&nbsp;Sales Revenue</td>
                                    <td class="text-right"><?php echo e(number_format($data['totalRevenue'] - $data['totalRevenueFromDirectSales'], 2)); ?></td>
                                </tr>
                                <tr>
                                    <td>&nbsp;&nbsp;&nbsp;&nbsp;Direct Sales Revenue</td>
                                    <td class="text-right"><?php echo e(number_format($data['totalRevenueFromDirectSales'], 2)); ?></td>
                                </tr>
                                <tr class="table-warning">
                                    <td><strong>Cost of Goods Sold</strong></td>
                                    <td class="text-right"><strong><?php echo e(number_format($data['totalCOGS'], 2)); ?></strong></td>
                                </tr>
                                <tr class="table-success">
                                    <td><strong>Gross Profit</strong></td>
                                    <td class="text-right <?php echo e($data['grossProfit'] >= 0 ? 'profit-positive' : 'profit-negative'); ?>">
                                        <strong><?php echo e(number_format($data['grossProfit'], 2)); ?></strong>
                                    </td>
                                </tr>
                                <tr class="table-danger">
                                    <td><strong>Operating Expenses</strong></td>
                                    <td class="text-right"><strong><?php echo e(number_format($data['totalExpenses'], 2)); ?></strong></td>
                                </tr>
                                <tr class="table-info">
                                    <td><strong>Net Profit</strong></td>
                                    <td class="text-right <?php echo e($data['netProfit'] >= 0 ? 'profit-positive' : 'profit-negative'); ?>">
                                        <strong><?php echo e(number_format($data['netProfit'], 2)); ?></strong>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Top Products -->
        <div class="col-lg-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Top Selling Products</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Product</th>
                                    <th>Sold</th>
                                    <th>Profit</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $data['topProducts']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($product->product->name ?? 'N/A'); ?></td>
                                    <td><?php echo e($product->total_sold); ?></td>
                                    <td class="profit-positive">BHD <?php echo e(number_format($product->total_profit, 2)); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="3" class="text-center">No data available</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Profit Trend Chart -->
    <div class="row mt-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Profit Trend (Last 12 Months)</h5>
                </div>
                <div class="card-body">
                    <div class="chart-container">
                        <canvas id="profitChart"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Chart.js -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
$(document).ready(function() {
    // Handle filter date change
    $('#filter_date').change(function() {
        if ($(this).val() === 'custom') {
            $('.custom-date-range').show();
        } else {
            $('.custom-date-range').hide();
        }
    });

    // Profit Trend Chart
    const ctx = document.getElementById('profitChart').getContext('2d');
    const monthlyProfits = <?php echo json_encode($data['monthlyProfits'], 15, 512) ?>;

    new Chart(ctx, {
        type: 'line',
        data: {
            labels: monthlyProfits.map(item => item.month),
            datasets: [{
                label: 'Monthly Profit (BHD)',
                data: monthlyProfits.map(item => item.profit),
                borderColor: 'rgb(75, 192, 192)',
                backgroundColor: 'rgba(75, 192, 192, 0.2)',
                tension: 0.1,
                fill: true
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return 'BHD ' + value.toFixed(2);
                        }
                    }
                }
            },
            plugins: {
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            return 'Profit: BHD ' + context.parsed.y.toFixed(2);
                        }
                    }
                }
            }
        }
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/quickphone/public_html/bh.quickphone.us/pos/resources/views/profit-report.blade.php ENDPATH**/ ?>