

    <h1>Create Sale</h1>

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <form action="<?php echo e(route('sales.store')); ?>" method="POST">
        <?php echo csrf_field(); ?>

        <!-- Customer Selection -->
        <div>
            <label for="customer_id">Customer:</label>
            <select name="customer_id" id="customer_id" required>
                <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($customer->id); ?>"><?php echo e($customer->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <!-- Product Selection -->
        <div>
            <label for="products">Products:</label>
            <div id="product-list">
                <select name="products[0][id]" required>
                    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($product->id); ?>"><?php echo e($product->name); ?> - $<?php echo e($product->buy_price); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <input type="number" name="products[0][quantity]" placeholder="Quantity" required>
                <input type="number" name="products[0][price]" placeholder="Price" required>
            </div>
        </div>

        <!-- Payment Method -->
        <div>
            <label for="payment_method">Payment Method:</label>
            <select name="payment_method" id="payment_method" required>
                <option value="cash">Cash</option>
                <option value="credit">Credit</option>
            </select>
        </div>

        <button type="submit">Complete Sale</button>
    </form>

<?php /**PATH /home/quickphone/public_html/bh.quickphone.us/pos/resources/views/sales/create.blade.php ENDPATH**/ ?>