
<?php $__env->startPush('style'); ?>
    <style>
        .product-box {
            border: 1px solid #ddd;
            padding: 20px;
            margin: 10px 0;
            border-radius: 8px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
            background-color: #f9f9f9;
        }

        .product-box .title:hover {
            background-color: #45a049;
            transform: translateY(-5px);
            box-shadow: 0 6px 15px rgba(0, 0, 0, 0.3);
        }

        .product-box .title {
            font-size: 1.1em;
            font-weight: bold;
            color: #fff;
            background-color: #4CAF50;
            padding: 12px 20px;
            border-radius: 8px;
            margin-bottom: 10px;
            text-align: center;
            text-transform: uppercase;
            letter-spacing: 1px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
            transition: all 0.3s ease-in-out;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('main'); ?>
    
    <!-- Content Header (Page header) -->
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0 text-dark">POINT OF SALE</h1>
                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item active">Dashboard v2</li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->

    <div class="modal fade" id="show_profit_modal" tabindex="-1" role="dialog" aria-labelledby="show_profit_modal_label"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="show_profit_modal_label">আজকের প্রফিট রিপোর্ট</h4>
                </div>

                <div class="modal-body">
                    <div class="popup-content">
                        <!-- Dynamic profit data -->
                        <h3>মোট প্রফিট: <span id="profitValue">0.00 ৳</span></h3>
                        <p id="profitDetails">তারিখ: <span id="date"></span></p>

                        <!-- Close Button -->
                        <button type="button" class="btn btn-block btn-outline-danger btn-sm"
                            id="close_modal_btn">Close</button>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- Main content -->
    <section class="content">
        <div class="row">


            <!-- fix for small devices only -->
            <div class="clearfix hidden-md-up"></div>

            <div class="col-12 col-sm-6 col-md-3">
                <div class="info-box mb-3">
                    <span class="info-box-icon bg-success elevation-1">
                        <i class="fas fa-hand-holding-usd"></i> <!-- Direct sale icon -->
                    </span>

                    <div class="info-box-content">
                        <a href="<?php echo e(route('direct-sales.create')); ?>" class="btn btn-primary">Direct Sale</a>
                    </div>
                    <!-- /.info-box-content -->
                </div>
                <!-- /.info-box -->
            </div>
            <!-- /.col -->


            <div class="col-12 col-sm-6 col-md-3">
                <div class="info-box mb-3">
                    <span class="info-box-icon bg-warning elevation-1">
                        <i class="fas fa-money-bill-wave"></i> <!-- Money bill icon for profit -->
                    </span>

                    <div class="info-box-content">
                        <button type="button" onclick="fetchProfit()" class="btn btn-info" id="openProfitModal">
                            <i class="fas fa-money-bill-wave"></i> Total Profit
                        </button>
                    </div>
                    <!-- /.info-box-content -->
                </div>
                <!-- /.info-box -->
            </div>
            <!-- /.col -->
        </div>


        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">

                        <div class="search-container">
                            <form class="search-form">
                                <div class="row">
                                    <div class="col-4">
                                        <div>
                                            <label for="search_type">Search by:</label>
                                            <select id="search_type" name="search_type" class="form-control">
                                                <option value="all">All</option>
                                                <option value="model">Model</option>
                                                <option value="brand">Brand</option>
                                                <option value="imei">IMEI/SN</option>
                                            </select>
                                        </div>


                                    </div>
                                    <div class="col-4">

                                        <label for="search_value">Search Value:</label>
                                        <input type="text" id="search_value" class="form-control" name="search_value"
                                            placeholder="Type to search...">

                                    </div>
                                </div>
                            </form>
                        </div>

                        <div id="search_results">
                            <h2>Product List</h2>
                            <div id="product_grid" class="product-container row text-center">
                                <!-- Products will be loaded here -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        $(document).ready(function() {
            function fetchProducts() {
                let searchType = $('#search_type').val();
                let searchValue = $('#search_value').val();

                $.ajax({
                    url: "<?php echo e(route('products.fetch')); ?>",
                    method: "GET",
                    data: {
                        search_type: searchType,
                        search_value: searchValue
                    },
                    success: function(response) {
                        let productGrid = $('#product_grid');
                        productGrid.html('');

                        if (response.length > 0) {
                            response.forEach(product => {
                                let conditionColor = product.condition === 'new' ? 'red' :
                                    'green';

                                let productHtml = `
                            <div class="col-3">
                                <div class=" product-box">
                                    <div class="">
                                        <div type="button" style="padding:0.2px" class="bg-gradient-success rounded title">
                                            <h3 class="">
                                                <span class="brand">Apple</span><br>
                                            </h3>
                                            <p class="">
                                                <span class="model"><b>iPhone 3G</b></span>
                                            </p>
                                        </div>
                                        <div class="mt-2">
                                            <p>${product.gb} - ${product.color}</p>
                                            <p><b>IMEI/SN:</b> ${product.imei_or_sn}</p>
                                            <p><b>Condition:</b> <span style="color:${conditionColor};">${product.condition}</span></p>
                                            <p><b>Buy Price:</b> <?php echo e($all_settings->currency); ?> ${parseFloat(product.buy_price +<?php echo e($all_settings->pos_price_value); ?>).toFixed(2)}</p>
                                            <p><b>Stock:</b> ${product.stock}</p>
                                        </div>
                                        <div class="btn_sell d-flex justify-content-center">
                                            <a href="sell/${product.id}" class="btn btn-block bg-gradient-primary btn-sm" style="width:30%">Sell</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        `;

                                productGrid.append(productHtml);
                            });
                        } else {
                            productGrid.html(
                                '<p style="text-align:center; color:red;">No products found.</p>');
                        }
                    }
                });
            }

            // Function to enable/disable input field based on selection
            function toggleSearchInput() {
                let searchType = $('#search_type').val();
                if (searchType === 'all') {
                    $('#search_value').val('').prop('disabled', true); // Clear and disable input
                } else {
                    $('#search_value').prop('disabled', false); // Enable input
                }
            }

            // Load all products initially
            fetchProducts();

            // Fetch products when typing in the search field
            $('#search_value').on('keyup', function() {
                fetchProducts();
            });

            // Fetch products when selecting a search type and toggle input field
            $('#search_type').on('change', function() {
                toggleSearchInput();
                fetchProducts();
            });

            // Initialize input state on page load
            toggleSearchInput();
        });



        // Function: Fetch today's profit
        function fetchProfit() {
            $.ajax({
                url: "<?php echo e(route('pos.fetch.profit')); ?>", // The route URL
                type: 'POST',
                dataType: 'json',
                data: {
                    action: 'fetchProfit',
                    _token: '<?php echo e(csrf_token()); ?>' // CSRF token
                },
                success: function(response) {
                    console.log("Profit data fetched successfully");

                    // Show modal
                    $('#show_profit_modal').modal('show');

                    // You can now handle the profit data here and update modal content accordingly
                    if (response.success) {
                        // Update the modal content with the profit data (example)
                        $('#show_profit_modal .modal-title').text('Today\'s Profit: ' + response.total_profit +
                            ' ৳');
                        // You can use more modal body elements here to display specific data if needed
                    }
                },
                error: function(xhr, status, error) {
                    console.error("Error: " + error);
                }
            });
        }

        // Handle the close button click
        $('#close_modal_btn').click(function() {
            $('#show_profit_modal').modal('hide');
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/quickphone/public_html/bh.quickphone.us/pos/resources/views/pos/indexr.blade.php ENDPATH**/ ?>