

<?php $__env->startSection('main'); ?>
<div class="container-fluid p-4">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4>Customer Credits</h4>
                    <?php
                        $totalCredit = $customers->sum('total_due');
                    ?>
                    <div class="float-end">
                        <strong>Total Outstanding Credit: BHD <?php echo e(number_format($totalCredit, 2)); ?></strong>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Name</th>
                                    <th>Phone</th>
                                    <th>CPR</th>
                                    <th>Address</th>
                                    <th>Total Due (BHD)</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($customer->id); ?></td>
                                    <td><?php echo e($customer->name); ?></td>
                                    <td><?php echo e($customer->number); ?></td>
                                    <td><?php echo e($customer->cpr); ?></td>
                                    <td><?php echo e($customer->address); ?></td>
                                    <td><?php echo e(number_format($customer->total_due, 2)); ?></td>
                                    <td>
                                        <button class="btn btn-sm btn-secondary" type="button" data-bs-toggle="collapse" data-bs-target="#details-<?php echo e($customer->id); ?>" aria-expanded="false" aria-controls="details-<?php echo e($customer->id); ?>">
                                            Show Dependencies
                                        </button>
                                        <a href="<?php echo e(route('customer.show', $customer->id)); ?>" class="btn btn-sm btn-info">View Details</a>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="7" class="p-0">
                                        <div class="collapse" id="details-<?php echo e($customer->id); ?>">
                                            <div class="card card-body m-2">
                                                <h6>Dependencies for <?php echo e($customer->name); ?></h6>
                                                <?php if($customer->sales->count() > 0): ?>
                                                <table class="table table-sm table-bordered">
                                                    <thead>
                                                        <tr>
                                                            <th>Date</th>
                                                            <th>Total Amount (BHD)</th>
                                                            <th>Due Amount (BHD)</th>
                                                            <th>Status</th>
                                                            <th>Type</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php $__currentLoopData = $customer->sales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <tr>
                                                            <td><?php echo e($sale->created_at->format('Y-m-d H:i')); ?></td>
                                                            <td><?php echo e(number_format($sale->total_amount, 2)); ?></td>
                                                            <td>
                                                                <?php
                                                                    $dueAmount = $sale->due_amount;
                                                                    $duePayments = \App\Models\CustomerPayment::where('customer_id', $customer->id)
                                                                        ->where('type', 'due_payment')
                                                                        ->whereJsonContains('sale_ids', $sale->id)
                                                                        ->sum('amount');
                                                                    $netDue = $dueAmount - $duePayments;
                                                                ?>
                                                                <?php echo e(number_format(max(0, $netDue), 2)); ?>

                                                            </td>
                                                            <td><?php echo e(ucfirst($sale->payment_status)); ?></td>
                                                            <td>
                                                                <?php if($netDue < 0): ?>
                                                                    <span class="badge bg-success">Advance Payment</span>
                                                                <?php elseif($sale->payment_status == 'unpaid'): ?>
                                                                    <span class="badge bg-danger">Unpaid</span>
                                                                <?php elseif($sale->payment_status == 'partial'): ?>
                                                                    <span class="badge bg-warning">Partial Payment</span>
                                                                <?php else: ?>
                                                                    <span class="badge bg-info"><?php echo e(ucfirst($sale->payment_status)); ?></span>
                                                                <?php endif; ?>
                                                            </td>
                                                        </tr>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </tbody>
                                                </table>
                                                <?php else: ?>
                                                <p>No dependencies found.</p>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/quickphone/public_html/bh.quickphone.us/pos/resources/views/customers/credits.blade.php ENDPATH**/ ?>