

<?php $__env->startSection('main'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Tenants</h3>
                    <a href="<?php echo e(route('tenants.create')); ?>" class="btn btn-primary float-right">Create Tenant</a>
                </div>
                <div class="card-body">
                    <?php if(session('success')): ?>
                        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
                    <?php endif; ?>
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Name</th>
                                <th>Domain</th>
                                <th>Subdomain</th>
                                <th>Users</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $tenants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tenant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($tenant->id); ?></td>
                                <td><?php echo e($tenant->name); ?></td>
                                <td><?php echo e($tenant->domain); ?></td>
                                <td><?php echo e($tenant->subdomain); ?></td>
                                <td><?php echo e($tenant->users->count()); ?></td>
                                <td>
                                    <a href="<?php echo e(route('tenants.show', $tenant)); ?>" class="btn btn-info btn-sm">View</a>
                                    <a href="<?php echo e(route('tenants.edit', $tenant)); ?>" class="btn btn-warning btn-sm">Edit</a>
                                    <form action="<?php echo e(route('tenants.destroy', $tenant)); ?>" method="POST" style="display:inline;">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')">Delete</button>
                                    </form>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/quickphone/public_html/bh.quickphone.us/pos/resources/views/admin/tenants/index.blade.php ENDPATH**/ ?>