

<?php $__env->startSection('main'); ?>
    <div class="container">
        <h2>Edit Direct Sale</h2>
        <form method="POST" action="<?php echo e(route('direct-sales.update', $sale->id)); ?>">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>
            <div class="form-group">
                <label for="gb">Product Type:</label>
                <select id="product_type" class="form-control" name="product_type" required="">
                    <option value="Accessories" <?php echo e($sale->product_type == 'Accessories' ? 'selected' : ''); ?>>Accessories
                    </option>
                    <option value="Repair" <?php echo e($sale->product_type == 'Repair' ? 'selected' : ''); ?>>Repair</option>
                    <option value="Others" <?php echo e($sale->product_type == 'Others' ? 'selected' : ''); ?>>Others</option>
                </select>
            </div>

            <div class="form-group">
                <label for="sell_price">Sell Price</label>
                <input type="number" class="form-control" name="sell_price"
                    value="<?php echo e(old('sell_price', $sale->direct_sell_price)); ?>" required>
            </div>

            <div class="form-group">
                <label for="cost_price">Cost Price</label>
                <input type="number" class="form-control" name="cost_price"
                    value="<?php echo e(old('cost_price', $sale->direct_cost_price)); ?>" required>
            </div>

            <div class="form-group">
                <label for="profit">Profit</label>
                <input type="number" class="form-control" name="profit" value="<?php echo e(old('profit', $sale->direct_profit)); ?>"
                    required>
            </div>

            <div class="form-group">
                <label for="purchase_note">Purchase Note</label>
                <input type="text" class="form-control" name="purchase_note"
                    value="<?php echo e(old('purchase_note', $sale->purchase_note)); ?>" required>
            </div>

            <div class="form-group">
                <label for="customer_name">Customer Name</label>
                
                <select id="customer_name" class="form-control" name="customer_name" required="">
                    <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($customer->id); ?>"
                            <?php echo e($sale->direct_customer_name == $customer->id ? 'selected' : ''); ?>>
                            <?php echo e($customer->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="form-group">
                <label for="sold_quantity">Sold Quantity</label>
                <input type="number" class="form-control" name="sold_quantity"
                    value="<?php echo e(old('sold_quantity', $sale->direct_sold_quantity)); ?>" required>
            </div>

            <div class="form-group">
                <label for="date_time">Date & Time</label>
                <input type="datetime-local" class="form-control" name="date_time"
                    value="<?php echo e(old('date_time', \Carbon\Carbon::parse($sale->direct_date_time)->format('Y-m-d\TH:i'))); ?>"
                    required>
            </div>

            <button type="submit" class="btn btn-primary">Update Sale</button>
        </form>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/quickphone/public_html/bh.quickphone.us/pos/resources/views/direct_sell/edit.blade.php ENDPATH**/ ?>