

<?php $__env->startSection('title', 'Invoice Preview'); ?>

<?php $__env->startPush('style'); ?>
<style>
    .invoice-preview {
        background: white;
        box-shadow: 0 0 20px rgba(0,0,0,0.1);
        border-radius: 8px;
        max-width: 800px;
        margin: 0 auto;
    }
    
    .invoice-default {
        font-family: 'Arial', sans-serif;
        padding: 30px;
    }
    
    .invoice-modern {
        font-family: 'Segoe UI', sans-serif;
        padding: 40px;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
    }
    
    .invoice-classic {
        font-family: 'Times New Roman', serif;
        padding: 35px;
        border: 3px solid #333;
    }
    
    .invoice-minimal {
        font-family: 'Helvetica', sans-serif;
        padding: 20px;
        border-left: 5px solid #007bff;
    }
    
    .invoice-header {
        border-bottom: 2px solid #eee;
        padding-bottom: 20px;
        margin-bottom: 30px;
    }
    
    .invoice-modern .invoice-header {
        border-bottom: 2px solid rgba(255,255,255,0.3);
    }
    
    .invoice-classic .invoice-header {
        border-bottom: 2px solid #333;
    }
    
    .invoice-minimal .invoice-header {
        border-bottom: 1px solid #dee2e6;
    }
    
    .company-logo {
        width: 120px;
        height: 80px;
        background: #f8f9fa;
        border: 2px dashed #dee2e6;
        display: flex;
        align-items: center;
        justify-content: center;
        color: #6c757d;
        font-size: 12px;
        text-align: center;
    }
    
    .invoice-title {
        font-size: 36px;
        font-weight: bold;
        margin: 0;
    }
    
    .invoice-modern .invoice-title {
        color: white;
        text-shadow: 2px 2px 4px rgba(0,0,0,0.3);
    }
    
    .invoice-details {
        background: #f8f9fa;
        padding: 15px;
        border-radius: 5px;
        margin: 20px 0;
    }
    
    .invoice-modern .invoice-details {
        background: rgba(255,255,255,0.1);
    }
    
    .invoice-classic .invoice-details {
        background: #fff;
        border: 1px solid #333;
    }
    
    .invoice-minimal .invoice-details {
        background: #f8f9fa;
        border-left: 3px solid #007bff;
    }
    
    .items-table {
        width: 100%;
        border-collapse: collapse;
        margin: 20px 0;
    }
    
    .items-table th,
    .items-table td {
        padding: 12px;
        text-align: left;
        border-bottom: 1px solid #dee2e6;
    }
    
    .items-table th {
        background: #f8f9fa;
        font-weight: bold;
    }
    
    .invoice-modern .items-table th {
        background: rgba(255,255,255,0.1);
        color: white;
    }
    
    .invoice-modern .items-table td {
        border-bottom: 1px solid rgba(255,255,255,0.2);
    }
    
    .invoice-classic .items-table th {
        background: #fff;
        border: 1px solid #333;
    }
    
    .invoice-classic .items-table td {
        border: 1px solid #333;
    }
    
    .total-section {
        margin-top: 30px;
        text-align: right;
    }
    
    .total-row {
        margin: 5px 0;
        padding: 5px 0;
    }
    
    .grand-total {
        font-size: 20px;
        font-weight: bold;
        padding: 10px 0;
        border-top: 2px solid #333;
    }
    
    .invoice-modern .grand-total {
        border-top: 2px solid rgba(255,255,255,0.5);
    }
    
    .qr-code {
        width: 100px;
        height: 100px;
        background: #f8f9fa;
        border: 2px dashed #dee2e6;
        display: flex;
        align-items: center;
        justify-content: center;
        color: #6c757d;
        font-size: 12px;
        text-align: center;
        margin: 20px auto;
    }
    
    .terms-section {
        margin-top: 40px;
        padding-top: 20px;
        border-top: 1px solid #dee2e6;
        font-size: 12px;
        color: #6c757d;
    }
    
    .invoice-modern .terms-section {
        border-top: 1px solid rgba(255,255,255,0.3);
        color: rgba(255,255,255,0.8);
    }
    
    .invoice-classic .terms-section {
        border-top: 1px solid #333;
        color: #333;
    }
    
    .print-btn {
        position: fixed;
        top: 20px;
        right: 20px;
        z-index: 1000;
    }
    
    @media print {
        .print-btn, .no-print {
            display: none !important;
        }
        .invoice-preview {
            box-shadow: none;
        }
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('main'); ?>
<div class="content-header no-print">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Invoice Preview - <?php echo e(ucfirst($template)); ?> Template</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Home</a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(route('invoice-settings.index')); ?>">Invoice Settings</a></li>
                    <li class="breadcrumb-item active">Preview</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<button class="btn btn-primary print-btn no-print" onclick="window.print()">
    <i class="fas fa-print mr-2"></i>Print Preview
</button>

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card no-print mb-3">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <label for="templateSelect">Select Template:</label>
                                <select class="form-control" id="templateSelect" onchange="changeTemplate()">
                                    <option value="default" <?php echo e($template == 'default' ? 'selected' : ''); ?>>Default</option>
                                    <option value="modern" <?php echo e($template == 'modern' ? 'selected' : ''); ?>>Modern</option>
                                    <option value="classic" <?php echo e($template == 'classic' ? 'selected' : ''); ?>>Classic</option>
                                    <option value="minimal" <?php echo e($template == 'minimal' ? 'selected' : ''); ?>>Minimal</option>
                                </select>
                            </div>
                            <div class="col-md-6 d-flex align-items-end">
                                <a href="<?php echo e(route('invoice-settings.index')); ?>" class="btn btn-secondary mr-2">
                                    <i class="fas fa-arrow-left mr-2"></i>Back to Settings
                                </a>
                                <button class="btn btn-primary" onclick="window.print()">
                                    <i class="fas fa-print mr-2"></i>Print
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="invoice-preview">
                    <div class="invoice-<?php echo e($template); ?>">
                        <!-- Invoice Header -->
                        <div class="invoice-header">
                            <div class="row">
                                <div class="col-6">
                                    <?php if($settings->include_company_logo ?? true): ?>
                                    <div class="company-logo">
                                        Company<br>Logo
                                    </div>
                                    <?php endif; ?>
                                    <h3 class="mt-3"><?php echo e($settings->company_name ?? 'Your Company Name'); ?></h3>
                                    <p class="mb-0">123 Business Street<br>
                                    Dhaka, Bangladesh<br>
                                    Phone: +880 1712-345678<br>
                                    Email: info@company.com</p>
                                </div>
                                <div class="col-6 text-right">
                                    <h1 class="invoice-title"><?php echo e($settings->invoice_header_text ?? 'INVOICE'); ?></h1>
                                    <div class="invoice-details mt-3">
                                        <strong>Invoice #:</strong> INV-2025-001<br>
                                        <strong>Date:</strong> <?php echo e(date('M d, Y')); ?><br>
                                        <strong>Due Date:</strong> <?php echo e(date('M d, Y', strtotime('+30 days'))); ?>

                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Bill To Section -->
                        <div class="row">
                            <div class="col-6">
                                <h5>Bill To:</h5>
                                <div class="invoice-details">
                                    <strong>John Doe</strong><br>
                                    456 Customer Avenue<br>
                                    Dhaka, Bangladesh<br>
                                    Phone: +880 1798-765432<br>
                                    Email: john.doe@email.com
                                </div>
                            </div>
                            <div class="col-6">
                                <h5>Payment Method:</h5>
                                <div class="invoice-details">
                                    <strong>Cash Payment</strong><br>
                                    Status: <span style="color: #28a745; font-weight: bold;">Paid</span>
                                </div>
                            </div>
                        </div>

                        <!-- Items Table -->
                        <table class="items-table">
                            <thead>
                                <tr>
                                    <th>Item Description</th>
                                    <th>Qty</th>
                                    <th>Unit Price</th>
                                    <th>Total</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>iPhone 15 Pro Max 256GB - Natural Titanium</td>
                                    <td>1</td>
                                    <td>BDT 140,000.00</td>
                                    <td>BDT 140,000.00</td>
                                </tr>
                                <tr>
                                    <td>Samsung Galaxy S24 Ultra 512GB - Titanium Black</td>
                                    <td>2</td>
                                    <td>BDT 95,000.00</td>
                                    <td>BDT 190,000.00</td>
                                </tr>
                                <tr>
                                    <td>Wireless Charger - Fast Charging</td>
                                    <td>3</td>
                                    <td>BDT 2,500.00</td>
                                    <td>BDT 7,500.00</td>
                                </tr>
                            </tbody>
                        </table>

                        <!-- Total Section -->
                        <div class="total-section">
                            <div class="row">
                                <div class="col-6">
                                    <?php if($settings->include_qr_code ?? false): ?>
                                    <div class="qr-code">
                                        QR Code<br>
                                        (Verification)
                                    </div>
                                    <?php endif; ?>
                                </div>
                                <div class="col-6">
                                    <div class="total-row">
                                        <strong>Subtotal: BDT 337,500.00</strong>
                                    </div>
                                    <div class="total-row">
                                        <strong>Tax (0%): BDT 0.00</strong>
                                    </div>
                                    <div class="total-row">
                                        <strong>Discount: BDT 0.00</strong>
                                    </div>
                                    <div class="grand-total">
                                        <strong>Grand Total: BDT 337,500.00</strong>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Footer -->
                        <?php if($settings->invoice_footer_text): ?>
                        <div class="text-center mt-4">
                            <p><em><?php echo e($settings->invoice_footer_text); ?></em></p>
                        </div>
                        <?php endif; ?>

                        <!-- Terms & Conditions -->
                        <?php if($settings->invoice_terms_conditions): ?>
                        <div class="terms-section">
                            <h6><strong>Terms & Conditions:</strong></h6>
                            <p style="white-space: pre-line;"><?php echo e($settings->invoice_terms_conditions); ?></p>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function changeTemplate() {
    const template = document.getElementById('templateSelect').value;
    const currentUrl = new URL(window.location);
    currentUrl.searchParams.set('template', template);
    window.location = currentUrl.toString();
}
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/quickphone/public_html/bh.quickphone.us/pos/resources/views/invoice-settings/preview.blade.php ENDPATH**/ ?>