<?php $__env->startSection('main'); ?>

<!-- Include DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.21/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css">

<div class="container-fluid">
    <h1 class="mt-5">Merged Report</h1>

    <!-- resources/views/report/netprofit.blade.php -->
    <div class="row">
        <div class="col-lg-3 col-md-6 col-12">
            <!-- small box for Total Sales -->
            <div class="small-box bg-info">
                <div class="inner">
                    <h3><?php echo e(number_format($totalSales + ($totalDirectSales ?? 0), 2)); ?></h3>
                    <p>Total Sales</p>
                </div>
                <div class="icon">
                    <i class="ion ion-bag"></i>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6 col-12">
            <!-- small box for Complete Profit -->
            <div class="small-box bg-success">
                <div class="inner">
                    <h3><?php echo e(number_format($totalProfit + ($totalDirectProfit ?? 0), 2)); ?></h3>
                    <p>Complete Profit</p>
                </div>
                <div class="icon">
                    <i class="ion ion-stats-bars"></i>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6 col-12">
            <!-- small box for Total Expenses -->
            <div class="small-box bg-warning">
                <div class="inner">
                    <h3><?php echo e(number_format($totalExpenses, 2)); ?></h3>
                    <p>Total Expenses</p>
                </div>
                <div class="icon">
                    <i class="ion ion-pie-graph"></i>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6 col-12">
            <!-- small box for Main Profit -->
            <div class="small-box bg-danger">
                <div class="inner">
                    <h3><?php echo e(number_format($mainProfit, 2)); ?></h3>
                    <p>Main Profit</p>
                </div>
                <div class="icon">
                    <i class="ion ion-cash"></i>
                </div>
            </div>
        </div>
    </div>

    <div class="container-fluid">
        <!-- Date Range Picker -->
        <div class="row mb-3">
            <div class="col-md-6">
                <div class="form-group">
                    <label>Date Range:</label>
                    <div class="input-group">
                        <button type="button" class="btn btn-default float-right" id="daterange-btn">
                            <i class="far fa-calendar-alt"></i> <span>Select Date Range</span>
                            <i class="fas fa-caret-down"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <table id="reportTable" class="table table-striped table-bordered mt-3">
        <thead>
            <tr>
                <th>Date</th>
                <th>Total Sales</th>
                <th>Total Profit</th>
                <th>Total Direct Sales</th>
                <th>Total Direct Profit</th>
                <th>Total Expenses</th>
                <th>Main Profit</th>
            </tr>
        </thead>
        <tbody>
            <?php
                // Initialize variables to calculate totals
                $totalSalesSum = 0;
                $totalProfitSum = 0;
                $totalDirectSalesSum = 0;
                $totalDirectProfitSum = 0;
                $totalExpensesSum = 0;
                $mainProfitSum = 0;
            ?>

            <?php $__currentLoopData = $reportData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($data['date']); ?></td>
                    <td><?php echo e(number_format($data['total_sales'], 2)); ?></td>
                    <td><?php echo e(number_format($data['total_profit'], 2)); ?></td>
                    <td><?php echo e(number_format($data['total_direct_sales'], 2)); ?></td>
                    <td><?php echo e(number_format($data['total_direct_profit'], 2)); ?></td>
                    <td><?php echo e(number_format($data['total_expenses'], 2)); ?></td>
                    <td><?php echo e(number_format($data['total_profit'] + $data['total_direct_profit'] - $data['total_expenses'], 2)); ?></td>
                </tr>

                <?php
                    // Add up the totals
                    $totalSalesSum += $data['total_sales'];
                    $totalProfitSum += $data['total_profit'];
                    $totalDirectSalesSum += $data['total_direct_sales'];
                    $totalDirectProfitSum += $data['total_direct_profit'];
                    $totalExpensesSum += $data['total_expenses'];
                    $mainProfitSum += $data['total_profit'] + $data['total_direct_profit'] - $data['total_expenses'];
                ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
        <tfoot>
            <tr>
                <th style="background-color: #f8f9fa;">Total</th>
                <th style="background-color: #d1ecf1;"><?php echo e(number_format($totalSalesSum, 2)); ?></th>
                <th style="background-color: #d4edda;"><?php echo e(number_format($totalProfitSum, 2)); ?></th>
                <th style="background-color: #fff3cd;"><?php echo e(number_format($totalDirectSalesSum, 2)); ?></th>
                <th style="background-color: #f8d7da;"><?php echo e(number_format($totalDirectProfitSum, 2)); ?></th>
                <th style="background-color: #f8f9fa;"><?php echo e(number_format($totalExpensesSum, 2)); ?></th>
                <th style="background-color:rgb(255, 210, 204);"><?php echo e(number_format($mainProfitSum, 2)); ?></th>
            </tr>
        </tfoot>
    </table>

    <!-- Include jQuery and DataTables JS -->
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>

    <script>
        $(document).ready(function() {
            $('#reportTable').DataTable({
                "paging": true,
                "lengthChange": true,
                "searching": true,
                "ordering": true,
                "info": true,
                "autoWidth": false,
                "responsive": true,
            });
        });
    </script>


    <!-- resources/views/report/netprofit.blade.php -->
    <div class="row">
        <!-- Your existing small boxes here -->
    </div>

    <table id="reportTable" class="table table-striped table-bordered mt-3">
        <!-- Your existing table code here -->
    </table>
</div>

<!-- Include jQuery and DataTables JS -->
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>

<!-- Include AdminLTE 3 Date Range Picker CSS -->
<link rel="stylesheet" href="<?php echo e(asset('adminlte/plugins/daterangepicker/daterangepicker.css')); ?>">



    <!-- resources/views/report/netprofit.blade.php -->
    <div class="row">
        <!-- Your existing small boxes here -->
    </div>

    <table id="reportTable" class="table table-striped table-bordered mt-3">
        <!-- Your existing table code here -->
    </table>
</div>

<!-- Include jQuery and DataTables JS -->
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>

<!-- Include AdminLTE 3 Date Range Picker JS -->
<script src="<?php echo e(asset('adminlte/plugins/moment/moment.min.js')); ?>"></script>
<script src="<?php echo e(asset('adminlte/plugins/daterangepicker/daterangepicker.js')); ?>"></script>

<script>
    $(document).ready(function() {
        // Initialize DataTable
        var table = $('#reportTable').DataTable({
            "paging": true,
            "lengthChange": true,
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": false,
            "responsive": true,
        });

        // Initialize Date Range Picker
        if ($.fn.daterangepicker) {
            $('#daterange-btn').daterangepicker(
                {
                    ranges: {
                        'Today': [moment(), moment()],
                        'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                        'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                        'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                        'This Month': [moment().startOf('month'), moment().endOf('month')],
                        'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                    },
                    startDate: moment().subtract(29, 'days'),
                    endDate: moment()
                },
                function(start, end) {
                    $('#daterange-btn span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));

                    // Filter DataTable based on date range
                    var startDate = start.format('YYYY-MM-DD');
                    var endDate = end.format('YYYY-MM-DD');

                    table.draw(); // Redraw the table

                    // Update totals based on filtered data
                    updateTotals(startDate, endDate);
                }
            );
        } else {
            console.error('Date Range Picker plugin is not loaded.');
        }

        // Custom DataTable filtering for date range
        $.fn.dataTable.ext.search.push(function(settings, data, dataIndex) {
            var min = $('#daterange-btn').data('daterangepicker').startDate.format('YYYY-MM-DD');
            var max = $('#daterange-btn').data('daterangepicker').endDate.format('YYYY-MM-DD');
            var date = data[0]; // Assuming the date is in the first column

            if (
                (min === null && max === null) ||
                (min === null && date <= max) ||
                (min <= date && max === null) ||
                (min <= date && date <= max)
            ) {
                return true;
            }
            return false;
        });

        // Function to update totals
        function updateTotals(startDate, endDate) {
            var totalSales = 0;
            var totalProfit = 0;
            var totalDirectSales = 0;
            var totalDirectProfit = 0;
            var totalExpenses = 0;
            var mainProfit = 0;

            table.rows({ search: 'applied' }).every(function(rowIdx, tableLoop, rowLoop) {
                var data = this.data();
                var rowDate = data[0]; // Assuming the date is in the first column

                if (rowDate >= startDate && rowDate <= endDate) {
                    totalSales += parseFloat(data[1].replace(/,/g, '')) || 0;
                    totalProfit += parseFloat(data[2].replace(/,/g, '')) || 0;
                    totalDirectSales += parseFloat(data[3].replace(/,/g, '')) || 0;
                    totalDirectProfit += parseFloat(data[4].replace(/,/g, '')) || 0;
                    totalExpenses += parseFloat(data[5].replace(/,/g, '')) || 0;
                    mainProfit += parseFloat(data[6].replace(/,/g, '')) || 0;
                }
            });

            // Update footer totals
            $('tfoot th').eq(1).text(totalSales.toFixed(2));
            $('tfoot th').eq(2).text(totalProfit.toFixed(2));
            $('tfoot th').eq(3).text(totalDirectSales.toFixed(2));
            $('tfoot th').eq(4).text(totalDirectProfit.toFixed(2));
            $('tfoot th').eq(5).text(totalExpenses.toFixed(2));
            $('tfoot th').eq(6).text(mainProfit.toFixed(2));

            // Update small boxes
            $('.small-box.bg-info .inner h3').text(totalSales.toFixed(2));
            $('.small-box.bg-success .inner h3').text((totalProfit + totalDirectProfit).toFixed(2));
            $('.small-box.bg-warning .inner h3').text(totalExpenses.toFixed(2));
            $('.small-box.bg-danger .inner h3').text(mainProfit.toFixed(2));
        }
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/quickphone/public_html/bh.quickphone.us/pos/resources/views/report/netprofit_backup.blade.php ENDPATH**/ ?>