

<?php $__env->startSection('main'); ?>
    <div class="container-fluid p-4">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4>Customer Details: <?php echo e($customer->name); ?></h4>
                        <a href="<?php echo e(route('customers.credits')); ?>" class="btn btn-secondary float-end">Back to Credits</a>
                    </div>
                    <div class="card-body">
                        <div class="row mb-4">
                            <div class="col-md-3">
                                <strong>Name:</strong> <?php echo e($customer->name); ?>

                            </div>
                            <div class="col-md-3">
                                <strong>Phone:</strong> <?php echo e($customer->number); ?>

                            </div>
                            <div class="col-md-3">
                                <strong>CPR:</strong> <?php echo e($customer->cpr ?? 'N/A'); ?>

                            </div>
                            <div class="col-md-3">
                                <strong>Address:</strong> <?php echo e($customer->address ?? 'N/A'); ?>

                            </div>
                        </div>

                        <div class="row mb-4">
                            <div class="col-md-3">
                                <div class="card bg-warning text-white">
                                    <div class="card-body">
                                        <h5>Total Credit</h5>
                                        <h3>BHD <?php echo e(number_format($totalCredit, 2)); ?></h3>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="card bg-success text-white">
                                    <div class="card-body">
                                        <h5>Total Paid</h5>
                                        <h3>BHD <?php echo e(number_format($totalPaid, 2)); ?></h3>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="card bg-danger text-white">
                                    <div class="card-body">
                                        <h5>Outstanding Due</h5>
                                        <h3>BHD <?php echo e(number_format($totalDue, 2)); ?></h3>
                                        <?php if($totalDue > 0): ?>
                                            <button class="btn btn-light mt-2"
                                                onclick="openPayDueModal(<?php echo e($customer->id); ?>, '<?php echo e($customer->name); ?>', <?php echo e($totalDue); ?>)">Pay
                                                Due</button>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="card bg-info text-white">
                                    <div class="card-body">
                                        <h5>Advance Amount</h5>
                                        <h3>BHD <?php echo e(number_format($advance, 2)); ?></h3>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <h5>Sales History</h5>
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Sale ID</th>
                                        <th>Date</th>
                                        <th>Total Amount</th>
                                        <th>Paid Amount</th>
                                        <th>Due Amount</th>
                                        <th>Exchange Amount</th>
                                        <th>Payment Status</th>
                                        <th>Payment Method</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $customer->sales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($sale->id); ?></td>
                                            <td><?php echo e($sale->created_at->format('Y-m-d')); ?></td>
                                            <td><?php echo e(number_format($sale->total_amount, 2)); ?></td>
                                            <td><?php echo e(number_format($sale->paid_amount, 2)); ?></td>
                                            <td>
                                                <?php
                                                    $dueAmount = $sale->due_amount;
                                                    $duePayments = \App\Models\CustomerPayment::where(
                                                        'customer_id',
                                                        $customer->id,
                                                    )
                                                        ->where('type', 'due_payment')
                                                        ->whereJsonContains('sale_ids', $sale->id)
                                                        ->sum('amount');
                                                    $netDue = $dueAmount - $duePayments;
                                                ?>
                                                <?php echo e(number_format(max(0, $netDue), 2)); ?>

                                            </td>
                                            <td><?php echo e($sale->exchanges->sum('price')); ?></td>
                                            <td>
                                                <span
                                                    class="badge
                                            <?php if($netDue <= 0): ?> bg-success
                                            <?php elseif($sale->payment_status == 'partial'): ?> bg-warning
                                            <?php else: ?> bg-danger <?php endif; ?>">
                                                    <?php echo e($netDue <= 0 ? 'Paid' : ucfirst($sale->payment_status)); ?>

                                                </span>
                                            </td>
                                            <td>
                                                <?php if($sale->payment_method == 'multiple'): ?>
                                                    <?php $__currentLoopData = $sale->payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php echo e(ucfirst($payment->payment_type)); ?>:
                                                        <?php echo e(number_format($payment->amount, 2)); ?><br>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php else: ?>
                                                    <?php echo e(ucfirst($sale->payment_method)); ?>

                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>

                        <h5 class="mt-4">Payment History</h5>
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Payment ID</th>
                                        <th>Date</th>
                                        <th>Type</th>
                                        <th>Amount</th>
                                        <th>Notes</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($payment->id); ?></td>
                                            <td><?php echo e($payment->created_at->format('Y-m-d')); ?></td>
                                            <td><?php echo e(ucfirst(str_replace('_', ' ', $payment->type))); ?></td>
                                            <td><?php echo e(number_format($payment->amount, 2)); ?></td>
                                            <td><?php echo e($payment->notes ?? '-'); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Pay Due Modal -->
    <div class="modal fade" id="payDueModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5>Pay Due Amount</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <p>Customer: <strong id="modalCustomerName"></strong></p>
                    <p>Outstanding Due: <strong id="modalDueAmount"></strong></p>
                    <div class="mb-3">
                        <label for="payAmount" class="form-label">Amount to Pay</label>
                        <input type="number" class="form-control" id="payAmount" min="0.01" step="0.01" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-success" onclick="payDue()">Pay</button>
                </div>
            </div>
        </div>
    </div>


    <script>
        function openPayDueModal(customerId, customerName, dueAmount) {
            document.getElementById('modalCustomerName').innerText = customerName;
            document.getElementById('modalDueAmount').innerText = dueAmount.toFixed(2);
            document.getElementById('payAmount').value = dueAmount.toFixed(2);
            document.getElementById('payAmount').max = dueAmount.toFixed(2);
            document.getElementById('payAmount').dataset.customerId = customerId;
            var payDueModal = new bootstrap.Modal(document.getElementById('payDueModal'));
            payDueModal.show();
        }

        function payDue() {
            const payAmountInput = document.getElementById('payAmount');
            const amount = parseFloat(payAmountInput.value);
            const maxAmount = parseFloat(payAmountInput.max);
            const customerId = payAmountInput.dataset.customerId;

            if (isNaN(amount) || amount <= 0) {
                showWarningModal('Error', 'Please enter a valid amount to pay.');
                return;
            }
            if (amount > maxAmount) {
                showWarningModal('Error', 'Amount cannot be greater than outstanding due.');
                return;
            }

            fetch("<?php echo e(route('customer.payDue')); ?>", {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('input[name="_token"]').value,
                    },
                    body: JSON.stringify({
                        customer_id: customerId,
                        amount: amount,
                        type: 'due_payment',
                        notes: 'Paid via Customer Due Modal',
                    }),
                })
                .then(response => response.json())
                .then(data => {
                    if (data.message) {
                        showWarningModal('Success', data.message);
                        // Close modal
                        var payDueModalEl = document.getElementById('payDueModal');
                        var modal = bootstrap.Modal.getInstance(payDueModalEl);
                        modal.hide();
                        // Reload page or update due amount dynamically
                        location.reload();
                    } else {
                        showWarningModal('Error', 'Failed to record payment.');
                    }
                })
                .catch(err => {
                    console.error('Error paying due:', err);
                    showWarningModal('Error', 'An error occurred while processing the payment.');
                });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/quickphone/public_html/bh.quickphone.us/pos/resources/views/customers/show.blade.php ENDPATH**/ ?>