
<?php $__env->startSection('main'); ?>
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <section class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Product Details</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('product.index')); ?>">Products</a></li>
                        <li class="breadcrumb-item active">Details</li>
                    </ol>
                </div>
            </div>
        </section><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Product #<?php echo e($product->id); ?></h3>
                <div class="card-tools">
                    <a href="<?php echo e(route('product.edit', $product->id)); ?>" class="btn btn-warning btn-sm">
                        <i class="fas fa-edit"></i> Edit
                    </a>
                    <a href="<?php echo e(route('product.index')); ?>" class="btn btn-secondary btn-sm">
                        <i class="fas fa-list"></i> Back to List
                    </a>
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <dl class="row">
                            <dt class="col-sm-4">ID:</dt>
                            <dd class="col-sm-8"><?php echo e($product->id); ?></dd>

                            <dt class="col-sm-4">Type:</dt>
                            <dd class="col-sm-8"><?php echo e($product->type); ?></dd>

                            <dt class="col-sm-4">Name:</dt>
                            <dd class="col-sm-8"><?php echo e($product->name); ?></dd>

                            <dt class="col-sm-4">Brand:</dt>
                            <dd class="col-sm-8"><?php echo e($product->brand ?? '-'); ?></dd>

                            <dt class="col-sm-4">Model:</dt>
                            <dd class="col-sm-8"><?php echo e($product->model ?? '-'); ?></dd>

                            <dt class="col-sm-4">IMEI/SN:</dt>
                            <dd class="col-sm-8"><?php echo e($product->imei_or_sn); ?></dd>

                            <dt class="col-sm-4">Condition:</dt>
                            <dd class="col-sm-8"><?php echo e($product->condition); ?></dd>

                            <dt class="col-sm-4">Color:</dt>
                            <dd class="col-sm-8"><?php echo e($product->color); ?></dd>

                            <dt class="col-sm-4">GB:</dt>
                            <dd class="col-sm-8"><?php echo e($product->gb); ?></dd>

                            <dt class="col-sm-4">Stock:</dt>
                            <dd class="col-sm-8"><?php echo e($product->stock); ?></dd>

                            <dt class="col-sm-4">Buy Price:</dt>
                            <dd class="col-sm-8"><?php echo e($product->buy_price); ?></dd>

                            <dt class="col-sm-4">Created At:</dt>
                            <dd class="col-sm-8"><?php echo e($product->created_at); ?></dd>

                            <dt class="col-sm-4">Updated At:</dt>
                            <dd class="col-sm-8"><?php echo e($product->updated_at); ?></dd>
                        </dl>
                    </div>
                    <div class="col-md-6">
                        <h5>Customer Information</h5>
                        <?php if($product->Customer): ?>
                            <dl class="row">
                                <dt class="col-sm-4">Name:</dt>
                                <dd class="col-sm-8"><?php echo e($product->Customer->name); ?></dd>

                                <dt class="col-sm-4">Number:</dt>
                                <dd class="col-sm-8"><?php echo e($product->Customer->number); ?></dd>

                                <dt class="col-sm-4">CPR:</dt>
                                <dd class="col-sm-8"><?php echo e($product->Customer->cpr); ?></dd>

                                <dt class="col-sm-4">Address:</dt>
                                <dd class="col-sm-8"><?php echo e($product->Customer->address); ?></dd>
                            </dl>
                        <?php else: ?>
                            <p>No customer information available.</p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/quickphone/public_html/bh.quickphone.us/pos/resources/views/product/show.blade.php ENDPATH**/ ?>