
<?php $__env->startPush('style'); ?>
    <style>
        /* Style for the search results dropdown */
        #customer_results {
            position: absolute;
            z-index: 1000;
            /* Ensure it appears above other elements */
            background-color: #fff;
            border: 1px solid #ccc;
            border-top: none;
            max-height: 200px;
            overflow-y: auto;
            width: 100%;
            /* Match the width of the input field */
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        /* Style for individual search items */
        .search-item {
            padding: 8px 12px;
            cursor: pointer;
            list-style-type: none;
            /* Remove bullet points */
        }

        .search-item:hover {
            background-color: #f8f9fa;
            /* Highlight on hover */
        }

        /* Hide the dropdown by default */
        #customer_results {
            display: none;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('main'); ?>
    
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Direct Sell</h1>
                </div>

            </div>
        </div><!-- /.container-fluid -->
        
        <?php if(session('success')): ?>
            <div class="alert alert-success">
                <?php echo e(session('success')); ?>

            </div>
            
        <?php endif; ?>

        <?php if(session('error')): ?>
            <div class="alert alert-danger">
                <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>

        
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="card card-primary">
                    <div class="card-header">
                        <h3 class="card-title">General</h3>

                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse" data-toggle="tooltip"
                                title="Collapse">
                                <i class="fas fa-minus"></i></button>
                        </div>
                    </div>
                    <form method="POST" action="<?php echo e(route('direct-sales.store')); ?>">
                        <?php echo csrf_field(); ?>
                        <!-- Customer Info -->
                        <div class="card-body">
                            <div class="row">
                                <div class="col-6">
                                    <div class="form-group">
                                        <label for="customer_search">Search Customer:</label>
                                        <input type="text" class="form-control" id="customer_search"
                                            placeholder="Search by name or mobile..." autocomplete="off">
                                        <input type="hidden" id="customer_name" name="customer_name" readonly>
                                        <div id="customer_results" class="search-results"></div>
                                        <!-- Dropdown for results -->

                                        <button type="button" data-toggle="modal" data-target="#modal-add-customer"
                                            class="btn btn-block">
                                            <i class="fas fa-plus"></i> Add New Customer
                                        </button>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="form-group">
                                        <label for="gb">Product Type:</label>
                                        <select id="product_type" class="form-control" name="product_type" required="">
                                            <option value="Accessories">Accessories</option>
                                            <option value="Repair">Repair</option>
                                            <option value="Others">Others</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-6">
                                    <div class="form-group">
                                        <label for="purchase_note">Purchase Note:</label>
                                        <input type="text" class="form-control" id="purchase_note" name="purchase_note">
                                    </div>
                                </div>

                                <div class="col-6">
                                    <div class="form-group">
                                        <label for="sell_price">Sell Price:</label>
                                        <input type="number" class="form-control" step="0.01" id="sell_price"
                                            name="sell_price" required>
                                    </div>
                                </div>

                                <div class="col-6">
                                    <div class="form-group">
                                        <label for="cost_price">Cost Price:</label>
                                        <input type="number" class="form-control" step="0.01" id="cost_price"
                                            name="cost_price" required>
                                    </div>
                                </div>

                                <div class="col-6">
                                    <div class="form-group">
                                        <label for="qty">Quantity:</label>
                                        <input type="number" class="form-control" value="1" id="qty"
                                            name="qty" required>
                                    </div>
                                </div>

                                <div class="col-12  text-center">
                                    <button type="submit" class="btn btn-block bg-gradient-primary">
                                        Submit Sale
                                    </button>
                                </div>
                            </div>
                            <div class="col-6">

                            <!-- Popup will display here after successful form submission -->
                    </form>
                </div>


            </div>
            <!-- /.card -->
        </div>

    </section>

    
    <div class="modal fade" id="modal-add-customer">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Add New Customer</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        
                    </button>
                </div>
                <form id="customer_form">
                    <?php echo csrf_field(); ?> <!-- CSRF Token -->
                    <div class="modal-body">
                        <label for="customer_name">Customer Name:</label>
                        <input type="text" id="customer_name" class="form-control" name="customer_name" required>

                        <label for="customer_number">Customer Number:</label>
                        <input type="tel" id="customer_number" class="form-control" name="customer_number" required>

                        <label for="customer_cpr">Customer CPR:</label>
                        <input type="text" id="customer_cpr" class="form-control" name="customer_cpr">

                        <label for="address">Address:</label>
                        <input type="text" id="address" class="form-control" name="address">

                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Save Customer</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        $(document).ready(function() {


            // +++++++++++++++++++++++++   ( 2 )    ++++++++++++++++++++++++++++++++++++++++
            $('#customer_form').on('submit', function(e) {
                e.preventDefault(); // Prevent default form submission

                $.ajax({
                    url: "<?php echo e(route('customer.store')); ?>",
                    type: "POST",
                    data: $(this).serialize(),
                    success: function(response, status, xhr) {
                        if (xhr.status === 201) { // HTTP 201 Created
                            $('#customer_form')[0].reset(); // Reset the form
                            $('#modal-add-customer').modal('hide'); // Hide modal
                            alert(response.message);
                        } else {
                            console.log("Unexpected response status: " + xhr.status);
                        }
                    },
                    error: function(xhr) {
                        if (xhr.status === 422) { // Validation error
                            let errors = xhr.responseJSON.errors;
                            let errorMessages = Object.values(errors).flat().join("\n");
                            alert("Validation Error:\n" + errorMessages);
                        } else if (xhr.status === 500) { // Server error
                            alert("Server Error! Please try again.");
                        } else {
                            alert("An error occurred. Status: " + xhr.status);
                        }
                        console.log(xhr.responseText);
                    }
                });
            });
            // +++++++++++++++++++++++++   ( 2 )    ++++++++++++++++++++++++++++++++++++++++


            // +++++++++++++++++++++++++   ( 1 )    ++++++++++++++++++++++++++++++++++++++++
            $("#customer_search").on("keyup", function() {
                let query = $(this).val().trim();
                if (query.length < 2) {
                    $("#customer_results").html("").hide(); // Hide if query is too short
                    return;
                }

                $.ajax({
                    url: "<?php echo e(route('api.customers.search')); ?>",
                    type: "GET",
                    data: {
                        query: query
                    },
                    success: function(response) {
                        let resultHTML = "";
                        if (response.length > 0) {
                            resultHTML += '<ul class="">';
                            $.each(response, function(index, customer) {
                                resultHTML += `<li class=" search-item" data-id="${customer.id}" data-name="${customer.name}" data-number="${customer.number}">
                            <strong>${customer.name}</strong> - ${customer.number}
                        </li>`;
                            });
                            resultHTML += '</ul>';
                        } else {
                            resultHTML =
                                '<p class="dropdown-item text-muted">No results found</p>';
                        }

                        $("#customer_results").html(resultHTML).show(); // Show results
                    }
                });
            });

            // Handle selection
            $(document).on("click", ".search-item", function() {
                let customerId = $(this).data("id");
                let customerName = $(this).data("name");
                let customerNumber = $(this).data("number");

                $("#customer_search").val(`${customerName} (${customerNumber})`);
                $("#customer_name").val(customerId); // Store customer ID
                $("#customer_results").hide(); // Hide dropdown after selection
            });

            // Hide dropdown on clicking outside
            $(document).on("click", function(e) {
                if (!$(e.target).closest("#customer_search, #customer_results").length) {
                    $("#customer_results").hide();
                }
            });
            // +++++++++++++++++++++++++   ( 1 )    ++++++++++++++++++++++++++++++++++++++++
        });
        $(document).ready(function () {
    $('#credit_sale').change(function () {
        let customerId = $('#customer_name').val();
        let creditSale = $(this).val();

        if (creditSale == '1' && customerId) {
            $.ajax({
                url: "<?php echo e(route('customer.show', ':id')); ?>".replace(':id', customerId),
                type: "GET",
                success: function (response) {
                    if (response.success) {
                        $('#credit_balance').val(response.customer.credit_balance);
                    }
                },
                error: function (xhr, status, error) {
                    alert("Error fetching customer credit balance.");
                }
            });
        }
    });
});

    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/quickphone/public_html/bh.quickphone.us/test/resources/views/direct_sell/create.blade.php ENDPATH**/ ?>