

<?php $__env->startSection('main'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Plans</h3>
                    <a href="<?php echo e(route('plans.create')); ?>" class="btn btn-primary float-right">Create Plan</a>
                </div>
                <div class="card-body">
                    <?php if(session('success')): ?>
                        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
                    <?php endif; ?>
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Name</th>
                                <th>Description</th>
                                <th>Price</th>
                                <th>Interval</th>
                                <th>Max Users</th>
                                <th>Max Products</th>
                                <th>Active</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($plan->id); ?></td>
                                <td><?php echo e($plan->name); ?></td>
                                <td><?php echo e($plan->description); ?></td>
                                <td>$<?php echo e($plan->price); ?></td>
                                <td><?php echo e($plan->interval); ?></td>
                                <td><?php echo e($plan->max_users); ?></td>
                                <td><?php echo e($plan->max_products); ?></td>
                                <td><?php echo e($plan->is_active ? 'Yes' : 'No'); ?></td>
                                <td>
                                    <a href="<?php echo e(route('plans.show', $plan)); ?>" class="btn btn-info btn-sm">View</a>
                                    <a href="<?php echo e(route('plans.edit', $plan)); ?>" class="btn btn-warning btn-sm">Edit</a>
                                    <form action="<?php echo e(route('plans.destroy', $plan)); ?>" method="POST" style="display:inline;">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')">Delete</button>
                                    </form>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/quickphone/public_html/bh.quickphone.us/test/resources/views/admin/plans/index.blade.php ENDPATH**/ ?>