

<?php $__env->startSection('main'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Edit Plan</h3>
                </div>
                <div class="card-body">
                    <form action="<?php echo e(route('plans.update', $plan)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        <div class="form-group">
                            <label for="name">Name</label>
                            <input type="text" class="form-control" id="name" name="name" value="<?php echo e($plan->name); ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="description">Description</label>
                            <textarea class="form-control" id="description" name="description"><?php echo e($plan->description); ?></textarea>
                        </div>
                        <div class="form-group">
                            <label for="price">Price</label>
                            <input type="number" step="0.01" class="form-control" id="price" name="price" value="<?php echo e($plan->price); ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="interval">Interval</label>
                            <select class="form-control" id="interval" name="interval" required>
                                <option value="month" <?php echo e($plan->interval == 'month' ? 'selected' : ''); ?>>Month</option>
                                <option value="year" <?php echo e($plan->interval == 'year' ? 'selected' : ''); ?>>Year</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="max_users">Max Users</label>
                            <input type="number" class="form-control" id="max_users" name="max_users" value="<?php echo e($plan->max_users); ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="max_products">Max Products</label>
                            <input type="number" class="form-control" id="max_products" name="max_products" value="<?php echo e($plan->max_products); ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="features">Features (JSON)</label>
                            <textarea class="form-control" id="features" name="features"><?php echo e($plan->features); ?></textarea>
                        </div>
                        <div class="form-group">
                            <label for="is_active">Active</label>
                            <input type="checkbox" id="is_active" name="is_active" value="1" <?php echo e($plan->is_active ? 'checked' : ''); ?>>
                        </div>
                        <button type="submit" class="btn btn-primary">Update</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/quickphone/public_html/bh.quickphone.us/pos/resources/views/admin/plans/edit.blade.php ENDPATH**/ ?>