<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Profit & Loss Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            color: #333;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
        }
        .header h1 {
            margin: 0;
            color: #333;
        }
        .period {
            margin-bottom: 20px;
            font-weight: bold;
        }
        .summary {
            display: table;
            width: 100%;
            margin-bottom: 30px;
        }
        .summary-row {
            display: table-row;
        }
        .summary-cell {
            display: table-cell;
            padding: 10px;
            border: 1px solid #ddd;
            text-align: center;
        }
        .summary-cell h3 {
            margin: 0;
            font-size: 18px;
        }
        .statement {
            margin-bottom: 30px;
        }
        .statement table {
            width: 100%;
            border-collapse: collapse;
        }
        .statement th,
        .statement td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        .statement th {
            background-color: #f5f5f5;
            font-weight: bold;
        }
        .statement .total-row {
            font-weight: bold;
            background-color: #e9ecef;
        }
        .statement .revenue-row {
            background-color: #d1ecf1;
        }
        .statement .cogs-row {
            background-color: #fff3cd;
        }
        .statement .gross-row {
            background-color: #d4edda;
        }
        .statement .expense-row {
            background-color: #f8d7da;
        }
        .statement .net-row {
            background-color: #d1ecf1;
        }
        .positive {
            color: #28a745;
        }
        .negative {
            color: #dc3545;
        }
        .top-products {
            margin-top: 30px;
        }
        .top-products h3 {
            margin-bottom: 15px;
        }
        .top-products table {
            width: 100%;
            border-collapse: collapse;
        }
        .top-products th,
        .top-products td {
            border: 1px solid #ddd;
            padding: 6px;
            text-align: left;
        }
        .top-products th {
            background-color: #f5f5f5;
            font-weight: bold;
        }
        .footer {
            margin-top: 50px;
            text-align: center;
            font-size: 10px;
            color: #666;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Profit & Loss Statement</h1>
        <div class="period">
            Period: <?php echo e($data['filterDate'] === 'all' ? 'All Time' : ($data['filterDate'] === 'custom' ? $data['startDate'] . ' to ' . $data['endDate'] : ucfirst(str_replace('_', ' ', $data['filterDate'])))); ?>

        </div>
    </div>

    <!-- Summary Cards -->
    <div class="summary">
        <div class="summary-row">
            <div class="summary-cell">
                <h4>Total Revenue</h4>
                <h3>BHD <?php echo e(number_format($data['totalRevenue'], 2)); ?></h3>
            </div>
            <div class="summary-cell">
                <h4>Gross Profit</h4>
                <h3 class="<?php echo e($data['grossProfit'] >= 0 ? 'positive' : 'negative'); ?>">BHD <?php echo e(number_format($data['grossProfit'], 2)); ?></h3>
            </div>
            <div class="summary-cell">
                <h4>Total Expenses</h4>
                <h3>BHD <?php echo e(number_format($data['totalExpenses'], 2)); ?></h3>
            </div>
            <div class="summary-cell">
                <h4>Net Profit</h4>
                <h3 class="<?php echo e($data['netProfit'] >= 0 ? 'positive' : 'negative'); ?>">BHD <?php echo e(number_format($data['netProfit'], 2)); ?></h3>
            </div>
        </div>
    </div>

    <!-- Detailed P&L Statement -->
    <div class="statement">
        <h3>Profit & Loss Statement</h3>
        <table>
            <thead>
                <tr>
                    <th>Description</th>
                    <th style="text-align: right;">Amount (BHD)</th>
                </tr>
            </thead>
            <tbody>
                <tr class="revenue-row">
                    <td><strong>Revenue</strong></td>
                    <td style="text-align: right;"><strong><?php echo e(number_format($data['totalRevenue'], 2)); ?></strong></td>
                </tr>
                <tr>
                    <td>&nbsp;&nbsp;&nbsp;&nbsp;Sales Revenue</td>
                    <td style="text-align: right;"><?php echo e(number_format($data['totalRevenue'] - $data['totalRevenueFromDirectSales'], 2)); ?></td>
                </tr>
                <tr>
                    <td>&nbsp;&nbsp;&nbsp;&nbsp;Direct Sales Revenue</td>
                    <td style="text-align: right;"><?php echo e(number_format($data['totalRevenueFromDirectSales'], 2)); ?></td>
                </tr>
                <tr class="cogs-row">
                    <td><strong>Cost of Goods Sold</strong></td>
                    <td style="text-align: right;"><strong><?php echo e(number_format($data['totalCOGS'], 2)); ?></strong></td>
                </tr>
                <tr class="gross-row">
                    <td><strong>Gross Profit</strong></td>
                    <td style="text-align: right;" class="<?php echo e($data['grossProfit'] >= 0 ? 'positive' : 'negative'); ?>">
                        <strong><?php echo e(number_format($data['grossProfit'], 2)); ?></strong>
                    </td>
                </tr>
                <tr class="expense-row">
                    <td><strong>Operating Expenses</strong></td>
                    <td style="text-align: right;"><strong><?php echo e(number_format($data['totalExpenses'], 2)); ?></strong></td>
                </tr>
                <tr class="net-row">
                    <td><strong>Net Profit</strong></td>
                    <td style="text-align: right;" class="<?php echo e($data['netProfit'] >= 0 ? 'positive' : 'negative'); ?>">
                        <strong><?php echo e(number_format($data['netProfit'], 2)); ?></strong>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>

    <!-- Top Products -->
    <div class="top-products">
        <h3>Top Selling Products</h3>
        <table>
            <thead>
                <tr>
                    <th>Product</th>
                    <th>Total Sold</th>
                    <th>Total Profit (BHD)</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $data['topProducts']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e($product->product->name ?? 'N/A'); ?></td>
                    <td><?php echo e($product->total_sold); ?></td>
                    <td class="positive"><?php echo e(number_format($product->total_profit, 2)); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="3" style="text-align: center;">No data available</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <div class="footer">
        <p>Report generated on <?php echo e(now()->format('d/m/Y H:i:s')); ?></p>
    </div>
</body>
</html>
<?php /**PATH /home/quickphone/public_html/bh.quickphone.us/pos/resources/views/reports/profit-loss-pdf.blade.php ENDPATH**/ ?>