

<?php $__env->startSection('main'); ?>
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Edit Subscription</h3>
                    </div>
                    <div class="card-body">
                        <form action="<?php echo e(route('subscriptions.update', $subscription)); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            <div class="form-group">
                                <label for="plan_id">Plan</label>
                                <select class="form-control" id="plan_id" name="plan_id" required>
                                    <?php $__currentLoopData = \App\Models\Plan::where('is_active', true)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($plan->id); ?>"
                                            <?php echo e($subscription->plan_id == $plan->id ? 'selected' : ''); ?>><?php echo e($plan->name); ?>

                                            - $<?php echo e($plan->price); ?>/<?php echo e($plan->interval); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="start_date">Start Date</label>
                                <input type="date" class="form-control" id="start_date" name="start_date"
                                    value="<?php echo e($subscription->start_date ? \Carbon\Carbon::parse($subscription->start_date)->format('Y-m-d') : ''); ?>"
                                    required>
                            </div>
                            <div class="form-group">
                                <label for="end_date">End Date</label>
                                <input type="date" class="form-control" id="end_date" name="end_date"
                                    value="<?php echo e($subscription->end_date ? \Carbon\Carbon::parse($subscription->end_date)->format('Y-m-d') : ''); ?>">
                            </div>
                            <div class="form-group">
                                <label for="status">Status</label>
                                <select class="form-control" id="status" name="status" required>
                                    <option value="active" <?php echo e($subscription->status == 'active' ? 'selected' : ''); ?>>Active
                                    </option>
                                    <option value="cancelled" <?php echo e($subscription->status == 'cancelled' ? 'selected' : ''); ?>>
                                        Cancelled</option>
                                    <option value="expired" <?php echo e($subscription->status == 'expired' ? 'selected' : ''); ?>>
                                        Expired</option>
                                </select>
                            </div>
                            <button type="submit" class="btn btn-primary">Update</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/quickphone/public_html/bh.quickphone.us/pos/resources/views/admin/subscriptions/edit.blade.php ENDPATH**/ ?>