

<?php $__env->startSection('title', 'Invoice View'); ?>

<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
    <!-- Content Header -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Invoice #<?php echo e($sale->id); ?></h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Home</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(route('sales.index')); ?>">Sales</a></li>
                        <li class="breadcrumb-item active">Invoice #<?php echo e($sale->id); ?></li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Invoice Actions -->
                    <div class="card mb-3">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <h4>Invoice Actions</h4>
                                </div>
                                <div class="col-md-6 text-right">
                                    <div class="btn-group" role="group">
                                        <a href="<?php echo e(route('sales.table.invoice', $sale->id)); ?>" 
                                           class="btn btn-primary" target="_blank">
                                            <i class="fas fa-print mr-2"></i>Print Invoice
                                        </a>
                                        <a href="<?php echo e(route('sales.edit', $sale->id)); ?>" 
                                           class="btn btn-warning">
                                            <i class="fas fa-edit mr-2"></i>Edit Sale
                                        </a>
                                        <?php echo $__env->make('whatsapp.send-button', [
                                            'type' => 'invoice', 
                                            'data' => $sale,
                                            'size' => 'md'
                                        ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                                        <a href="<?php echo e(route('sales.index')); ?>" 
                                           class="btn btn-secondary">
                                            <i class="fas fa-arrow-left mr-2"></i>Back to Sales
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Invoice Details -->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-file-invoice mr-2"></i>Invoice Details
                            </h3>
                        </div>
                        <div class="card-body">
                            <!-- Company Info & Invoice Info -->
                            <div class="row mb-4">
                                <div class="col-md-6">
                                    <h5 class="mb-3">
                                        <i class="fas fa-building mr-2"></i><?php echo e(config('app.name', 'POS System')); ?>

                                    </h5>
                                    <address>
                                        <strong><?php echo e(config('app.name', 'POS System')); ?></strong><br>
                                        123 Business Street<br>
                                        Business City, BC 12345<br>
                                        Phone: (123) 456-7890<br>
                                        Email: info@possystem.com
                                    </address>
                                </div>
                                <div class="col-md-6 text-right">
                                    <h5 class="mb-3">Invoice Information</h5>
                                    <p>
                                        <strong>Invoice #:</strong> <?php echo e($sale->id); ?><br>
                                        <strong>Date:</strong> <?php echo e($sale->created_at->format('M d, Y h:i A')); ?><br>
                                        <strong>Status:</strong> 
                                        <?php if($sale->payment_status == 'paid'): ?>
                                            <span class="badge badge-success">Paid</span>
                                        <?php elseif($sale->payment_status == 'partial'): ?>
                                            <span class="badge badge-warning">Partial Payment</span>
                                        <?php else: ?>
                                            <span class="badge badge-danger">Unpaid</span>
                                        <?php endif; ?>
                                    </p>
                                </div>
                            </div>

                            <!-- Customer Info -->
                            <div class="row mb-4">
                                <div class="col-md-6">
                                    <h5 class="mb-3">
                                        <i class="fas fa-user mr-2"></i>Bill To:
                                    </h5>
                                    <?php if($sale->customer): ?>
                                        <address>
                                            <strong><?php echo e($sale->customer->name); ?></strong><br>
                                            <?php if($sale->customer->address): ?>
                                                <?php echo e($sale->customer->address); ?><br>
                                            <?php endif; ?>
                                            <?php if($sale->customer->phone): ?>
                                                Phone: <?php echo e($sale->customer->phone); ?><br>
                                            <?php endif; ?>
                                            <?php if($sale->customer->email): ?>
                                                Email: <?php echo e($sale->customer->email); ?>

                                            <?php endif; ?>
                                        </address>
                                    <?php else: ?>
                                        <p class="text-muted">Walk-in Customer</p>
                                    <?php endif; ?>
                                </div>
                                <div class="col-md-6 text-right">
                                    <h5 class="mb-3">Payment Information</h5>
                                    <p>
                                        <strong>Payment Method:</strong> <?php echo e(ucfirst($sale->payment_method ?? 'Cash')); ?><br>
                                        <strong>Total Amount:</strong> $<?php echo e(number_format($sale->total_amount, 2)); ?><br>
                                        <strong>Paid Amount:</strong> $<?php echo e(number_format($sale->paid_amount ?? 0, 2)); ?><br>
                                        <?php if($sale->due_amount > 0): ?>
                                            <strong class="text-danger">Due Amount:</strong> $<?php echo e(number_format($sale->due_amount, 2)); ?>

                                        <?php endif; ?>
                                    </p>
                                </div>
                            </div>

                            <!-- Items Table -->
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead class="thead-light">
                                        <tr>
                                            <th>#</th>
                                            <th>Product</th>
                                            <th>Description</th>
                                            <th class="text-center">Qty</th>
                                            <th class="text-right">Unit Price</th>
                                            <th class="text-right">Total</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__empty_1 = true; $__currentLoopData = $sale->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <tr>
                                                <td><?php echo e($index + 1); ?></td>
                                                <td>
                                                    <strong><?php echo e($item->product_name ?? $item->product->name ?? 'Unknown Product'); ?></strong>
                                                    <?php if($item->product && $item->product->brand): ?>
                                                        <br><small class="text-muted">Brand: <?php echo e($item->product->brand->name); ?></small>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <?php if($item->product && $item->product->description): ?>
                                                        <?php echo e(Str::limit($item->product->description, 100)); ?>

                                                    <?php else: ?>
                                                        <span class="text-muted">No description</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td class="text-center"><?php echo e($item->quantity); ?></td>
                                                <td class="text-right">$<?php echo e(number_format($item->unit_price, 2)); ?></td>
                                                <td class="text-right">$<?php echo e(number_format($item->total_price, 2)); ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <tr>
                                                <td colspan="6" class="text-center">No items found</td>
                                            </tr>
                                        <?php endif; ?>
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="5" class="text-right"><strong>Subtotal:</strong></td>
                                            <td class="text-right"><strong>$<?php echo e(number_format($sale->subtotal ?? $sale->total_amount, 2)); ?></strong></td>
                                        </tr>
                                        <?php if($sale->tax_amount > 0): ?>
                                            <tr>
                                                <td colspan="5" class="text-right">Tax:</td>
                                                <td class="text-right">$<?php echo e(number_format($sale->tax_amount, 2)); ?></td>
                                            </tr>
                                        <?php endif; ?>
                                        <?php if($sale->discount_amount > 0): ?>
                                            <tr>
                                                <td colspan="5" class="text-right">Discount:</td>
                                                <td class="text-right">-$<?php echo e(number_format($sale->discount_amount, 2)); ?></td>
                                            </tr>
                                        <?php endif; ?>
                                        <tr class="table-active">
                                            <td colspan="5" class="text-right"><strong>Total Amount:</strong></td>
                                            <td class="text-right"><strong>$<?php echo e(number_format($sale->total_amount, 2)); ?></strong></td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>

                            <!-- Notes -->
                            <?php if($sale->notes): ?>
                                <div class="row mt-4">
                                    <div class="col-12">
                                        <h5>Notes:</h5>
                                        <p class="text-muted"><?php echo e($sale->notes); ?></p>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <!-- Terms & Conditions -->
                            <div class="row mt-4">
                                <div class="col-12">
                                    <h6>Terms & Conditions:</h6>
                                    <p class="text-muted small">
                                        Thank you for your business! Payment is due within 30 days of invoice date.
                                        A late fee of 1.5% per month will be applied to overdue accounts.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
$(document).ready(function() {
    // Auto-focus on print button for easy printing
    setTimeout(function() {
        $('.btn-group .btn-primary').focus();
    }, 500);
});
</script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
<style>
.invoice-header {
    border-bottom: 3px solid #007bff;
    padding-bottom: 20px;
    margin-bottom: 30px;
}

.invoice-info {
    background-color: #f8f9fa;
    padding: 15px;
    border-radius: 5px;
    margin-bottom: 20px;
}

.table-invoice {
    margin-bottom: 0;
}

.table-invoice th {
    background-color: #343a40;
    color: white;
    border-color: #454d55;
}

address {
    line-height: 1.6;
}

.card {
    box-shadow: 0 0 10px rgba(0,0,0,.1);
}

@media print {
    .btn-group, .card-header, .breadcrumb, .content-header {
        display: none !important;
    }
    
    .content-wrapper {
        margin: 0 !important;
        padding: 0 !important;
    }
    
    .card {
        border: none !important;
        box-shadow: none !important;
    }
}
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/quickphone/public_html/bh.quickphone.us/pos/resources/views/sales/show.blade.php ENDPATH**/ ?>