<?php $__env->startPush('style'); ?>
<!-- Toastr CSS -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
<!-- Select2 CSS -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('main'); ?>
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Edit Sale #<?php echo e($sale->id); ?></h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Home</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(route('sales.history')); ?>">Sales History</a></li>
                        <li class="breadcrumb-item active">Edit Sale</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-edit mr-1"></i>
                                Edit Sale Information
                            </h3>
                            <div class="card-tools">
                                <a href="<?php echo e(route('sales.history')); ?>" class="btn btn-secondary btn-sm">
                                    <i class="fas fa-arrow-left"></i> Back to History
                                </a>
                            </div>
                        </div>
                        <div class="card-body">
                            <?php if(session('success')): ?>
                                <div class="alert alert-success alert-dismissible fade show" role="alert">
                                    <i class="fas fa-check-circle"></i> <?php echo e(session('success')); ?>

                                    <button type="button" class="close" data-dismiss="alert">
                                        <span>&times;</span>
                                    </button>
                                </div>
                            <?php endif; ?>

                            <?php if($errors->any()): ?>
                                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                    <i class="fas fa-exclamation-triangle"></i> Please fix the following errors:
                                    <ul class="mb-0 mt-2">
                                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><?php echo e($error); ?></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                    <button type="button" class="close" data-dismiss="alert">
                                        <span>&times;</span>
                                    </button>
                                </div>
                            <?php endif; ?>

                            <form action="<?php echo e(route('sales.update', $sale)); ?>" method="POST" id="editSaleForm">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PUT'); ?>

                                <div class="row">
                                    <!-- Customer Selection -->
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="customer_id" class="font-weight-bold">
                                                <i class="fas fa-user text-info"></i> Customer <span class="text-danger">*</span>
                                            </label>
                                            <select name="customer_id" id="customer_id" class="form-control select2" required>
                                                <option value="">Select Customer</option>
                                                <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($customer->id); ?>" <?php echo e($customer->id == $sale->customer_id ? 'selected' : ''); ?>>
                                                        <?php echo e($customer->name); ?> - <?php echo e($customer->phone ?? 'No Phone'); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>

                                    <!-- Payment Method -->
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="payment_method" class="font-weight-bold">
                                                <i class="fas fa-credit-card text-success"></i> Payment Method <span class="text-danger">*</span>
                                            </label>
                                            <select name="payment_method" id="payment_method" class="form-control" required>
                                                <option value="cash" <?php echo e($sale->payment_method == 'cash' ? 'selected' : ''); ?>>Cash</option>
                                                <option value="credit" <?php echo e($sale->payment_method == 'credit' ? 'selected' : ''); ?>>Credit</option>
                                                <option value="card" <?php echo e($sale->payment_method == 'card' ? 'selected' : ''); ?>>Card</option>
                                                <option value="bank_transfer" <?php echo e($sale->payment_method == 'bank_transfer' ? 'selected' : ''); ?>>Bank Transfer</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <!-- Products Section -->
                                <div class="row">
                                    <div class="col-12">
                                        <div class="form-group">
                                            <label class="font-weight-bold">
                                                <i class="fas fa-shopping-cart text-warning"></i> Products <span class="text-danger">*</span>
                                            </label>
                                            <div class="card">
                                                <div class="card-body">
                                                    <div id="product-list">
                                                        <?php $transactions = $sale->sellTransactions; ?>
                                                        <?php if($transactions && $transactions->count() > 0): ?>
                                                            <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <div class="product-row mb-3 p-3 border rounded" data-index="<?php echo e($index); ?>">
                                                                    <div class="row">
                                                                        <div class="col-md-4">
                                                                            <label>Product</label>
                                                                            <select name="products[<?php echo e($index); ?>][id]" class="form-control product-select" required>
                                                                                <option value="">Select Product</option>
                                                                                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prod): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                    <option value="<?php echo e($prod->id); ?>" 
                                                                                        <?php echo e($prod->id == $transaction->product_id ? 'selected' : ''); ?>

                                                                                        data-price="<?php echo e($prod->sell_price); ?>"
                                                                                        data-stock="<?php echo e($prod->quantity); ?>">
                                                                                        <?php echo e($prod->name); ?> - BHD <?php echo e($prod->sell_price); ?> (Stock: <?php echo e($prod->quantity); ?>)
                                                                                    </option>
                                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                            </select>
                                                                        </div>
                                                                        <div class="col-md-2">
                                                                            <label>Quantity</label>
                                                                            <input type="number" name="products[<?php echo e($index); ?>][quantity]" 
                                                                                   value="<?php echo e($transaction->sold_quantity); ?>" 
                                                                                   class="form-control quantity-input" 
                                                                                   min="1" required>
                                                                        </div>
                                                                        <div class="col-md-2">
                                                                            <label>Unit Price</label>
                                                                            <input type="number" name="products[<?php echo e($index); ?>][price]" 
                                                                                   value="<?php echo e($transaction->sell_price); ?>" 
                                                                                   class="form-control price-input" 
                                                                                   min="0" step="0.01" required>
                                                                        </div>
                                                                        <div class="col-md-2">
                                                                            <label>Total</label>
                                                                            <input type="text" class="form-control total-display" 
                                                                                   value="BHD <?php echo e(number_format($transaction->sold_quantity * $transaction->sell_price, 2)); ?>" 
                                                                                   readonly>
                                                                        </div>
                                                                        <div class="col-md-2">
                                                                            <label>&nbsp;</label>
                                                                            <button type="button" class="btn btn-danger btn-block remove-product">
                                                                                <i class="fas fa-trash"></i> Remove
                                                                            </button>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        <?php else: ?>
                                                            <div class="alert alert-warning">
                                                                <i class="fas fa-exclamation-triangle"></i> No products found for this sale. Please add products.
                                                            </div>
                                                        <?php endif; ?>
                                                    </div>
                                                    <button type="button" id="add-product" class="btn btn-success">
                                                        <i class="fas fa-plus"></i> Add Product
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Sale Summary -->
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="card card-info">
                                            <div class="card-header">
                                                <h3 class="card-title">Sale Summary</h3>
                                            </div>
                                            <div class="card-body">
                                                <table class="table">
                                                    <tr>
                                                        <td><strong>Subtotal:</strong></td>
                                                        <td id="subtotal" class="text-right">BHD <?php echo e(number_format($sale->total_amount, 2)); ?></td>
                                                    </tr>
                                                    <tr>
                                                        <td><strong>Tax (if any):</strong></td>
                                                        <td id="tax" class="text-right">BHD 0.00</td>
                                                    </tr>
                                                    <tr class="table-active">
                                                        <td><strong>Total:</strong></td>
                                                        <td id="total" class="text-right"><strong>BHD <?php echo e(number_format($sale->total_amount, 2)); ?></strong></td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="card card-secondary">
                                            <div class="card-header">
                                                <h3 class="card-title">Sale Information</h3>
                                            </div>
                                            <div class="card-body">
                                                <p><strong>Sale ID:</strong> #<?php echo e($sale->id); ?></p>
                                                <p><strong>Created:</strong> <?php echo e($sale->created_at->format('d M Y, H:i A')); ?></p>
                                                <p><strong>Payment Status:</strong> 
                                                    <span class="badge badge-<?php echo e($sale->payment_status == 'paid' ? 'success' : ($sale->payment_status == 'partial' ? 'warning' : 'danger')); ?>">
                                                        <?php echo e(ucfirst($sale->payment_status)); ?>

                                                    </span>
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Submit Buttons -->
                                <div class="row">
                                    <div class="col-12">
                                        <div class="form-group text-right">
                                            <button type="button" class="btn btn-secondary mr-2" onclick="window.history.back()">
                                                <i class="fas fa-times"></i> Cancel
                                            </button>
                                            <button type="submit" class="btn btn-primary" id="updateSaleBtn">
                                                <i class="fas fa-save"></i> Update Sale
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<!-- Toastr JavaScript -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
<!-- Select2 JavaScript -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
<!-- Notification System -->
<script src="<?php echo e(asset('assets/js/notification-system.js')); ?>"></script>

<script>
$(document).ready(function() {
    // Initialize notification system
    let notificationSystem = new NotificationSystem();
    
    // Initialize Select2
    $('.select2').select2({
        theme: 'bootstrap4',
        width: '100%'
    });
    
    let productIndex = <?php echo e($transactions ? $transactions->count() : 0); ?>;
    
    // Add product functionality
    $('#add-product').click(function() {
        const productRow = `
            <div class="product-row mb-3 p-3 border rounded" data-index="${productIndex}">
                <div class="row">
                    <div class="col-md-4">
                        <label>Product</label>
                        <select name="products[${productIndex}][id]" class="form-control product-select" required>
                            <option value="">Select Product</option>
                            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prod): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($prod->id); ?>" data-price="<?php echo e($prod->sell_price); ?>" data-stock="<?php echo e($prod->quantity); ?>">
                                    <?php echo e($prod->name); ?> - BHD <?php echo e($prod->sell_price); ?> (Stock: <?php echo e($prod->quantity); ?>)
                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label>Quantity</label>
                        <input type="number" name="products[${productIndex}][quantity]" value="1" class="form-control quantity-input" min="1" required>
                    </div>
                    <div class="col-md-2">
                        <label>Unit Price</label>
                        <input type="number" name="products[${productIndex}][price]" value="0" class="form-control price-input" min="0" step="0.01" required>
                    </div>
                    <div class="col-md-2">
                        <label>Total</label>
                        <input type="text" class="form-control total-display" value="BHD 0.00" readonly>
                    </div>
                    <div class="col-md-2">
                        <label>&nbsp;</label>
                        <button type="button" class="btn btn-danger btn-block remove-product">
                            <i class="fas fa-trash"></i> Remove
                        </button>
                    </div>
                </div>
            </div>
        `;
        $('#product-list').append(productRow);
        productIndex++;
        calculateTotal();
    });
    
    // Remove product functionality
    $(document).on('click', '.remove-product', function() {
        if ($('.product-row').length > 1) {
            $(this).closest('.product-row').remove();
            calculateTotal();
        } else {
            toastr.warning('At least one product is required for a sale');
        }
    });
    
    // Auto-fill price when product is selected
    $(document).on('change', '.product-select', function() {
        const selectedOption = $(this).find('option:selected');
        const price = selectedOption.data('price') || 0;
        const stock = selectedOption.data('stock') || 0;
        
        const row = $(this).closest('.product-row');
        row.find('.price-input').val(price);
        
        // Update quantity max based on stock
        const quantityInput = row.find('.quantity-input');
        quantityInput.attr('max', stock);
        
        if (parseInt(quantityInput.val()) > stock) {
            quantityInput.val(stock);
            toastr.warning(`Only ${stock} items available in stock`);
        }
        
        calculateRowTotal(row);
    });
    
    // Calculate row total when quantity or price changes
    $(document).on('input', '.quantity-input, .price-input', function() {
        const row = $(this).closest('.product-row');
        calculateRowTotal(row);
    });
    
    function calculateRowTotal(row) {
        const quantity = parseInt(row.find('.quantity-input').val()) || 0;
        const price = parseFloat(row.find('.price-input').val()) || 0;
        const total = quantity * price;
        
        row.find('.total-display').val(`BHD ${total.toFixed(2)}`);
        calculateTotal();
    }
    
    function calculateTotal() {
        let subtotal = 0;
        $('.product-row').each(function() {
            const quantity = parseInt($(this).find('.quantity-input').val()) || 0;
            const price = parseFloat($(this).find('.price-input').val()) || 0;
            subtotal += quantity * price;
        });
        
        const tax = 0; // You can add tax calculation here if needed
        const total = subtotal + tax;
        
        $('#subtotal').text(`BHD ${subtotal.toFixed(2)}`);
        $('#tax').text(`BHD ${tax.toFixed(2)}`);
        $('#total').text(`BHD ${total.toFixed(2)}`);
    }
    
    // Form submission with loading state
    $('#editSaleForm').on('submit', function() {
        const btn = $('#updateSaleBtn');
        btn.prop('disabled', true);
        btn.html('<i class="fas fa-spinner fa-spin"></i> Updating...');
    });
    
    // Initialize calculations on page load
    $('.product-row').each(function() {
        calculateRowTotal($(this));
    });
    
    console.log('Sales edit form initialized successfully!');
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/quickphone/public_html/bh.quickphone.us/pos/resources/views/sales/edit.blade.php ENDPATH**/ ?>