<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Receipt</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            text-align: center;
            padding: 0;
            background-color: #f4f4f4;
            color: #333;
        }
        .container {
            max-width: 600px;
            margin: 20px auto;
            background: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        }
        .header {
            border-bottom: 2px solid #000;
            padding-bottom: 10px;
            margin-bottom: 20px;
        }
        .header h2 {
            margin: 0;
            font-size: 20px;
            color: #000;
        }
        .header p {
            margin: 5px 0;
            font-size: 14px;
        }
        .section {
            margin-bottom: 20px;
        }
        .section h3 {
            font-size: 16px;
            margin-bottom: 10px;
            color: #000;
            border-bottom: 1px solid #ddd;
            padding-bottom: 5px;
        }
        .section p {
            margin: 5px 0;
            font-size: 14px;
        }
        .section p strong {
            color: #000;
        }
        .footer {
            font-size: 14px;
            color: #555;
            margin-top: 20px;
        }
        .footer p {
            margin: 5px 0;
        }
        a {
            color: #007BFF;
            text-decoration: none;
        }
        a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h2>QUICK PHONE REPAIR</h2>
            <p>Online Quick Repair WLL</p>
            <p>Number: 39174200</p>
            <p>Web: <a href="http://www.quickphone.us" target="_blank">www.quickphone.us</a></p>
            <p>Address: Manama, Goldcity Near, Road 445, Block 304, Building 2584</p>
        </div>

        <div class="section">
            <h3>Customer Information</h3>
            <p><strong>Name:</strong> Mr. <?php echo e($jobSheet->customer_name); ?></p>
            <p><strong>Number:</strong> <?php echo e($jobSheet->customer_number); ?></p>
        </div>

        <div class="section">
            <h3><i class="fas fa-mobile-alt"></i> Device Information</h3>
            <p><strong>Brand:</strong> <?php echo e($jobSheet->device_brand); ?></p>
            <p><strong>Model:</strong> <?php echo e($jobSheet->device_model); ?></p>
            <div style="border: 1px solid #ddd; padding: 10px; border-radius: 5px; background-color: #f9f9f9; display: flex; align-items: center; justify-content: center;">
                <i class="fas fa-tools" style="font-size: 20px; margin-right: 10px; color: #007BFF;"></i>
                <i class="fas fa-phone" style="font-size: 20px; margin-right: 10px; color: #28a745;"></i>
                <p style="margin: 0;"><strong>Problem:</strong> <?php echo e($jobSheet->problem); ?></p>
            </div>
            <p><strong>Status:</strong> <?php echo e(ucfirst($jobSheet->status)); ?></p>
        </div>

        <div class="section">
            <h3>Estimated Price</h3>
            <p><strong>Price:</strong> <?php echo e(number_format($jobSheet->price, 2)); ?> USD</p>
        </div>

        <div class="footer">
            <p>Thank you for visiting QUICK PHONE REPAIR!</p>
        </div>
    </div>
</body>
</html>
<?php /**PATH /home/quickphone/public_html/bh.quickphone.us/pos/resources/views/jobsheet/receipt.blade.php ENDPATH**/ ?>