<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Register - SaaS POS</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
    <div class="container">
        <div class="row justify-content-center mt-5">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h3 class="text-center">Create Your SaaS Account</h3>
                    </div>
                    <div class="card-body">
                        <?php if($errors->any()): ?>
                            <div class="alert alert-danger">
                                <ul class="mb-0">
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>

                        <form method="POST" action="<?php echo e(route('register')); ?>">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-md-6">
                                    <h5>User Information</h5>
                                    <div class="mb-3">
                                        <label for="name" class="form-label">Full Name</label>
                                        <input type="text" class="form-control" id="name" name="name" value="<?php echo e(old('name')); ?>" required>
                                    </div>
                                    <div class="mb-3">
                                        <label for="email" class="form-label">Email Address</label>
                                        <input type="email" class="form-control" id="email" name="email" value="<?php echo e(old('email')); ?>" required>
                                    </div>
                                    <div class="mb-3">
                                        <label for="password" class="form-label">Password</label>
                                        <input type="password" class="form-control" id="password" name="password" required>
                                    </div>
                                    <div class="mb-3">
                                        <label for="password_confirmation" class="form-label">Confirm Password</label>
                                        <input type="password" class="form-control" id="password_confirmation" name="password_confirmation" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <h5>Tenant Information</h5>
                                    <div class="mb-3">
                                        <label for="tenant_name" class="form-label">Organization Name</label>
                                        <input type="text" class="form-control" id="tenant_name" name="tenant_name" value="<?php echo e(old('tenant_name')); ?>" required>
                                    </div>
                                    <div class="mb-3">
                                        <label for="tenant_domain" class="form-label">Domain</label>
                                        <input type="text" class="form-control" id="tenant_domain" name="tenant_domain" value="<?php echo e(old('tenant_domain')); ?>" required>
                                        <div class="form-text">e.g., yourcompany.com</div>
                                    </div>
                                    <div class="mb-3">
                                        <label for="tenant_subdomain" class="form-label">Subdomain (Optional)</label>
                                        <input type="text" class="form-control" id="tenant_subdomain" name="tenant_subdomain" value="<?php echo e(old('tenant_subdomain')); ?>">
                                        <div class="form-text">e.g., yourcompany (for yourcompany.yoursaas.com)</div>
                                    </div>
                                </div>
                            </div>
                            <div class="d-grid">
                                <button type="submit" class="btn btn-success">Create Account & Tenant</button>
                            </div>
                        </form>
                    </div>
                    <div class="card-footer text-center">
                        <p class="mb-0">Already have an account? <a href="<?php echo e(route('login')); ?>">Login here</a></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php /**PATH /home/quickphone/public_html/bh.quickphone.us/pos/resources/views/auth/register.blade.php ENDPATH**/ ?>