<!-- resources/views/jobsheet/create.blade.php -->


<?php $__env->startSection('main'); ?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Job Sheets Report</title>
</head>
<body>
    <h1>Job Sheets Report</h1>
    <table border="1">
        <thead>
            <tr>
                <th>Customer Name</th>
                <th>Customer Number</th>
                <th>Device Brand</th>
                <th>Device Model</th>
                <th>Problem</th>
                <th>Status</th>
                <th>Phone Picture</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $jobSheets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $jobSheet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($jobSheet->customer_name); ?></td>
                    <td><?php echo e($jobSheet->customer_number); ?></td>
                    <td><?php echo e($jobSheet->device_brand); ?></td>
                    <td><?php echo e($jobSheet->device_model); ?></td>
                    <td><?php echo e($jobSheet->problem); ?></td>
                    <td><?php echo e($jobSheet->status); ?></td>
                    <td>
                        <?php if($jobSheet->phone_picture): ?>
                            <img src="<?php echo e(asset('storage/' . $jobSheet->phone_picture)); ?>" alt="Phone Picture" width="100">
                        <?php else: ?>
                            No Image
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</body>
</html>

    <div>
        <p>Customer Name: <?php echo e($jobSheet->customer_name); ?></p>
        <p>Device Model: <?php echo e($jobSheet->device_model); ?></p>
        <p>Status: <?php echo e($jobSheet->status); ?></p>
        <!-- Link to the invoice page -->
        <a href="<?php echo e(route('jobsheet.invoice', $jobSheet->id)); ?>" target="_blank">Print Invoice</a>
    </div>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/quickphone/public_html/bh.quickphone.us/pos/resources/views/jobsheet/report.blade.php ENDPATH**/ ?>