

<?php $__env->startSection('main'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Subscriptions</h3>
                    <a href="<?php echo e(route('subscriptions.create')); ?>" class="btn btn-primary float-right">Create Subscription</a>
                </div>
                <div class="card-body">
                    <?php if(session('success')): ?>
                        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
                    <?php endif; ?>
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Tenant</th>
                                <th>Plan</th>
                                <th>Status</th>
                                <th>Start Date</th>
                                <th>End Date</th>
                                <th>Price</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $subscriptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subscription): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($subscription->id); ?></td>
                            <td><?php echo e($subscription->tenant->name ?? 'N/A'); ?></td>
                            <td><?php echo e($subscription->plan->name ?? 'N/A'); ?></td>
                            <td><?php echo e($subscription->status); ?></td>
                            <td><?php echo e($subscription->start_date); ?></td>
                            <td><?php echo e($subscription->end_date); ?></td>
                            <td>$<?php echo e($subscription->price); ?></td>
                            <td>
                                <a href="<?php echo e(route('subscriptions.show', $subscription)); ?>" class="btn btn-info btn-sm">View</a>
                                <a href="<?php echo e(route('subscriptions.edit', $subscription)); ?>" class="btn btn-warning btn-sm">Edit</a>
                                <?php if($subscription->status == 'pending'): ?>
                                <form action="<?php echo e(route('subscriptions.approve', $subscription)); ?>" method="POST" style="display:inline;">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="btn btn-success btn-sm" onclick="return confirm('Approve this subscription?')">Approve</button>
                                </form>
                                <?php endif; ?>
                                <form action="<?php echo e(route('subscriptions.destroy', $subscription)); ?>" method="POST" style="display:inline;">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')">Delete</button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/quickphone/public_html/bh.quickphone.us/test/resources/views/admin/subscriptions/index.blade.php ENDPATH**/ ?>