

<?php $__env->startPush('style'); ?>
    <style>
        /* Style for the exchange fields */
        #exchange_fields {
            display: none;
            margin-top: 20px;
        }

        #exchange_fields .form-group {
            margin-bottom: 15px;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('main'); ?>
    <div class="container mt-5">
        <h1 class="mb-4">Sell Product</h1>

        <?php if(session('error')): ?>
            <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
        <?php endif; ?>

        <div class="card shadow-sm mb-4">
            <div class="card-header bg-primary text-white">
                <h5 class="card-title mb-0">Product Details</h5>
            </div>
            <div class="card-body">
                <?php if($product->brand): ?>
                    <p><strong>Brand:</strong> <?php echo e($product->brand); ?></p>
                <?php endif; ?>
                <?php if($product->model): ?>
                    <p><strong>Model:</strong> <?php echo e($product->model); ?></p>
                <?php endif; ?>
                <?php if($product->type): ?>
                    <p><strong>Product category:</strong> <?php echo e($product->type); ?></p>
                <?php endif; ?>
                <?php if($product->name): ?>
                    <p><strong>Product Name:</strong> <?php echo e($product->name); ?></p>
                <?php endif; ?>
                <?php if($product->stock): ?>
                    <p><strong>Stock:</strong> <?php echo e($product->stock); ?></p>
                <?php endif; ?>
            </div>
        </div>

        <form action="<?php echo e(route('sell.process', $product->id)); ?>" method="POST">
            <?php echo csrf_field(); ?>

            <div class="form-group">
                <label for="customer_search">Customer Name:</label>
                <input type="text" class="form-control" name="customer_name" id="customer_search" required>
                <div id="customer_results" class="search-results"></div>
            </div>

            <button type="button" class="btn btn-outline-primary mb-3" data-toggle="modal" data-target="#modal-add-customer">
                <i class="fas fa-plus"></i> Add New Customer
            </button>

            <div class="form-group">
                <label for="sell_price">Selling Price:</label>
                <input type="number" step="0.01" class="form-control" name="sell_price" required>
            </div>

            <div class="form-group">
                <label for="sold_quantity">Quantity Sold:</label>
                <input type="number" class="form-control" value="1" id="qty" name="sold_quantity" required>
            </div>

            <div class="form-group">
                <label for="warranty">Warranty:</label>
                <select class="form-control" name="warranty" id="warranty">
                    <option value="No Warranty">No Warranty</option>
                    <option value="1 Day">1 Day</option>
                    <option value="7 Days">7 Days</option>
                    <option value="1 Month">1 Month</option>
                    <option value="3 Months">3 Months</option>
                    <option value="6 Months">6 Months</option>
                    <option value="1 Year">1 Year</option>
                    <option value="Custom">Custom</option>
                </select>
            </div>

            <div id="customWarranty" class="form-group" style="display: none;">
                <label for="custom_warranty_value">Custom Warranty Value:</label>
                <input type="number" name="custom_warranty_value" class="form-control">
                <label for="custom_warranty_unit">Custom Warranty Unit:</label>
                <select name="custom_warranty_unit" class="form-control">
                    <option value="Days">Days</option>
                    <option value="Months">Months</option>
                    <option value="Years">Years</option>
                </select>
            </div>

           <!-- Exchange Product -->
<div class="form-group">
    <label for="exchange_product">Exchange Product:</label>
    <input type="text" class="form-control" name="exchange_product" id="exchange_product" placeholder="Search for exchange product">
    <!-- Button to open the Add Product Modal -->
    <button type="button" class="btn btn-outline-primary mt-2" data-toggle="modal" data-target="#modal-add-exchange-product">
        <i class="fas fa-plus"></i> Add New Product for Exchange
    </button>
</div>
--model exchange --
            <!-- Exchange Fields -->
            <div id="exchange_fields">
                <div class="form-group">
                    <label for="exchange_product">Exchange Product:</label>
                    <input type="text" class="form-control" name="exchange_product" id="exchange_product" placeholder="Search for exchange product">
                </div>

                <div class="form-group">
                    <label for="exchange_value">Exchange Value3:</label>
                    <input type="number" step="0.01" class="form-control" name="exchange_value" id="exchange_value" placeholder="Value of the exchanged product">
                </div>
            </div>

            <button type="submit" class="btn btn-success btn-block">Sell Product</button>
        </form>
    </div>
<!-- Add Product for Exchange Modal -->
<div class="modal fade" id="modal-add-exchange-product" tabindex="-1" role="dialog" aria-labelledby="modal-add-exchange-product-label" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modal-add-exchange-product-label">Add Exchange Product</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="product_form">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="brand">Product Brand:</label>
                        <input type="text" class="form-control" name="brand" id="brand" required>
                    </div>

                    <div class="form-group">
                        <label for="model">Produc Model:</label>
                        <input type="text" class="form-control" name="model" id="model" required>
                    </div>

                    <div class="form-group">
                        <label for="buy_price">Product Price:</label>
                        <input type="number" step="0.01" class="form-control" name="buy_price" id="buy_price" required>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Add Product</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

    
    <div class="modal fade" id="modal-add-customer" tabindex="-1" role="dialog" aria-labelledby="modal-add-customer-label" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modal-add-customer-label">Add New Customer</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="customer_form">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="customer_name">Customer Name:</label>
                            <input type="text" id="customer_name" class="form-control" name="customer_name" required>
                        </div>

                        <div class="form-group">
                            <label for="customer_number">Customer Number:</label>
                            <input type="tel" id="customer_number" class="form-control" name="customer_number" required>
                        </div>

                        <div class="form-group">
                            <label for="customer_cpr">Customer CPR:</label>
                            <input type="text" id="customer_cpr" class="form-control" name="customer_cpr">
                        </div>

                        <div class="form-group">
                            <label for="address">Address:</label>
                            <input type="text" id="address" class="form-control" name="address">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Save Customer</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        document.getElementById("warranty").addEventListener("change", function() {
            document.getElementById("customWarranty").style.display = this.value === "Custom" ? "block" : "none";
        });

        $("#customer_search").on("keyup", function() {
            let query = $(this).val().trim();
            if (query.length < 2) {
                $("#customer_results").html("").hide(); // Hide if query is too short
                return;
            }

            $.ajax({
                url: "<?php echo e(route('api.customers.search')); ?>",
                type: "GET",
                data: { query: query },
                success: function(response) {
                    let resultHTML = "";
                    if (response.length > 0) {
                        resultHTML += '<ul>';
                        $.each(response, function(index, customer) {
                            resultHTML += `
                                <li class="search-item" data-id="${customer.id}" data-name="${customer.name}" data-number="${customer.number}">
                                    <strong>${customer.name}</strong> - ${customer.number}
                                </li>`;
                        });
                        resultHTML += '</ul>';
                    } else {
                        resultHTML = '<p class="dropdown-item text-muted">No results found</p>';
                    }
                    $("#customer_results").html(resultHTML).show();
                }
            });
        });

        $(document).on("click", ".search-item", function() {
            let customerId = $(this).data("id");
            let customerName = $(this).data("name");
            let customerNumber = $(this).data("number");

            $("#customer_search").val(`${customerName} (${customerNumber})`);
            $("#customer_info").val(customerId);
            $("#customer_results").hide();
        });

        $(document).on("click", function(e) {
            if (!$(e.target).closest("#customer_search, #customer_results").length) {
                $("#customer_results").hide();
            }
        });

        // Toggle exchange fields visibility
        $('#exchange_checkbox').on('change', function() {
            if ($(this).is(':checked')) {
                $('#exchange_fields').show();
            } else {
                $('#exchange_fields').hide();
            }

        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/quickphone/public_html/bh.quickphone.us/pos/resources/views/sell/form.blade.php ENDPATH**/ ?>